@extends('layouts.modern')

@section('title', 'طباعة الباركود')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.index') }}">إدارة الباركود</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.print-multiple') }}">طباعة باركود متعدد</a></li>
        <li class="breadcrumb-item active">طباعة الباركود</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">طباعة الباركود</h3>
                    <div class="card-tools">
                        <button class="btn btn-primary btn-sm" onclick="window.print()">
                            <i class="fa fa-print"></i> طباعة
                        </button>
                        <a href="{{ route('inventory.barcodes.print-multiple') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="alert alert-info print-hide">
                                <i class="fa fa-info-circle"></i> اضغط على زر الطباعة لطباعة الباركود. سيتم تنسيق الصفحة تلقائياً للطباعة.
                            </div>
                            
                            <div class="barcode-grid">
                                @foreach($printItems as $printItem)
                                    <div class="barcode-item">
                                        <div class="barcode-svg">
                                            {!! $printItem['barcode_svg'] !!}
                                        </div>
                                        <div class="barcode-text">{{ $printItem['item']->barcode }}</div>
                                        <div class="item-info">
                                            <div class="item-name">{{ $printItem['item']->name }}</div>
                                            <div class="item-sku">{{ $printItem['item']->sku }}</div>
                                        </div>
                                    </div>
                                @endforeach
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
<style>
    .barcode-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 10px;
        justify-content: flex-start;
    }
    
    .barcode-item {
        border: 1px solid #ddd;
        padding: 10px;
        text-align: center;
        width: 200px;
        height: 120px;
        background-color: white;
        margin-bottom: 10px;
    }
    
    .barcode-svg {
        height: 50px;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    
    .barcode-svg svg {
        max-width: 100%;
        height: 40px;
    }
    
    .barcode-text {
        font-size: 12px;
        margin-top: 5px;
        font-weight: bold;
    }
    
    .item-info {
        margin-top: 5px;
    }
    
    .item-name {
        font-size: 10px;
        font-weight: bold;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .item-sku {
        font-size: 10px;
        color: #666;
    }
    
    @media print {
        .main-header, .main-sidebar, .main-footer, .card-tools, .breadcrumb, .print-hide {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        
        .card {
            box-shadow: none !important;
            border: none;
        }
        
        .card-header, .card-body {
            padding: 0 !important;
        }
        
        .barcode-grid {
            gap: 0;
        }
        
        .barcode-item {
            border: 1px dashed #ccc;
            page-break-inside: avoid;
            margin: 0;
            padding: 5px;
        }
        
        body {
            margin: 0;
            padding: 0;
        }
    }
</style>
@endsection