@extends('layouts.modern')

@section('title', 'طباعة الباركود المتعدد')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">طباعة الباركود المتعدد</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.advanced') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة
                        </a>
                        <button onclick="window.print();" class="btn btn-sm btn-primary">
                            <i class="fas fa-print"></i> طباعة
                        </button>
                    </div>
                </div>
                <div class="card-body">
                    <div class="barcode-sheet">
                        @foreach($barcode_items as $barcodeItem)
                            @for($i = 0; $i < $barcodeItem['quantity']; $i++)
                                <div class="barcode-label {{ $label_template }}">
                                    @if($label_template == 'detailed' || $label_template == 'large')
                                        <div class="company-name">{{ $company->name }}</div>
                                    @endif
                                    
                                    <div class="item-name">{{ $barcodeItem['item']->name }}</div>
                                    
                                    @if($label_template != 'small')
                                        <div class="item-sku">{{ $barcodeItem['item']->sku }}</div>
                                    @endif
                                    
                                    <div class="barcode-image">
                                        <img src="{{ asset($barcodeItem['barcode_image']) }}" alt="باركود">
                                    </div>
                                    
                                    <div class="barcode-number">{{ $barcodeItem['item']->barcode }}</div>
                                    
                                    @if($include_price && ($label_template == 'detailed' || $label_template == 'standard'))
                                        <div class="item-price">{{ $barcodeItem['item']->selling_price }} ريال</div>
                                    @endif
                                    
                                    @if($label_template == 'detailed')
                                        <div class="item-category">{{ $barcodeItem['item']->category->name ?? 'غير مصنف' }}</div>
                                    @endif
                                </div>
                            @endfor
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    .barcode-sheet {
        display: flex;
        flex-wrap: wrap;
        justify-content: flex-start;
        gap: 10px;
        padding: 10px;
    }
    
    .barcode-label {
        border: 1px solid #ddd;
        border-radius: 5px;
        padding: 5px;
        text-align: center;
        background-color: white;
    }
    
    .barcode-label.standard {
        width: 200px;
        height: 120px;
    }
    
    .barcode-label.small {
        width: 100px;
        height: 80px;
        font-size: 0.8em;
    }
    
    .barcode-label.large {
        width: 300px;
        height: 180px;
    }
    
    .barcode-label.detailed {
        width: 300px;
        height: 200px;
    }
    
    .company-name {
        font-size: 0.8em;
        color: #666;
        margin-bottom: 3px;
    }
    
    .item-name {
        font-weight: bold;
        margin-bottom: 3px;
        white-space: nowrap;
        overflow: hidden;
        text-overflow: ellipsis;
    }
    
    .item-sku {
        font-size: 0.8em;
        color: #666;
        margin-bottom: 3px;
    }
    
    .barcode-image {
        margin: 5px 0;
    }
    
    .barcode-image img {
        max-width: 100%;
        max-height: 50px;
    }
    
    .barcode-number {
        font-size: 0.8em;
        margin-bottom: 3px;
    }
    
    .item-price {
        font-weight: bold;
        color: #e74c3c;
    }
    
    .item-category {
        font-size: 0.7em;
        color: #666;
        margin-top: 3px;
    }
    
    @media print {
        .card-header, .card-tools, .btn, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        
        .card {
            border: none !important;
            box-shadow: none !important;
        }
        
        .card-body {
            padding: 0 !important;
        }
        
        .barcode-sheet {
            page-break-inside: avoid;
        }
        
        .barcode-label {
            page-break-inside: avoid;
            break-inside: avoid;
        }
    }
</style>
@endsection