@extends('layouts.modern')

@section('title', 'طباعة باركود متعدد')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.index') }}">إدارة الباركود</a></li>
        <li class="breadcrumb-item active">طباعة باركود متعدد</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">طباعة باركود متعدد</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <form action="{{ route('inventory.barcodes.process-print-multiple') }}" method="POST">
                        @csrf
                        <div class="row">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header bg-info">
                                        <h3 class="card-title">اختر العناصر وعدد النسخ</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th style="width: 50px;">
                                                            <div class="icheck-primary">
                                                                <input type="checkbox" id="select-all">
                                                                <label for="select-all"></label>
                                                            </div>
                                                        </th>
                                                        <th>رمز العنصر</th>
                                                        <th>اسم العنصر</th>
                                                        <th>الباركود</th>
                                                        <th style="width: 150px;">عدد النسخ</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @forelse($items as $index => $item)
                                                        <tr>
                                                            <td>
                                                                <div class="icheck-primary">
                                                                    <input type="checkbox" name="items[]" id="item-{{ $item->id }}" value="{{ $item->id }}" class="item-checkbox">
                                                                    <label for="item-{{ $item->id }}"></label>
                                                                </div>
                                                            </td>
                                                            <td>{{ $item->sku }}</td>
                                                            <td>{{ $item->name }}</td>
                                                            <td>{{ $item->barcode }}</td>
                                                            <td>
                                                                <input type="number" name="copies[{{ $index }}]" class="form-control" min="1" max="100" value="1">
                                                            </td>
                                                        </tr>
                                                    @empty
                                                        <tr>
                                                            <td colspan="5" class="text-center">لا توجد عناصر لها باركود</td>
                                                        </tr>
                                                    @endforelse
                                                </tbody>
                                            </table>
                                        </div>
                                        
                                        @if(count($items) > 0)
                                            <div class="form-group mt-4">
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fa fa-print"></i> طباعة الباركود
                                                </button>
                                            </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
<link rel="stylesheet" href="{{ asset('plugins/icheck-bootstrap/icheck-bootstrap.min.css') }}">
@endsection

@section('js')
<script>
    $(function() {
        // تحديد/إلغاء تحديد جميع العناصر
        $('#select-all').on('change', function() {
            $('.item-checkbox').prop('checked', $(this).prop('checked'));
        });
        
        // تحديث حالة "تحديد الكل" عند تغيير حالة أي عنصر
        $('.item-checkbox').on('change', function() {
            var allChecked = $('.item-checkbox:checked').length === $('.item-checkbox').length;
            $('#select-all').prop('checked', allChecked);
        });
    });
</script>
@endsection