@extends('layouts.modern')

@section('title', 'إدارة الباركود')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item active">إدارة الباركود</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">إدارة الباركود</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.scan') }}" class="btn btn-info btn-sm">
                            <i class="fa fa-barcode"></i> مسح الباركود
                        </a>
                        <a href="{{ route('inventory.barcodes.print-multiple') }}" class="btn btn-success btn-sm">
                            <i class="fa fa-print"></i> طباعة باركود متعدد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-8">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">العناصر التي لها باركود</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>رمز العنصر</th>
                                                    <th>اسم العنصر</th>
                                                    <th>الباركود</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($items as $index => $item)
                                                    <tr>
                                                        <td>{{ $items->firstItem() + $index }}</td>
                                                        <td>{{ $item->sku }}</td>
                                                        <td>{{ $item->name }}</td>
                                                        <td>{{ $item->barcode }}</td>
                                                        <td>
                                                            <a href="{{ route('inventory.barcodes.generate', $item->id) }}" class="btn btn-primary btn-sm">
                                                                <i class="fa fa-barcode"></i> عرض/تعديل
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="5" class="text-center">لا توجد بيانات متاحة</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    <div class="mt-4">
                                        {{ $items->links() }}
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-4">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">العناصر بدون باركود</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>رمز العنصر</th>
                                                    <th>اسم العنصر</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($itemsWithoutBarcode as $item)
                                                    <tr>
                                                        <td>{{ $item->sku }}</td>
                                                        <td>{{ $item->name }}</td>
                                                        <td>
                                                            <a href="{{ route('inventory.barcodes.generate', $item->id) }}" class="btn btn-success btn-sm">
                                                                <i class="fa fa-plus"></i> إنشاء باركود
                                                            </a>
                                                        </td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="3" class="text-center">لا توجد عناصر بدون باركود</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                    
                                    @if(count($itemsWithoutBarcode) > 0)
                                        <div class="mt-3">
                                            <a href="{{ route('inventory.items.index') }}" class="btn btn-warning btn-block">
                                                <i class="fa fa-list"></i> عرض جميع العناصر
                                            </a>
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection