@extends('layouts.modern')

@section('title', 'إنشاء باركود')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.barcodes.index') }}">إدارة الباركود</a></li>
        <li class="breadcrumb-item active">إنشاء باركود</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">إنشاء باركود للعنصر: {{ $item->name }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.index') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">معلومات العنصر</h3>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رمز العنصر</th>
                                            <td>{{ $item->sku }}</td>
                                        </tr>
                                        <tr>
                                            <th>اسم العنصر</th>
                                            <td>{{ $item->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الفئة</th>
                                            <td>{{ $item->category->name ?? 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>وحدة القياس</th>
                                            <td>{{ $item->unit }}</td>
                                        </tr>
                                        <tr>
                                            <th>الباركود الحالي</th>
                                            <td>{{ $item->barcode ?? 'لا يوجد' }}</td>
                                        </tr>
                                    </table>
                                    
                                    <form action="{{ route('inventory.barcodes.store', $item->id) }}" method="POST" class="mt-4">
                                        @csrf
                                        <div class="form-group">
                                            <label for="barcode">الباركود</label>
                                            <input type="text" name="barcode" id="barcode" class="form-control" value="{{ $item->barcode }}" required>
                                            <small class="form-text text-muted">يجب أن يكون الباركود فريداً ويتكون من 8-13 رقم.</small>
                                        </div>
                                        <div class="form-group">
                                            <button type="submit" class="btn btn-primary">
                                                <i class="fa fa-save"></i> حفظ الباركود
                                            </button>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">صورة الباركود</h3>
                                </div>
                                <div class="card-body text-center">
                                    <div class="barcode-container mb-4">
                                        <img src="data:image/png;base64,{{ $barcodeImage }}" alt="Barcode">
                                        <div class="barcode-text">{{ $item->barcode }}</div>
                                    </div>
                                    
                                    <div class="barcode-info mb-4">
                                        <h5>{{ $item->name }}</h5>
                                        <p>رمز العنصر: {{ $item->sku }}</p>
                                    </div>
                                    
                                    <div class="print-actions">
                                        <button class="btn btn-success" onclick="window.print()">
                                            <i class="fa fa-print"></i> طباعة الباركود
                                        </button>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="card mt-4">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">معلومات إضافية</h3>
                                </div>
                                <div class="card-body">
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i> يمكنك استخدام الباركود لتسهيل عمليات المخزون مثل:
                                        <ul class="mt-2">
                                            <li>إدخال وإخراج المخزون</li>
                                            <li>الجرد السريع</li>
                                            <li>تتبع العناصر</li>
                                            <li>تسهيل عمليات البيع</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('css')
<style>
    .barcode-container {
        padding: 20px;
        border: 1px solid #ddd;
        background-color: white;
        display: inline-block;
    }
    
    .barcode-text {
        margin-top: 10px;
        font-size: 16px;
        font-weight: bold;
    }
    
    @media print {
        .main-header, .main-sidebar, .main-footer, .card-tools, .breadcrumb, .print-actions, form, .card-header, .alert {
            display: none !important;
        }
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        .card {
            box-shadow: none !important;
            border: none;
        }
        .barcode-container {
            border: none;
            padding: 0;
        }
        body {
            margin: 0;
            padding: 0;
        }
    }
</style>
@endsection