@extends('layouts.modern')

@section('title', 'تعديل قالب الباركود')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل قالب الباركود</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.advanced') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <form action="{{ route('inventory.barcodes.update-template', $template->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="form-group">
                                    <label for="template_name">اسم القالب</label>
                                    <input type="text" name="template_name" id="template_name" class="form-control" value="{{ $template->name }}" required>
                                </div>
                                <div class="form-group">
                                    <label for="template_width">عرض الملصق (مم)</label>
                                    <input type="number" name="template_width" id="template_width" class="form-control" value="{{ $template->width }}" min="20" max="200">
                                </div>
                                <div class="form-group">
                                    <label for="template_height">ارتفاع الملصق (مم)</label>
                                    <input type="number" name="template_height" id="template_height" class="form-control" value="{{ $template->height }}" min="10" max="200">
                                </div>
                                <div class="form-group">
                                    <label>عناصر الملصق</label>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="show_name" name="show_name" value="1" {{ $template->getSetting('show_name') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_name">اسم العنصر</label>
                                    </div>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="show_sku" name="show_sku" value="1" {{ $template->getSetting('show_sku') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_sku">رمز العنصر</label>
                                    </div>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="show_price" name="show_price" value="1" {{ $template->getSetting('show_price') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_price">السعر</label>
                                    </div>
                                    <div class="custom-control custom-checkbox">
                                        <input type="checkbox" class="custom-control-input" id="show_company" name="show_company" value="1" {{ $template->getSetting('show_company') ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="show_company">اسم الشركة</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                            </form>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">معاينة القالب</h5>
                                </div>
                                <div class="card-body">
                                    <div id="template-preview" class="border p-2 text-center" style="width: {{ $template->width }}px; height: {{ $template->height }}px; max-width: 100%;">
                                        <div class="mb-2" id="preview-company" {{ !$template->getSetting('show_company') ? 'style=display:none;' : '' }}>اسم الشركة</div>
                                        <div class="mb-2" id="preview-name" {{ !$template->getSetting('show_name') ? 'style=display:none;' : '' }}>اسم العنصر</div>
                                        <div class="mb-2" id="preview-sku" {{ !$template->getSetting('show_sku') ? 'style=display:none;' : '' }}>SKU12345</div>
                                        <div class="mb-2" id="preview-barcode">
                                            <img src="{{ asset('img/barcode-sample.png') }}" alt="نموذج باركود" class="img-fluid" style="max-height: 50px;">
                                        </div>
                                        <div id="preview-price" {{ !$template->getSetting('show_price') ? 'style=display:none;' : '' }}>99.99 ريال</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحديث المعاينة عند تغيير أي خيار
        function updatePreview() {
            if ($('#show_company').is(':checked')) {
                $('#preview-company').show();
            } else {
                $('#preview-company').hide();
            }
            
            if ($('#show_name').is(':checked')) {
                $('#preview-name').show();
            } else {
                $('#preview-name').hide();
            }
            
            if ($('#show_sku').is(':checked')) {
                $('#preview-sku').show();
            } else {
                $('#preview-sku').hide();
            }
            
            if ($('#show_price').is(':checked')) {
                $('#preview-price').show();
            } else {
                $('#preview-price').hide();
            }
            
            // تحديث أبعاد المعاينة
            const width = $('#template_width').val();
            const height = $('#template_height').val();
            $('#template-preview').css({
                'width': width + 'px',
                'height': height + 'px',
                'max-width': '100%'
            });
        }
        
        // تحديث المعاينة عند تغيير أي خيار
        $('#show_company, #show_name, #show_sku, #show_price, #template_width, #template_height').on('change', updatePreview);
    });
</script>
@endsection