@extends('layouts.modern')

@section('title', 'نتيجة إنشاء الباركود المخصص')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">نتيجة إنشاء الباركود المخصص</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.barcodes.advanced') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6 offset-md-3">
                            <div class="text-center mb-4">
                                <h4>الباركود المخصص</h4>
                                <p class="text-muted">{{ $barcode_data }}</p>
                            </div>
                            
                            <div class="barcode-container text-center mb-4">
                                <img src="{{ asset($barcode_image) }}" alt="الباركود" class="img-fluid">
                            </div>
                            
                            <div class="text-center mb-4">
                                <p><strong>نوع الباركود:</strong> 
                                    @if($barcode_type == 'ean13')
                                        EAN-13
                                    @elseif($barcode_type == 'code128')
                                        Code 128
                                    @elseif($barcode_type == 'qrcode')
                                        QR Code
                                    @elseif($barcode_type == 'datamatrix')
                                        Data Matrix
                                    @endif
                                </p>
                            </div>
                            
                            <div class="text-center">
                                <button onclick="window.print();" class="btn btn-primary">
                                    <i class="fas fa-print"></i> طباعة
                                </button>
                                <a href="{{ route('inventory.barcodes.advanced') }}" class="btn btn-secondary">
                                    <i class="fas fa-arrow-right"></i> العودة
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('styles')
<style>
    @media print {
        .card-header, .card-tools, .btn, .main-header, .main-sidebar, .main-footer {
            display: none !important;
        }
        
        .content-wrapper {
            margin-left: 0 !important;
            margin-right: 0 !important;
        }
        
        .barcode-container {
            margin: 0 auto;
            padding: 20px;
        }
    }
</style>
@endsection