@extends('layouts.modern')

@section('title', 'نظام الباركود المتقدم')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">نظام الباركود المتقدم</h3>
                </div>
                <div class="card-body">
                    <ul class="nav nav-tabs" id="barcodeTabs" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" id="generate-tab" data-toggle="tab" href="#generate" role="tab" aria-controls="generate" aria-selected="true">
                                <i class="fas fa-barcode"></i> إنشاء الباركود
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="bulk-tab" data-toggle="tab" href="#bulk" role="tab" aria-controls="bulk" aria-selected="false">
                                <i class="fas fa-print"></i> طباعة متعددة
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="scan-tab" data-toggle="tab" href="#scan" role="tab" aria-controls="scan" aria-selected="false">
                                <i class="fas fa-camera"></i> مسح الباركود
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="labels-tab" data-toggle="tab" href="#labels" role="tab" aria-controls="labels" aria-selected="false">
                                <i class="fas fa-tags"></i> تصميم الملصقات
                            </a>
                        </li>
                    </ul>
                    
                    <div class="tab-content mt-3" id="barcodeTabsContent">
                        <!-- قسم إنشاء الباركود -->
                        <div class="tab-pane fade show active" id="generate" role="tabpanel" aria-labelledby="generate-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">إنشاء باركود لعنصر</h4>
                                        </div>
                                        <div class="card-body">
                                            <form action="{{ route('inventory.barcodes.generate-item') }}" method="GET">
                                                <div class="form-group">
                                                    <label for="item_id">اختر العنصر</label>
                                                    <select name="item_id" id="item_id" class="form-control select2" required>
                                                        <option value="">-- اختر العنصر --</option>
                                                        @foreach($items as $item)
                                                            <option value="{{ $item->id }}">{{ $item->name }} ({{ $item->sku }})</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                                <button type="submit" class="btn btn-primary">
                                                    <i class="fas fa-barcode"></i> إنشاء باركود
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">إنشاء باركود مخصص</h4>
                                        </div>
                                        <div class="card-body">
                                            <form action="{{ route('inventory.barcodes.generate-custom') }}" method="POST">
                                                @csrf
                                                <div class="form-group">
                                                    <label for="barcode_data">بيانات الباركود</label>
                                                    <input type="text" name="barcode_data" id="barcode_data" class="form-control" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="barcode_type">نوع الباركود</label>
                                                    <select name="barcode_type" id="barcode_type" class="form-control" required>
                                                        <option value="ean13">EAN-13</option>
                                                        <option value="code128">Code 128</option>
                                                        <option value="qrcode">QR Code</option>
                                                        <option value="datamatrix">Data Matrix</option>
                                                    </select>
                                                </div>
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fas fa-plus"></i> إنشاء باركود مخصص
                                                </button>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- قسم الطباعة المتعددة -->
                        <div class="tab-pane fade" id="bulk" role="tabpanel" aria-labelledby="bulk-tab">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">طباعة باركود متعدد</h4>
                                </div>
                                <div class="card-body">
                                    <form action="{{ route('inventory.barcodes.print-multiple') }}" method="POST">
                                        @csrf
                                        <div class="row">
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label>اختر العناصر</label>
                                                    <select name="items[]" class="form-control select2" multiple required>
                                                        @foreach($items as $item)
                                                            <option value="{{ $item->id }}">{{ $item->name }} ({{ $item->sku }})</option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="barcode_type">نوع الباركود</label>
                                                    <select name="barcode_type" id="barcode_type" class="form-control" required>
                                                        <option value="ean13">EAN-13</option>
                                                        <option value="code128">Code 128</option>
                                                        <option value="qrcode">QR Code</option>
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="label_template">قالب الملصق</label>
                                                    <select name="label_template" id="label_template" class="form-control">
                                                        <option value="standard">قياسي</option>
                                                        <option value="small">صغير</option>
                                                        <option value="large">كبير</option>
                                                        <option value="detailed">مفصل</option>
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="quantity_per_item">عدد النسخ لكل عنصر</label>
                                                    <input type="number" name="quantity_per_item" id="quantity_per_item" class="form-control" value="1" min="1" max="100">
                                                </div>
                                            </div>
                                            <div class="col-md-4">
                                                <div class="form-group">
                                                    <label for="include_price">تضمين السعر</label>
                                                    <div class="custom-control custom-switch mt-2">
                                                        <input type="checkbox" class="custom-control-input" id="include_price" name="include_price" value="1">
                                                        <label class="custom-control-label" for="include_price">نعم</label>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <button type="submit" class="btn btn-primary">
                                            <i class="fas fa-print"></i> طباعة الباركود
                                        </button>
                                    </form>
                                </div>
                            </div>
                        </div>
                        
                        <!-- قسم مسح الباركود -->
                        <div class="tab-pane fade" id="scan" role="tabpanel" aria-labelledby="scan-tab">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">مسح الباركود بالكاميرا</h4>
                                        </div>
                                        <div class="card-body">
                                            <div class="form-group">
                                                <label for="warehouse_id">المستودع</label>
                                                <select name="warehouse_id" id="warehouse_id" class="form-control" required>
                                                    @foreach($warehouses as $warehouse)
                                                        <option value="{{ $warehouse->id }}">{{ $warehouse->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                            <div class="text-center mb-3">
                                                <button id="startCamera" class="btn btn-primary">
                                                    <i class="fas fa-camera"></i> تشغيل الكاميرا
                                                </button>
                                                <button id="stopCamera" class="btn btn-danger d-none">
                                                    <i class="fas fa-stop"></i> إيقاف الكاميرا
                                                </button>
                                            </div>
                                            <div id="scanner-container" class="text-center">
                                                <video id="scanner" class="img-fluid"></video>
                                            </div>
                                            <div class="mt-3">
                                                <div class="input-group">
                                                    <input type="text" id="barcode-input" class="form-control" placeholder="أدخل الباركود يدوياً">
                                                    <div class="input-group-append">
                                                        <button id="process-manual" class="btn btn-info">
                                                            <i class="fas fa-search"></i> بحث
                                                        </button>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="card">
                                        <div class="card-header">
                                            <h4 class="card-title">نتيجة المسح</h4>
                                        </div>
                                        <div class="card-body">
                                            <div id="scan-result">
                                                <div class="text-center text-muted">
                                                    <i class="fas fa-barcode fa-3x mb-3"></i>
                                                    <p>قم بمسح الباركود للحصول على معلومات العنصر</p>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- قسم تصميم الملصقات -->
                        <div class="tab-pane fade" id="labels" role="tabpanel" aria-labelledby="labels-tab">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">تصميم قوالب الملصقات</h4>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <form action="{{ route('inventory.barcodes.save-template') }}" method="POST">
                                                @csrf
                                                <div class="form-group">
                                                    <label for="template_name">اسم القالب</label>
                                                    <input type="text" name="template_name" id="template_name" class="form-control" required>
                                                </div>
                                                <div class="form-group">
                                                    <label for="template_width">عرض الملصق (مم)</label>
                                                    <input type="number" name="template_width" id="template_width" class="form-control" value="50" min="20" max="200">
                                                </div>
                                                <div class="form-group">
                                                    <label for="template_height">ارتفاع الملصق (مم)</label>
                                                    <input type="number" name="template_height" id="template_height" class="form-control" value="30" min="10" max="200">
                                                </div>
                                                <div class="form-group">
                                                    <label>عناصر الملصق</label>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="show_name" name="show_name" value="1" checked>
                                                        <label class="custom-control-label" for="show_name">اسم العنصر</label>
                                                    </div>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="show_sku" name="show_sku" value="1" checked>
                                                        <label class="custom-control-label" for="show_sku">رمز العنصر</label>
                                                    </div>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="show_price" name="show_price" value="1">
                                                        <label class="custom-control-label" for="show_price">السعر</label>
                                                    </div>
                                                    <div class="custom-control custom-checkbox">
                                                        <input type="checkbox" class="custom-control-input" id="show_company" name="show_company" value="1">
                                                        <label class="custom-control-label" for="show_company">اسم الشركة</label>
                                                    </div>
                                                </div>
                                                <button type="submit" class="btn btn-success">
                                                    <i class="fas fa-save"></i> حفظ القالب
                                                </button>
                                            </form>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="card">
                                                <div class="card-header">
                                                    <h5 class="card-title">معاينة القالب</h5>
                                                </div>
                                                <div class="card-body">
                                                    <div id="template-preview" class="border p-2 text-center">
                                                        <div class="mb-2" id="preview-company">اسم الشركة</div>
                                                        <div class="mb-2" id="preview-name">اسم العنصر</div>
                                                        <div class="mb-2" id="preview-sku">SKU12345</div>
                                                        <div class="mb-2" id="preview-barcode">
                                                            <img src="{{ asset('img/barcode-sample.png') }}" alt="نموذج باركود" class="img-fluid" style="max-height: 50px;">
                                                        </div>
                                                        <div id="preview-price">99.99 ريال</div>
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="mt-3">
                                                <h5>القوالب المحفوظة</h5>
                                                <ul class="list-group">
                                                    @foreach($templates ?? [] as $template)
                                                        <li class="list-group-item d-flex justify-content-between align-items-center">
                                                            {{ $template->name }}
                                                            <div>
                                                                <a href="{{ route('inventory.barcodes.edit-template', $template->id) }}" class="btn btn-sm btn-info">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                <button type="button" class="btn btn-sm btn-danger delete-template" data-id="{{ $template->id }}">
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                            </div>
                                                        </li>
                                                    @endforeach
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://unpkg.com/@zxing/library@latest"></script>
<script>
    $(document).ready(function() {
        // تهيئة Select2
        $('.select2').select2({
            dir: 'rtl',
            language: 'ar'
        });
        
        // معاينة قالب الملصق
        function updatePreview() {
            if ($('#show_company').is(':checked')) {
                $('#preview-company').show();
            } else {
                $('#preview-company').hide();
            }
            
            if ($('#show_name').is(':checked')) {
                $('#preview-name').show();
            } else {
                $('#preview-name').hide();
            }
            
            if ($('#show_sku').is(':checked')) {
                $('#preview-sku').show();
            } else {
                $('#preview-sku').hide();
            }
            
            if ($('#show_price').is(':checked')) {
                $('#preview-price').show();
            } else {
                $('#preview-price').hide();
            }
            
            // تحديث أبعاد المعاينة
            const width = $('#template_width').val();
            const height = $('#template_height').val();
            $('#template-preview').css({
                'width': width + 'px',
                'height': height + 'px',
                'max-width': '100%'
            });
        }
        
        // تحديث المعاينة عند تغيير أي خيار
        $('#show_company, #show_name, #show_sku, #show_price, #template_width, #template_height').on('change', updatePreview);
        
        // تهيئة المعاينة
        updatePreview();
        
        // مسح الباركود بالكاميرا
        let codeReader;
        let selectedDeviceId;
        
        $('#startCamera').on('click', function() {
            codeReader = new ZXing.BrowserMultiFormatReader();
            codeReader.listVideoInputDevices()
                .then((videoInputDevices) => {
                    if (videoInputDevices.length > 0) {
                        selectedDeviceId = videoInputDevices[0].deviceId;
                        
                        // بدء المسح
                        codeReader.decodeFromVideoDevice(selectedDeviceId, 'scanner', (result, err) => {
                            if (result) {
                                // معالجة الباركود الممسوح
                                processBarcode(result.text);
                            }
                            if (err && !(err instanceof ZXing.NotFoundException)) {
                                console.error(err);
                            }
                        });
                        
                        $('#startCamera').addClass('d-none');
                        $('#stopCamera').removeClass('d-none');
                    } else {
                        alert('لم يتم العثور على كاميرا');
                    }
                })
                .catch((err) => {
                    console.error(err);
                    alert('حدث خطأ أثناء الوصول إلى الكاميرا: ' + err);
                });
        });
        
        $('#stopCamera').on('click', function() {
            if (codeReader) {
                codeReader.reset();
                $('#startCamera').removeClass('d-none');
                $('#stopCamera').addClass('d-none');
            }
        });
        
        // معالجة الباركود المدخل يدوياً
        $('#process-manual').on('click', function() {
            const barcode = $('#barcode-input').val().trim();
            if (barcode) {
                processBarcode(barcode);
            }
        });
        
        // معالجة الباركود
        function processBarcode(barcode) {
            const warehouseId = $('#warehouse_id').val();
            
            $('#scan-result').html('<div class="text-center"><i class="fas fa-spinner fa-spin fa-2x mb-3"></i><p>جاري البحث...</p></div>');
            
            // إرسال طلب AJAX للبحث عن الباركود
            $.ajax({
                url: "{{ route('inventory.barcodes.process-scan') }}",
                method: 'POST',
                data: {
                    _token: "{{ csrf_token() }}",
                    barcode: barcode,
                    warehouse_id: warehouseId
                },
                success: function(response) {
                    if (response.success) {
                        displayScanResult(response);
                    } else {
                        $('#scan-result').html('<div class="alert alert-danger">لم يتم العثور على عنصر بهذا الباركود</div>');
                    }
                },
                error: function(xhr) {
                    let errorMessage = 'حدث خطأ أثناء البحث';
                    if (xhr.responseJSON && xhr.responseJSON.error) {
                        errorMessage = xhr.responseJSON.error;
                    }
                    $('#scan-result').html('<div class="alert alert-danger">' + errorMessage + '</div>');
                }
            });
        }
        
        // عرض نتيجة المسح
        function displayScanResult(response) {
            let html = '';
            
            if (response.type === 'item') {
                const item = response.data;
                const stock = response.stock;
                
                html = `
                    <div class="text-center mb-3">
                        <h4>${item.name}</h4>
                        <p class="text-muted">${item.sku}</p>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <p><strong>السعر:</strong> ${item.selling_price} ريال</p>
                            <p><strong>الكمية المتاحة:</strong> ${stock ? stock.quantity : 0}</p>
                        </div>
                        <div class="col-6">
                            <p><strong>الفئة:</strong> ${item.category ? item.category.name : 'غير محدد'}</p>
                            <p><strong>آخر تحديث:</strong> ${item.updated_at}</p>
                        </div>
                    </div>
                    <div class="mt-3">
                        <button class="btn btn-primary create-transaction" data-item-id="${item.id}" data-type="sale">
                            <i class="fas fa-shopping-cart"></i> بيع
                        </button>
                        <button class="btn btn-success create-transaction" data-item-id="${item.id}" data-type="purchase">
                            <i class="fas fa-plus"></i> شراء
                        </button>
                        <button class="btn btn-warning create-transaction" data-item-id="${item.id}" data-type="transfer">
                            <i class="fas fa-exchange-alt"></i> نقل
                        </button>
                    </div>
                `;
            } else if (response.type === 'serial') {
                const serial = response.data;
                
                html = `
                    <div class="text-center mb-3">
                        <h4>${serial.item.name}</h4>
                        <p class="text-muted">الرقم التسلسلي: ${serial.serial_number}</p>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <p><strong>الحالة:</strong> ${serial.status}</p>
                            <p><strong>تاريخ الإنتاج:</strong> ${serial.production_date || 'غير محدد'}</p>
                        </div>
                        <div class="col-6">
                            <p><strong>تاريخ انتهاء الصلاحية:</strong> ${serial.expiry_date || 'غير محدد'}</p>
                            <p><strong>الموقع:</strong> ${serial.warehouse ? serial.warehouse.name : 'غير محدد'}</p>
                        </div>
                    </div>
                    <div class="mt-3">
                        <button class="btn btn-primary create-transaction" data-item-id="${serial.item_id}" data-serial-id="${serial.id}" data-type="sale">
                            <i class="fas fa-shopping-cart"></i> بيع
                        </button>
                        <button class="btn btn-warning create-transaction" data-item-id="${serial.item_id}" data-serial-id="${serial.id}" data-type="transfer">
                            <i class="fas fa-exchange-alt"></i> نقل
                        </button>
                    </div>
                `;
            } else if (response.type === 'batch') {
                const batch = response.data;
                
                html = `
                    <div class="text-center mb-3">
                        <h4>${batch.item.name}</h4>
                        <p class="text-muted">رقم الدفعة: ${batch.batch_number}</p>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <p><strong>الكمية:</strong> ${batch.quantity}</p>
                            <p><strong>تاريخ الإنتاج:</strong> ${batch.production_date || 'غير محدد'}</p>
                        </div>
                        <div class="col-6">
                            <p><strong>تاريخ انتهاء الصلاحية:</strong> ${batch.expiry_date || 'غير محدد'}</p>
                            <p><strong>الموقع:</strong> ${batch.warehouse ? batch.warehouse.name : 'غير محدد'}</p>
                        </div>
                    </div>
                    <div class="mt-3">
                        <button class="btn btn-primary create-transaction" data-item-id="${batch.item_id}" data-batch-id="${batch.id}" data-type="sale">
                            <i class="fas fa-shopping-cart"></i> بيع
                        </button>
                        <button class="btn btn-warning create-transaction" data-item-id="${batch.item_id}" data-batch-id="${batch.id}" data-type="transfer">
                            <i class="fas fa-exchange-alt"></i> نقل
                        </button>
                    </div>
                `;
            }
            
            $('#scan-result').html(html);
            
            // تفعيل أزرار المعاملات
            $('.create-transaction').on('click', function() {
                const itemId = $(this).data('item-id');
                const type = $(this).data('type');
                const batchId = $(this).data('batch-id') || null;
                const serialId = $(this).data('serial-id') || null;
                
                // فتح نافذة إنشاء معاملة
                openTransactionModal(itemId, type, batchId, serialId);
            });
        }
        
        // فتح نافذة إنشاء معاملة
        function openTransactionModal(itemId, type, batchId, serialId) {
            const warehouseId = $('#warehouse_id').val();
            
            // إعادة توجيه إلى صفحة إنشاء المعاملة مع تمرير البيانات
            const url = "{{ route('inventory.transactions.create') }}?" + $.param({
                item_id: itemId,
                transaction_type: type,
                warehouse_id: warehouseId,
                batch_id: batchId,
                serial_id: serialId,
                from_barcode: 1
            });
            
            window.location.href = url;
        }
    });
</script>
@endsection