@extends('layouts.modern')

@section('title', 'التوصيات الذكية للشراء التلقائي')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.analytics') }}">تحليلات الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">التوصيات الذكية</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">التوصيات الذكية للشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.analytics') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- لوحة المعلومات -->
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> 
                                <strong>نظام التوصيات الذكية:</strong> 
                                يقوم النظام بتحليل بيانات المخزون والاستهلاك وأنماط الشراء لتقديم توصيات ذكية لتحسين قواعد الشراء التلقائي وتقليل التكاليف.
                            </div>
                        </div>
                    </div>

                    <!-- ملخص التوصيات -->
                    <div class="row mb-4">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $dashboardStats['total_items'] }}</h3>
                                    <p>إجمالي العناصر</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-boxes"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $dashboardStats['low_stock_items'] }}</h3>
                                    <p>عناصر منخفضة المخزون</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ number_format($dashboardStats['potential_savings'], 0) }}</h3>
                                    <p>التوفير المحتمل (ريال)</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $dashboardStats['seasonal_items'] }}</h3>
                                    <p>عناصر موسمية</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-calendar-alt"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- تحليل المخزون -->
                    <div class="row mb-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">تحليل المخزون حسب الفئة</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="inventoryCategoryChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">تحليل الاستهلاك الشهري</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="monthlyConsumptionChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- العناصر التي تحتاج إلى اهتمام عاجل -->
                    <div class="card">
                        <div class="card-header bg-danger">
                            <h3 class="card-title">عناصر تحتاج إلى اهتمام عاجل</h3>
                        </div>
                        <div class="card-body">
                            @if(count($urgentItems) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>العنصر</th>
                                                <th>المستودع</th>
                                                <th>المخزون الحالي</th>
                                                <th>معدل الاستهلاك</th>
                                                <th>الأيام المتبقية</th>
                                                <th>وقت التوريد</th>
                                                <th>الحالة</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($urgentItems as $index => $item)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $item['item']->name }} ({{ $item['item']->sku }})</td>
                                                    <td>{{ $item['warehouse']->name }}</td>
                                                    <td>{{ number_format($item['current_stock'], 2) }}</td>
                                                    <td>{{ number_format($item['consumption_rate'], 2) }} / يوم</td>
                                                    <td>
                                                        <span class="badge badge-danger">
                                                            {{ number_format($item['days_remaining'], 0) }} يوم
                                                        </span>
                                                    </td>
                                                    <td>{{ number_format($item['lead_time'], 0) }} يوم</td>
                                                    <td>
                                                        @if($item['days_remaining'] < $item['lead_time'])
                                                            <span class="badge badge-danger">خطر نفاد المخزون</span>
                                                        @else
                                                            <span class="badge badge-warning">منخفض</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        @if($item['has_rule'])
                                                            <a href="{{ route('inventory.auto-purchase.edit', $item['rule_id']) }}" class="btn btn-sm btn-warning">
                                                                <i class="fas fa-edit"></i> تعديل القاعدة
                                                            </a>
                                                        @else
                                                            <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#createRuleModal{{ $item['item']->id }}">
                                                                <i class="fas fa-plus-circle"></i> إنشاء قاعدة
                                                            </button>
                                                            
                                                            <!-- Modal -->
                                                            <div class="modal fade" id="createRuleModal{{ $item['item']->id }}" tabindex="-1" role="dialog" aria-labelledby="createRuleModalLabel{{ $item['item']->id }}" aria-hidden="true">
                                                                <div class="modal-dialog modal-lg" role="document">
                                                                    <div class="modal-content">
                                                                        <form action="{{ route('inventory.auto-purchase.create-recommended-rule') }}" method="POST">
                                                                            @csrf
                                                                            <input type="hidden" name="item_id" value="{{ $item['item']->id }}">
                                                                            <input type="hidden" name="warehouse_id" value="{{ $item['warehouse']->id }}">
                                                                            
                                                                            <div class="modal-header bg-primary">
                                                                                <h5 class="modal-title" id="createRuleModalLabel{{ $item['item']->id }}">إنشاء قاعدة شراء تلقائي عاجلة</h5>
                                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                    <span aria-hidden="true">&times;</span>
                                                                                </button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <div class="alert alert-danger">
                                                                                    <i class="fas fa-exclamation-triangle"></i>
                                                                                    <strong>تنبيه:</strong> هذا العنصر في خطر نفاد المخزون خلال {{ number_format($item['days_remaining'], 0) }} يوم فقط!
                                                                                </div>
                                                                                
                                                                                <div class="row">
                                                                                    <div class="col-md-6">
                                                                                        <div class="form-group">
                                                                                            <label for="supplier_id">المورد</label>
                                                                                            <select name="supplier_id" class="form-control select2" required>
                                                                                                <option value="">-- اختر المورد --</option>
                                                                                                @foreach(App\Models\Supplier::where('company_id', auth()->user()->company_id)->where('is_active', true)->get() as $supplier)
                                                                                                    <option value="{{ $supplier->id }}" {{ $item['potential_supplier'] && $item['potential_supplier']->id == $supplier->id ? 'selected' : '' }}>
                                                                                                        {{ $supplier->name }}
                                                                                                    </option>
                                                                                                @endforeach
                                                                                            </select>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-md-6">
                                                                                        <div class="form-group">
                                                                                            <label for="frequency_days">تكرار الفحص</label>
                                                                                            <select name="frequency_days" class="form-control">
                                                                                                <option value="1" selected>يومياً</option>
                                                                                                <option value="3">كل 3 أيام</option>
                                                                                                <option value="7">أسبوعياً</option>
                                                                                            </select>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                
                                                                                <div class="row">
                                                                                    <div class="col-md-6">
                                                                                        <div class="form-group">
                                                                                            <label for="min_quantity">الحد الأدنى للمخزون</label>
                                                                                            <input type="number" name="min_quantity" class="form-control" step="0.01" min="0" value="{{ $item['recommended_min_quantity'] }}" required>
                                                                                            <small class="text-muted">
                                                                                                يغطي {{ number_format($item['lead_time'], 0) }} يوم من وقت التوريد + مخزون أمان
                                                                                            </small>
                                                                                        </div>
                                                                                    </div>
                                                                                    <div class="col-md-6">
                                                                                        <div class="form-group">
                                                                                            <label for="order_quantity">كمية الطلب</label>
                                                                                            <input type="number" name="order_quantity" class="form-control" step="0.01" min="0.01" value="{{ $item['recommended_order_quantity'] }}" required>
                                                                                            <small class="text-muted">
                                                                                                الكمية الاقتصادية المثلى للطلب (EOQ)
                                                                                            </small>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                
                                                                                <div class="form-group">
                                                                                    <div class="custom-control custom-checkbox">
                                                                                        <input type="checkbox" class="custom-control-input" id="create_purchase_order{{ $item['item']->id }}" name="create_purchase_order" value="1" checked>
                                                                                        <label class="custom-control-label" for="create_purchase_order{{ $item['item']->id }}">إنشاء طلب شراء فوري</label>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                                <button type="submit" class="btn btn-danger">
                                                                                    <i class="fas fa-plus-circle"></i> إنشاء قاعدة عاجلة
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-success">
                                    <i class="fa fa-check-circle"></i> لا توجد عناصر تحتاج إلى اهتمام عاجل.
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- العناصر الموسمية -->
                    <div class="card mt-4">
                        <div class="card-header bg-warning">
                            <h3 class="card-title">العناصر الموسمية</h3>
                        </div>
                        <div class="card-body">
                            @if(count($seasonalItems) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>العنصر</th>
                                                <th>المستودع</th>
                                                <th>معدل الاستهلاك العادي</th>
                                                <th>معدل الاستهلاك الموسمي</th>
                                                <th>نسبة الزيادة</th>
                                                <th>الفترة الموسمية</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($seasonalItems as $index => $item)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $item['item']->name }} ({{ $item['item']->sku }})</td>
                                                    <td>{{ $item['warehouse']->name }}</td>
                                                    <td>{{ number_format($item['normal_rate'], 2) }} / يوم</td>
                                                    <td>{{ number_format($item['seasonal_rate'], 2) }} / يوم</td>
                                                    <td>
                                                        <span class="badge badge-warning">
                                                            {{ number_format($item['increase_percentage'], 0) }}%
                                                        </span>
                                                    </td>
                                                    <td>{{ $item['seasonal_period'] }}</td>
                                                    <td>
                                                        @if($item['has_rule'])
                                                            <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#adjustSeasonalModal{{ $item['rule_id'] }}">
                                                                <i class="fas fa-calendar-alt"></i> تعديل موسمي
                                                            </button>
                                                            
                                                            <!-- Modal -->
                                                            <div class="modal fade" id="adjustSeasonalModal{{ $item['rule_id'] }}" tabindex="-1" role="dialog" aria-labelledby="adjustSeasonalModalLabel{{ $item['rule_id'] }}" aria-hidden="true">
                                                                <div class="modal-dialog" role="document">
                                                                    <div class="modal-content">
                                                                        <form action="{{ route('inventory.auto-purchase.adjust-seasonal', $item['rule_id']) }}" method="POST">
                                                                            @csrf
                                                                            <div class="modal-header bg-warning">
                                                                                <h5 class="modal-title" id="adjustSeasonalModalLabel{{ $item['rule_id'] }}">تعديل موسمي للقاعدة</h5>
                                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                    <span aria-hidden="true">&times;</span>
                                                                                </button>
                                                                            </div>
                                                                            <div class="modal-body">
                                                                                <div class="alert alert-warning">
                                                                                    <i class="fas fa-calendar-alt"></i>
                                                                                    <strong>تنبيه موسمي:</strong> هذا العنصر يظهر زيادة موسمية في الاستهلاك بنسبة {{ number_format($item['increase_percentage'], 0) }}% خلال الفترة الحالية.
                                                                                </div>
                                                                                
                                                                                <div class="form-group">
                                                                                    <label for="seasonal_min_quantity">الحد الأدنى الموسمي</label>
                                                                                    <input type="number" name="seasonal_min_quantity" class="form-control" step="0.01" min="0" value="{{ $item['recommended_min_quantity'] }}" required>
                                                                                    <small class="text-muted">
                                                                                        الحد الأدنى الحالي: {{ number_format($item['current_min_quantity'], 2) }}
                                                                                    </small>
                                                                                </div>
                                                                                
                                                                                <div class="form-group">
                                                                                    <label for="seasonal_order_quantity">كمية الطلب الموسمية</label>
                                                                                    <input type="number" name="seasonal_order_quantity" class="form-control" step="0.01" min="0.01" value="{{ $item['recommended_order_quantity'] }}" required>
                                                                                    <small class="text-muted">
                                                                                        كمية الطلب الحالية: {{ number_format($item['current_order_quantity'], 2) }}
                                                                                    </small>
                                                                                </div>
                                                                                
                                                                                <div class="form-group">
                                                                                    <label for="seasonal_end_date">تاريخ انتهاء الفترة الموسمية</label>
                                                                                    <input type="date" name="seasonal_end_date" class="form-control" value="{{ $item['seasonal_end_date'] }}" required>
                                                                                </div>
                                                                            </div>
                                                                            <div class="modal-footer">
                                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                                <button type="submit" class="btn btn-warning">
                                                                                    <i class="fas fa-calendar-check"></i> تطبيق التعديل الموسمي
                                                                                </button>
                                                                            </div>
                                                                        </form>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        @else
                                                            <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#createSeasonalRuleModal{{ $item['item']->id }}">
                                                                <i class="fas fa-plus-circle"></i> إنشاء قاعدة موسمية
                                                            </button>
                                                        @endif
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-success">
                                    <i class="fa fa-check-circle"></i> لا توجد عناصر موسمية حالياً.
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- توصيات تحسين التكلفة -->
                    <div class="card mt-4">
                        <div class="card-header bg-success">
                            <h3 class="card-title">توصيات تحسين التكلفة</h3>
                        </div>
                        <div class="card-body">
                            @if(count($costSavingRecommendations) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>العنصر</th>
                                                <th>المستودع</th>
                                                <th>التوصية</th>
                                                <th>التوفير المتوقع</th>
                                                <th>نسبة التوفير</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($costSavingRecommendations as $index => $recommendation)
                                                <tr>
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $recommendation['item']->name }} ({{ $recommendation['item']->sku }})</td>
                                                    <td>{{ $recommendation['warehouse']->name }}</td>
                                                    <td>{{ $recommendation['recommendation_text'] }}</td>
                                                    <td>{{ number_format($recommendation['cost_savings'], 0) }} ريال</td>
                                                    <td>
                                                        <span class="badge badge-success">
                                                            {{ number_format($recommendation['savings_percentage'], 1) }}%
                                                        </span>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#applySavingsModal{{ $recommendation['rule_id'] }}">
                                                            <i class="fas fa-check"></i> تطبيق
                                                        </button>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-success">
                                    <i class="fa fa-check-circle"></i> لا توجد توصيات لتحسين التكلفة حالياً.
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(function() {
        // تهيئة Select2
        $('.select2').select2({
            dir: 'rtl',
            language: 'ar'
        });
        
        // تهيئة DataTables
        $('table.table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
        
        // رسم بياني للمخزون حسب الفئة
        var categoryCtx = document.getElementById('inventoryCategoryChart').getContext('2d');
        var categoryChart = new Chart(categoryCtx, {
            type: 'pie',
            data: {
                labels: {!! json_encode($chartData['category_labels']) !!},
                datasets: [{
                    data: {!! json_encode($chartData['category_data']) !!},
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.7)',
                        'rgba(54, 162, 235, 0.7)',
                        'rgba(255, 206, 86, 0.7)',
                        'rgba(75, 192, 192, 0.7)',
                        'rgba(153, 102, 255, 0.7)',
                        'rgba(255, 159, 64, 0.7)',
                        'rgba(199, 199, 199, 0.7)',
                        'rgba(83, 102, 255, 0.7)',
                        'rgba(40, 159, 64, 0.7)',
                        'rgba(210, 199, 199, 0.7)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                plugins: {
                    legend: {
                        position: 'right',
                    },
                    title: {
                        display: true,
                        text: 'توزيع المخزون حسب الفئة'
                    }
                }
            }
        });
        
        // رسم بياني للاستهلاك الشهري
        var consumptionCtx = document.getElementById('monthlyConsumptionChart').getContext('2d');
        var consumptionChart = new Chart(consumptionCtx, {
            type: 'bar',
            data: {
                labels: {!! json_encode($chartData['month_labels']) !!},
                datasets: [{
                    label: 'معدل الاستهلاك',
                    data: {!! json_encode($chartData['consumption_data']) !!},
                    backgroundColor: 'rgba(54, 162, 235, 0.7)',
                    borderColor: 'rgba(54, 162, 235, 1)',
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                },
                plugins: {
                    title: {
                        display: true,
                        text: 'معدل الاستهلاك الشهري'
                    }
                }
            }
        });
    });
</script>
@endsection