@extends('layouts.modern')

@section('title', 'تفاصيل قاعدة الشراء التلقائي')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">تفاصيل قاعدة الشراء التلقائي</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.index') }}">قواعد الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">تفاصيل القاعدة #{{ $rule->id }}</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <div>
                <i class="fas fa-info-circle me-1"></i>
                تفاصيل قاعدة الشراء التلقائي #{{ $rule->id }}
            </div>
            <div>
                @can('edit_auto_purchase')
                <a href="{{ route('inventory.auto-purchase.edit', $rule->id) }}" class="btn btn-primary btn-sm">
                    <i class="fas fa-edit"></i> تعديل
                </a>
                @endcan
                @can('delete_auto_purchase')
                <form action="{{ route('inventory.auto-purchase.destroy', $rule->id) }}" method="POST" class="d-inline">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذه القاعدة؟')">
                        <i class="fas fa-trash"></i> حذف
                    </button>
                </form>
                @endcan
                <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-secondary btn-sm">
                    <i class="fas fa-arrow-left"></i> عودة
                </a>
            </div>
        </div>
        <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <h5 class="border-bottom pb-2">معلومات القاعدة</h5>
                    <table class="table table-striped">
                        <tr>
                            <th style="width: 30%">العنصر:</th>
                            <td>{{ $rule->item->name }} ({{ $rule->item->sku }})</td>
                        </tr>
                        <tr>
                            <th>المورد:</th>
                            <td>{{ $rule->supplier->name }}</td>
                        </tr>
                        <tr>
                            <th>المستودع:</th>
                            <td>{{ $rule->warehouse->name }}</td>
                        </tr>
                        <tr>
                            <th>الحد الأدنى للمخزون:</th>
                            <td>{{ number_format($rule->min_quantity, 2) }}</td>
                        </tr>
                        <tr>
                            <th>كمية الطلب:</th>
                            <td>{{ number_format($rule->order_quantity, 2) }}</td>
                        </tr>
                        <tr>
                            <th>تكرار الفحص (أيام):</th>
                            <td>{{ $rule->frequency_days ?: 'يومياً' }}</td>
                        </tr>
                        <tr>
                            <th>الحالة:</th>
                            <td>
                                @if($rule->is_active)
                                    <span class="badge bg-success">نشط</span>
                                @else
                                    <span class="badge bg-danger">غير نشط</span>
                                @endif
                            </td>
                        </tr>
                    </table>
                </div>
                <div class="col-md-6">
                    <h5 class="border-bottom pb-2">معلومات التشغيل</h5>
                    <table class="table table-striped">
                        <tr>
                            <th style="width: 30%">المخزون الحالي:</th>
                            <td>
                                {{ number_format($currentStock, 2) }}
                                @if($currentStock <= $rule->min_quantity)
                                    <span class="badge bg-danger">أقل من الحد الأدنى</span>
                                @else
                                    <span class="badge bg-success">أعلى من الحد الأدنى</span>
                                @endif
                            </td>
                        </tr>
                        <tr>
                            <th>آخر تشغيل:</th>
                            <td>{{ $rule->last_triggered_at ? $rule->last_triggered_at->format('Y-m-d H:i') : 'لم يتم التشغيل بعد' }}</td>
                        </tr>
                        <tr>
                            <th>الفحص التالي:</th>
                            <td>{{ $rule->next_check_date ? $rule->next_check_date->format('Y-m-d') : 'غير محدد' }}</td>
                        </tr>
                        <tr>
                            <th>تاريخ الإنشاء:</th>
                            <td>{{ $rule->created_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>بواسطة:</th>
                            <td>{{ $rule->creator ? $rule->creator->name : 'غير معروف' }}</td>
                        </tr>
                        <tr>
                            <th>آخر تحديث:</th>
                            <td>{{ $rule->updated_at->format('Y-m-d H:i') }}</td>
                        </tr>
                        <tr>
                            <th>بواسطة:</th>
                            <td>{{ $rule->updater ? $rule->updater->name : 'غير معروف' }}</td>
                        </tr>
                    </table>
                </div>
            </div>

            <h5 class="border-bottom pb-2 mt-4">طلبات الشراء المرتبطة</h5>
            @if($purchaseOrders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped table-hover">
                        <thead>
                            <tr>
                                <th>رقم الطلب</th>
                                <th>تاريخ الطلب</th>
                                <th>المورد</th>
                                <th>المستودع</th>
                                <th>الحالة</th>
                                <th>المبلغ الإجمالي</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseOrders as $order)
                                <tr>
                                    <td>{{ $order->id }}</td>
                                    <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                    <td>{{ $order->supplier->name }}</td>
                                    <td>{{ $order->warehouse->name }}</td>
                                    <td>
                                        @switch($order->status)
                                            @case('pending')
                                                <span class="badge bg-warning">قيد الانتظار</span>
                                                @break
                                            @case('approved')
                                                <span class="badge bg-primary">معتمد</span>
                                                @break
                                            @case('shipped')
                                                <span class="badge bg-info">تم الشحن</span>
                                                @break
                                            @case('received')
                                                <span class="badge bg-success">تم الاستلام</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge bg-danger">ملغي</span>
                                                @break
                                            @default
                                                <span class="badge bg-secondary">{{ $order->status }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ number_format($order->total_amount, 2) }}</td>
                                    <td>
                                        <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> عرض
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                {{ $purchaseOrders->links() }}
            @else
                <div class="alert alert-info">
                    لا توجد طلبات شراء مرتبطة بهذه القاعدة حتى الآن.
                </div>
            @endif
        </div>
        <div class="card-footer">
            <div class="alert alert-info mb-0">
                <h5><i class="fas fa-info-circle"></i> معلومات مساعدة</h5>
                <p>
                    <strong>الحد الأدنى للمخزون:</strong> عندما ينخفض المخزون عن هذه القيمة، سيتم إنشاء طلب شراء تلقائي.
                    <br>
                    <strong>كمية الطلب:</strong> الكمية التي سيتم طلبها تلقائياً.
                    <br>
                    <strong>تكرار الفحص:</strong> عدد الأيام بين عمليات الفحص المتتالية (0 = يومياً).
                </p>
            </div>
        </div>
    </div>
</div>
@endsection