@extends('layouts.modern')

@section('title', 'توصيات تحسين قواعد الشراء التلقائي')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.analytics') }}">تحليلات الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">التوصيات</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">توصيات تحسين قواعد الشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.analytics') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> يعرض هذا التقرير توصيات ذكية لتحسين قواعد الشراء التلقائي الحالية وإنشاء قواعد جديدة للعناصر التي تحتاج إلى ذلك.
                            </div>
                        </div>
                    </div>
                    
                    <!-- ملخص التوصيات -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $recommendationStats['total_recommendations'] }}</h3>
                                    <p>إجمالي التوصيات</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-lightbulb"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $recommendationStats['high_priority'] }}</h3>
                                    <p>توصيات عالية الأولوية</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ number_format($recommendationStats['total_potential_savings'], 0) }}</h3>
                                    <p>التوفير المحتمل (ريال)</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $recommendationStats['new_rules_suggested'] }}</h3>
                                    <p>قواعد جديدة مقترحة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-plus-circle"></i>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- توصيات تحسين القواعد الحالية -->
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">توصيات ذكية لتحسين القواعد الحالية</h3>
                        </div>
                        <div class="card-body">
                            @if(count($recommendations) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>العنصر</th>
                                                <th>المستودع</th>
                                                <th>الأولوية</th>
                                                <th>المخزون الحالي</th>
                                                <th>معدل الاستهلاك</th>
                                                <th>الحد الأدنى</th>
                                                <th>الحد الأدنى الموصى به</th>
                                                <th>كمية الطلب</th>
                                                <th>كمية الطلب الموصى بها</th>
                                                <th>التوفير المتوقع</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($recommendations as $index => $recommendation)
                                                <tr class="{{ $recommendation['priority'] == 'عالية' ? 'table-danger' : ($recommendation['priority'] == 'متوسطة' ? 'table-warning' : '') }}">
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $recommendation['rule']->item->name }} ({{ $recommendation['rule']->item->sku }})</td>
                                                    <td>{{ $recommendation['rule']->warehouse->name }}</td>
                                                    <td>
                                                        <span class="badge badge-{{ $recommendation['priority'] == 'عالية' ? 'danger' : ($recommendation['priority'] == 'متوسطة' ? 'warning' : 'info') }}">
                                                            {{ $recommendation['priority'] }}
                                                        </span>
                                                    </td>
                                                    <td>{{ number_format($recommendation['current_stock'], 2) }}</td>
                                                    <td>
                                                        {{ number_format($recommendation['consumption_rate'], 2) }} / يوم
                                                        @if($recommendation['is_seasonal'])
                                                            <span class="badge badge-info" title="معدل استهلاك موسمي">
                                                                <i class="fas fa-calendar-alt"></i>
                                                            </span>
                                                        @endif
                                                    </td>
                                                    <td>{{ number_format($recommendation['current_min_quantity'], 2) }}</td>
                                                    <td>{{ number_format($recommendation['recommended_min_quantity'], 2) }}</td>
                                                    <td>{{ number_format($recommendation['current_order_quantity'], 2) }}</td>
                                                    <td>{{ number_format($recommendation['recommended_order_quantity'], 2) }}</td>
                                                    <td>
                                                        {{ number_format($recommendation['cost_savings'], 0) }} ريال
                                                        <small class="text-success">({{ number_format($recommendation['savings_percentage'], 1) }}%)</small>
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-success" data-toggle="modal" data-target="#applyModal{{ $recommendation['rule']->id }}">
                                                            <i class="fas fa-check"></i> تطبيق
                                                        </button>
                                                        <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#detailsModal{{ $recommendation['rule']->id }}">
                                                            <i class="fas fa-info-circle"></i> تفاصيل
                                                        </button>
                                                        
                                                        <!-- Modal التفاصيل -->
                                                        <div class="modal fade" id="detailsModal{{ $recommendation['rule']->id }}" tabindex="-1" role="dialog" aria-labelledby="detailsModalLabel{{ $recommendation['rule']->id }}" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg" role="document">
                                                                <div class="modal-content">
                                                                    <div class="modal-header bg-info">
                                                                        <h5 class="modal-title" id="detailsModalLabel{{ $recommendation['rule']->id }}">تفاصيل التوصية - {{ $recommendation['rule']->item->name }}</h5>
                                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                            <span aria-hidden="true">&times;</span>
                                                                        </button>
                                                                    </div>
                                                                    <div class="modal-body">
                                                                        <div class="row">
                                                                            <div class="col-md-6">
                                                                                <div class="card">
                                                                                    <div class="card-header bg-primary">
                                                                                        <h5 class="card-title">معلومات العنصر</h5>
                                                                                    </div>
                                                                                    <div class="card-body">
                                                                                        <table class="table table-bordered">
                                                                                            <tr>
                                                                                                <th>العنصر</th>
                                                                                                <td>{{ $recommendation['rule']->item->name }}</td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <th>الرمز</th>
                                                                                                <td>{{ $recommendation['rule']->item->sku }}</td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <th>المستودع</th>
                                                                                                <td>{{ $recommendation['rule']->warehouse->name }}</td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <th>المورد</th>
                                                                                                <td>{{ $recommendation['rule']->supplier->name }}</td>
                                                                                            </tr>
                                                                                            <tr>
                                                                                                <th>وقت التوريد</th>
                                                                                                <td>{{ $recommendation['lead_time'] }} يوم</td>
                                                                                            </tr>
                                                                                        </table>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            <div class="col-md-6">
                                                                                <div class="card">
                                                                                    <div class="card-header bg-warning">
                                                                                        <h5 class="card-title">أسباب التوصية</h5>
                                                                                    </div>
                                                                                    <div class="card-body">
                                                                                        <ul class="list-group">
                                                                                            @foreach($recommendation['reasons'] as $reason)
                                                                                                <li class="list-group-item">{{ $reason }}</li>
                                                                                            @endforeach
                                                                                        </ul>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                        <div class="row mt-3">
                                                                            <div class="col-md-12">
                                                                                <div class="card">
                                                                                    <div class="card-header bg-success">
                                                                                        <h5 class="card-title">التوفير المتوقع</h5>
                                                                                    </div>
                                                                                    <div class="card-body">
                                                                                        <div class="row">
                                                                                            <div class="col-md-6">
                                                                                                <div class="info-box">
                                                                                                    <span class="info-box-icon bg-warning"><i class="fas fa-money-bill"></i></span>
                                                                                                    <div class="info-box-content">
                                                                                                        <span class="info-box-text">التوفير السنوي</span>
                                                                                                        <span class="info-box-number">{{ number_format($recommendation['cost_savings'], 0) }} ريال</span>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                            <div class="col-md-6">
                                                                                                <div class="info-box">
                                                                                                    <span class="info-box-icon bg-success"><i class="fas fa-percentage"></i></span>
                                                                                                    <div class="info-box-content">
                                                                                                        <span class="info-box-text">نسبة التوفير</span>
                                                                                                        <span class="info-box-number">{{ number_format($recommendation['savings_percentage'], 1) }}%</span>
                                                                                                    </div>
                                                                                                </div>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                    <div class="modal-footer">
                                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                                                                        <button type="button" class="btn btn-success" data-dismiss="modal" data-toggle="modal" data-target="#applyModal{{ $recommendation['rule']->id }}">
                                                                            تطبيق التوصية
                                                                        </button>
                                                                    </div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        
                                                        <!-- Modal تطبيق التوصية -->
                                                        <div class="modal fade" id="applyModal{{ $recommendation['rule']->id }}" tabindex="-1" role="dialog" aria-labelledby="applyModalLabel{{ $recommendation['rule']->id }}" aria-hidden="true">
                                                            <div class="modal-dialog" role="document">
                                                                <div class="modal-content">
                                                                    <form action="{{ route('inventory.auto-purchase.apply-recommendation', $recommendation['rule']->id) }}" method="POST">
                                                                        @csrf
                                                                        <div class="modal-header bg-success">
                                                                            <h5 class="modal-title" id="applyModalLabel{{ $recommendation['rule']->id }}">تطبيق التوصية</h5>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <p>هل أنت متأكد من تطبيق التوصية على قاعدة الشراء التلقائي للعنصر: {{ $recommendation['rule']->item->name }}؟</p>
                                                                            
                                                                            <div class="form-group">
                                                                                <label for="min_quantity">الحد الأدنى الجديد</label>
                                                                                <input type="number" name="min_quantity" id="min_quantity" class="form-control" step="0.01" min="0" value="{{ $recommendation['recommended_min_quantity'] }}" required>
                                                                            </div>
                                                                            
                                                                            <div class="form-group">
                                                                                <label for="order_quantity">كمية الطلب الجديدة</label>
                                                                                <input type="number" name="order_quantity" id="order_quantity" class="form-control" step="0.01" min="0.01" value="{{ $recommendation['recommended_order_quantity'] }}" required>
                                                                            </div>
                                                                            
                                                                            <div class="alert alert-success">
                                                                                <i class="fas fa-info-circle"></i> التوفير المتوقع: {{ number_format($recommendation['cost_savings'], 0) }} ريال ({{ number_format($recommendation['savings_percentage'], 1) }}%)
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                            <button type="submit" class="btn btn-success">تطبيق</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-success">
                                    <i class="fa fa-check-circle"></i> لا توجد توصيات لتحسين القواعد الحالية.
                                </div>
                            @endif
                        </div>
                    </div>

                    <!-- العناصر التي تحتاج إلى قواعد شراء تلقائي -->
                    <div class="card mt-4">
                        <div class="card-header bg-info">
                            <h3 class="card-title">العناصر التي تحتاج إلى قواعد شراء تلقائي</h3>
                        </div>
                        <div class="card-body">
                            @if(count($itemsNeedingRules) > 0)
                                <div class="table-responsive">
                                    <table class="table table-bordered table-striped">
                                        <thead>
                                            <tr>
                                                <th>#</th>
                                                <th>العنصر</th>
                                                <th>الأولوية</th>
                                                <th>المخزون الحالي</th>
                                                <th>معدل الاستهلاك</th>
                                                <th>الأيام المتبقية</th>
                                                <th>المستودعات</th>
                                                <th>المورد المقترح</th>
                                                <th>الحد الأدنى الموصى به</th>
                                                <th>كمية الطلب الموصى بها</th>
                                                <th>الإجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @foreach($itemsNeedingRules as $index => $item)
                                                <tr class="{{ $item['priority'] == 'عالية' ? 'table-danger' : ($item['priority'] == 'متوسطة' ? 'table-warning' : '') }}">
                                                    <td>{{ $index + 1 }}</td>
                                                    <td>{{ $item['item']->name }} ({{ $item['item']->sku }})</td>
                                                    <td>
                                                        <span class="badge badge-{{ $item['priority'] == 'عالية' ? 'danger' : ($item['priority'] == 'متوسطة' ? 'warning' : 'info') }}">
                                                            {{ $item['priority'] }}
                                                        </span>
                                                    </td>
                                                    <td>{{ number_format($item['current_stock'], 2) }}</td>
                                                    <td>{{ number_format($item['daily_consumption_rate'], 2) }} / يوم</td>
                                                    <td>
                                                        @if($item['days_remaining'] !== null)
                                                            {{ number_format($item['days_remaining'], 0) }} يوم
                                                            @if($item['days_remaining'] < 7)
                                                                <span class="badge badge-danger">عاجل</span>
                                                            @endif
                                                        @else
                                                            <span class="badge badge-secondary">غير محدد</span>
                                                        @endif
                                                    </td>
                                                    <td>
                                                        <select class="form-control warehouse-select" data-index="{{ $index }}">
                                                            @foreach($item['warehouses'] as $warehouse)
                                                                <option value="{{ $warehouse->id }}">
                                                                    {{ $warehouse->name }}
                                                                    @if(isset($warehouse->current_stock))
                                                                        ({{ number_format($warehouse->current_stock, 2) }})
                                                                    @endif
                                                                </option>
                                                            @endforeach
                                                        </select>
                                                    </td>
                                                    <td>
                                                        @if($item['potential_supplier'])
                                                            {{ $item['potential_supplier']->name }}
                                                            @if(isset($item['potential_supplier']->avg_lead_time))
                                                                <small class="text-muted d-block">
                                                                    وقت التوريد: {{ number_format($item['potential_supplier']->avg_lead_time, 0) }} يوم
                                                                </small>
                                                            @endif
                                                        @else
                                                            <span class="badge badge-warning">يجب تحديد مورد</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ number_format($item['recommended_min_quantity'], 2) }}</td>
                                                    <td>{{ number_format($item['recommended_order_quantity'], 2) }}</td>
                                                    <td>
                                                        <button type="button" class="btn btn-sm btn-primary" data-toggle="modal" data-target="#createRuleModal{{ $index }}">
                                                            <i class="fas fa-plus-circle"></i> إنشاء قاعدة
                                                        </button>
                                                        
                                                        <!-- Modal -->
                                                        <div class="modal fade" id="createRuleModal{{ $index }}" tabindex="-1" role="dialog" aria-labelledby="createRuleModalLabel{{ $index }}" aria-hidden="true">
                                                            <div class="modal-dialog modal-lg" role="document">
                                                                <div class="modal-content">
                                                                    <form action="{{ route('inventory.auto-purchase.create-recommended-rule') }}" method="POST">
                                                                        @csrf
                                                                        <input type="hidden" name="item_id" value="{{ $item['item']->id }}">
                                                                        <input type="hidden" name="warehouse_id" id="warehouse_id_{{ $index }}" value="{{ $item['warehouses']->first()->id }}">
                                                                        
                                                                        <div class="modal-header bg-primary">
                                                                            <h5 class="modal-title" id="createRuleModalLabel{{ $index }}">إنشاء قاعدة شراء تلقائي ذكية</h5>
                                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                                <span aria-hidden="true">&times;</span>
                                                                            </button>
                                                                        </div>
                                                                        <div class="modal-body">
                                                                            <div class="row">
                                                                                <div class="col-md-6">
                                                                                    <div class="card">
                                                                                        <div class="card-header bg-info">
                                                                                            <h5 class="card-title">معلومات العنصر</h5>
                                                                                        </div>
                                                                                        <div class="card-body">
                                                                                            <table class="table table-bordered">
                                                                                                <tr>
                                                                                                    <th>العنصر</th>
                                                                                                    <td>{{ $item['item']->name }}</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <th>الرمز</th>
                                                                                                    <td>{{ $item['item']->sku }}</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <th>المخزون الحالي</th>
                                                                                                    <td>{{ number_format($item['current_stock'], 2) }}</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <th>معدل الاستهلاك</th>
                                                                                                    <td>{{ number_format($item['daily_consumption_rate'], 2) }} / يوم</td>
                                                                                                </tr>
                                                                                                <tr>
                                                                                                    <th>الأيام المتبقية</th>
                                                                                                    <td>
                                                                                                        @if($item['days_remaining'] !== null)
                                                                                                            {{ number_format($item['days_remaining'], 0) }} يوم
                                                                                                            @if($item['days_remaining'] < 7)
                                                                                                                <span class="badge badge-danger">عاجل</span>
                                                                                                            @endif
                                                                                                        @else
                                                                                                            غير محدد
                                                                                                        @endif
                                                                                                    </td>
                                                                                                </tr>
                                                                                            </table>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                                <div class="col-md-6">
                                                                                    <div class="card">
                                                                                        <div class="card-header bg-success">
                                                                                            <h5 class="card-title">إعدادات القاعدة</h5>
                                                                                        </div>
                                                                                        <div class="card-body">
                                                                                            <div class="form-group">
                                                                                                <label for="supplier_id">المورد</label>
                                                                                                <select name="supplier_id" class="form-control select2" required>
                                                                                                    <option value="">-- اختر المورد --</option>
                                                                                                    @foreach(App\Models\Supplier::where('company_id', auth()->user()->company_id)->where('is_active', true)->get() as $supplier)
                                                                                                        <option value="{{ $supplier->id }}" {{ $item['potential_supplier'] && $item['potential_supplier']->id == $supplier->id ? 'selected' : '' }}>
                                                                                                            {{ $supplier->name }}
                                                                                                        </option>
                                                                                                    @endforeach
                                                                                                </select>
                                                                                            </div>
                                                                                            
                                                                                            <div class="form-group">
                                                                                                <label for="min_quantity">الحد الأدنى للمخزون</label>
                                                                                                <div class="input-group">
                                                                                                    <input type="number" name="min_quantity" class="form-control" step="0.01" min="0" value="{{ $item['recommended_min_quantity'] }}" required>
                                                                                                    <div class="input-group-append">
                                                                                                        <span class="input-group-text">
                                                                                                            <i class="fas fa-info-circle" title="يمثل الكمية التي عندها يتم إنشاء طلب شراء جديد"></i>
                                                                                                        </span>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <small class="text-muted">
                                                                                                    يغطي {{ number_format($item['lead_time'], 0) }} يوم من وقت التوريد + مخزون أمان
                                                                                                </small>
                                                                                            </div>
                                                                                            
                                                                                            <div class="form-group">
                                                                                                <label for="order_quantity">كمية الطلب</label>
                                                                                                <div class="input-group">
                                                                                                    <input type="number" name="order_quantity" class="form-control" step="0.01" min="0.01" value="{{ $item['recommended_order_quantity'] }}" required>
                                                                                                    <div class="input-group-append">
                                                                                                        <span class="input-group-text">
                                                                                                            <i class="fas fa-info-circle" title="الكمية التي سيتم طلبها تلقائياً"></i>
                                                                                                        </span>
                                                                                                    </div>
                                                                                                </div>
                                                                                                <small class="text-muted">
                                                                                                    الكمية الاقتصادية المثلى للطلب (EOQ)
                                                                                                </small>
                                                                                            </div>
                                                                                            
                                                                                            <div class="form-group">
                                                                                                <label for="frequency_days">تكرار الفحص (أيام)</label>
                                                                                                <select name="frequency_days" class="form-control">
                                                                                                    <option value="1">يومياً</option>
                                                                                                    <option value="3">كل 3 أيام</option>
                                                                                                    <option value="7" selected>أسبوعياً</option>
                                                                                                    <option value="14">كل أسبوعين</option>
                                                                                                    <option value="30">شهرياً</option>
                                                                                                </select>
                                                                                            </div>
                                                                                        </div>
                                                                                    </div>
                                                                                </div>
                                                                            </div>
                                                                            
                                                                            <div class="alert alert-info mt-3">
                                                                                <i class="fas fa-lightbulb"></i> 
                                                                                <strong>توصية ذكية:</strong> 
                                                                                بناءً على معدل الاستهلاك الحالي ({{ number_format($item['daily_consumption_rate'], 2) }} / يوم)، 
                                                                                نوصي بإنشاء قاعدة شراء تلقائي لهذا العنصر لتجنب نفاد المخزون.
                                                                                @if($item['days_remaining'] !== null && $item['days_remaining'] < 14)
                                                                                    <br>
                                                                                    <strong class="text-danger">تنبيه:</strong> 
                                                                                    المخزون الحالي سينفد خلال {{ number_format($item['days_remaining'], 0) }} يوم فقط.
                                                                                @endif
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                            <button type="submit" class="btn btn-primary">
                                                                                <i class="fas fa-plus-circle"></i> إنشاء قاعدة ذكية
                                                                            </button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                            @endforeach
                                        </tbody>
                                    </table>
                                </div>
                            @else
                                <div class="alert alert-success">
                                    <i class="fa fa-check-circle"></i> لا توجد عناصر تحتاج إلى قواعد شراء تلقائي.
                                </div>
                            @endif
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">ملاحظات</h3>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        <li>يتم حساب التوصيات بناءً على معدلات الاستهلاك الحالية ومستويات المخزون.</li>
                                        <li>الحد الأدنى الموصى به يعادل استهلاك أسبوع واحد.</li>
                                        <li>كمية الطلب الموصى بها تعادل استهلاك شهر واحد.</li>
                                        <li>يمكنك تعديل القيم الموصى بها قبل تطبيقها حسب احتياجات عملك.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script>
    $(function() {
        // تهيئة Select2
        $('.select2').select2({
            dir: 'rtl',
            language: 'ar'
        });
        
        // تهيئة DataTables
        $('table.table').DataTable({
            "paging": true,
            "lengthChange": true,
            "searching": true,
            "ordering": true,
            "info": true,
            "autoWidth": false,
            "responsive": true,
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.25/i18n/Arabic.json"
            }
        });
        
        // تحديث قيمة المستودع المختار عند تغييره
        $('.warehouse-select').on('change', function() {
            var index = $(this).data('index');
            $('#warehouse_id_' + index).val($(this).val());
        });
        
        // تلوين الصفوف حسب الأولوية
        $('tr').each(function() {
            const priority = $(this).find('.badge').text().trim();
            if (priority === 'عالية') {
                $(this).addClass('table-danger');
            } else if (priority === 'متوسطة') {
                $(this).addClass('table-warning');
            }
        });
    });
</script>
@endsection