@extends('layouts.modern')

@section('title', 'أداء قواعد الشراء التلقائي')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.analytics') }}">تحليلات الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">أداء القواعد</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">أداء قواعد الشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.analytics') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> يعرض هذا التقرير تقييم أداء قواعد الشراء التلقائي بناءً على تاريخ تشغيلها ومدى فعاليتها في منع نفاد المخزون.
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنصر</th>
                                    <th>المستودع</th>
                                    <th>عدد مرات التشغيل</th>
                                    <th>متوسط الوقت بين الطلبات</th>
                                    <th>عدد مرات نفاد المخزون</th>
                                    <th>درجة الأداء</th>
                                    <th>المستوى</th>
                                    <th>المشاكل والتوصيات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($performanceData as $index => $data)
                                    <tr>
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $data['rule']->item->name }} ({{ $data['rule']->item->sku }})</td>
                                        <td>{{ $data['rule']->warehouse->name }}</td>
                                        <td>{{ $data['trigger_count'] }}</td>
                                        <td>
                                            @if($data['avg_time_between_orders'] !== null)
                                                {{ number_format($data['avg_time_between_orders'], 1) }} يوم
                                            @else
                                                <span class="badge badge-secondary">غير متوفر</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($data['stockout_count'] > 0)
                                                <span class="badge badge-danger">{{ $data['stockout_count'] }}</span>
                                            @else
                                                <span class="badge badge-success">0</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar 
                                                    @if($data['performance']['score'] >= 90) bg-success
                                                    @elseif($data['performance']['score'] >= 70) bg-info
                                                    @elseif($data['performance']['score'] >= 50) bg-warning
                                                    @else bg-danger @endif"
                                                    role="progressbar" style="width: {{ $data['performance']['score'] }}%"
                                                    aria-valuenow="{{ $data['performance']['score'] }}" aria-valuemin="0" aria-valuemax="100">
                                                    {{ $data['performance']['score'] }}%
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <span class="badge 
                                                @if($data['performance']['score'] >= 90) badge-success
                                                @elseif($data['performance']['score'] >= 70) badge-info
                                                @elseif($data['performance']['score'] >= 50) badge-warning
                                                @else badge-danger @endif">
                                                {{ $data['performance']['level'] }}
                                            </span>
                                        </td>
                                        <td>
                                            @if(count($data['performance']['issues']) > 0)
                                                <button type="button" class="btn btn-sm btn-info" data-toggle="modal" data-target="#issuesModal{{ $index }}">
                                                    عرض المشاكل والتوصيات
                                                </button>
                                                
                                                <!-- Modal -->
                                                <div class="modal fade" id="issuesModal{{ $index }}" tabindex="-1" role="dialog" aria-labelledby="issuesModalLabel{{ $index }}" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="issuesModalLabel{{ $index }}">المشاكل والتوصيات</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                <h6>المشاكل:</h6>
                                                                <ul>
                                                                    @foreach($data['performance']['issues'] as $issue)
                                                                        <li>{{ $issue }}</li>
                                                                    @endforeach
                                                                </ul>
                                                                
                                                                <h6>التوصيات:</h6>
                                                                <ul>
                                                                    @foreach($data['performance']['recommendations'] as $recommendation)
                                                                        <li>{{ $recommendation }}</li>
                                                                    @endforeach
                                                                </ul>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
                                                                <a href="{{ route('inventory.auto-purchase.edit', $data['rule']->id) }}" class="btn btn-primary">تعديل القاعدة</a>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            @else
                                                <span class="badge badge-success">لا توجد مشاكل</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">ملاحظات</h3>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        <li>يتم تقييم أداء القواعد بناءً على عدة عوامل منها عدد مرات نفاد المخزون، وتكرار الطلبات، وفعالية القاعدة.</li>
                                        <li>درجة الأداء 100% تعني أن القاعدة تعمل بشكل مثالي دون أي مشاكل.</li>
                                        <li>يتم خصم نقاط من درجة الأداء لكل مشكلة يتم اكتشافها في أداء القاعدة.</li>
                                        <li>يمكنك الاطلاع على المشاكل والتوصيات لكل قاعدة لتحسين أدائها.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection