@extends('layouts.modern')

@section('title', 'قواعد الشراء التلقائي')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">قواعد الشراء التلقائي</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">المخزون</a></li>
        <li class="breadcrumb-item active">قواعد الشراء التلقائي</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <i class="fas fa-cogs me-1"></i>
                    قواعد الشراء التلقائي
                </div>
                <div>
                    @can('create_auto_purchase')
                    <a href="{{ route('inventory.auto-purchase.create') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-plus"></i> إضافة قاعدة جديدة
                    </a>
                    @endcan
                    @can('run_auto_purchase_check')
                    <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-primary btn-sm" 
                       onclick="return confirm('هل أنت متأكد من تشغيل فحص الشراء التلقائي؟ قد يؤدي ذلك إلى إنشاء طلبات شراء جديدة.')">
                        <i class="fas fa-sync"></i> تشغيل فحص المخزون
                    </a>
                    @endcan
                </div>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if(count($rules) > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>العنصر</th>
                                <th>المورد</th>
                                <th>المستودع</th>
                                <th>الحد الأدنى</th>
                                <th>كمية الطلب</th>
                                <th>تكرار الفحص (أيام)</th>
                                <th>الفحص التالي</th>
                                <th>آخر تشغيل</th>
                                <th>الحالة</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($rules as $rule)
                                <tr>
                                    <td>{{ $rule->item->name }}</td>
                                    <td>{{ $rule->supplier->name }}</td>
                                    <td>{{ $rule->warehouse->name }}</td>
                                    <td>{{ $rule->min_quantity }}</td>
                                    <td>{{ $rule->order_quantity }}</td>
                                    <td>{{ $rule->frequency_days }}</td>
                                    <td>{{ $rule->next_check_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($rule->last_triggered_at)
                                            {{ $rule->last_triggered_at->format('Y-m-d H:i') }}
                                        @else
                                            <span class="text-muted">لم يتم التشغيل بعد</span>
                                        @endif
                                    </td>
                                    <td>
                                        @if($rule->is_active)
                                            <span class="badge bg-success">نشط</span>
                                        @else
                                            <span class="badge bg-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            @can('view_auto_purchase')
                                            <a href="{{ route('inventory.auto-purchase.show', $rule->id) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('edit_auto_purchase')
                                            <a href="{{ route('inventory.auto-purchase.edit', $rule->id) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('delete_auto_purchase')
                                            <form action="{{ route('inventory.auto-purchase.destroy', $rule->id) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه القاعدة؟')">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-sm">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="alert alert-info">
                    لا توجد قواعد شراء تلقائي حالياً. <a href="{{ route('inventory.auto-purchase.create') }}">إضافة قاعدة جديدة</a>
                </div>
            @endif
        </div>
        <div class="card-footer">
            <div class="alert alert-info mb-0">
                <h5><i class="fas fa-info-circle"></i> كيفية عمل الشراء التلقائي</h5>
                <p>
                    يقوم نظام الشراء التلقائي بفحص مستويات المخزون بشكل دوري وإنشاء طلبات شراء تلقائية عندما ينخفض المخزون عن الحد الأدنى المحدد.
                    <br>
                    يمكنك تحديد الحد الأدنى للمخزون وكمية الطلب وتكرار الفحص لكل عنصر ومورد ومستودع.
                </p>
                <p>
                    <strong>الحد الأدنى:</strong> عندما ينخفض المخزون عن هذه القيمة، سيتم إنشاء طلب شراء تلقائي.
                    <br>
                    <strong>كمية الطلب:</strong> الكمية التي سيتم طلبها تلقائياً.
                    <br>
                    <strong>تكرار الفحص:</strong> عدد الأيام بين عمليات الفحص المتتالية (0 = يومياً).
                </p>
            </div>
        </div>
    </div>
</div>
@endsection