@extends('layouts.modern')

@section('title', 'سجل طلبات الشراء التلقائية')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">سجل طلبات الشراء التلقائية</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.index') }}">قواعد الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">سجل الطلبات التلقائية</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <i class="fas fa-history me-1"></i>
                    سجل طلبات الشراء التلقائية
                </div>
                <div>
                    <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-primary btn-sm">
                        <i class="fas fa-cogs"></i> قواعد الشراء التلقائي
                    </a>
                    <a href="{{ route('inventory.auto-purchase.dashboard') }}" class="btn btn-info btn-sm">
                        <i class="fas fa-chart-line"></i> لوحة المعلومات
                    </a>
                    <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-success btn-sm">
                        <i class="fas fa-sync"></i> تشغيل فحص المخزون
                    </a>
                </div>
            </div>
        </div>
        <div class="card-body">
            @if(session('success'))
                <div class="alert alert-success">
                    {{ session('success') }}
                </div>
            @endif

            @if($purchaseOrders->count() > 0)
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>رقم الطلب</th>
                                <th>المورد</th>
                                <th>المستودع</th>
                                <th>تاريخ الطلب</th>
                                <th>تاريخ التسليم المتوقع</th>
                                <th>الحالة</th>
                                <th>المبلغ الإجمالي</th>
                                <th>العناصر</th>
                                <th>الإجراءات</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($purchaseOrders as $order)
                                <tr>
                                    <td>{{ $order->po_number }}</td>
                                    <td>{{ $order->supplier->name }}</td>
                                    <td>{{ $order->warehouse->name }}</td>
                                    <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                    <td>{{ $order->expected_delivery_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($order->status == 'draft')
                                            <span class="badge bg-secondary">مسودة</span>
                                        @elseif($order->status == 'approved')
                                            <span class="badge bg-primary">معتمد</span>
                                        @elseif($order->status == 'partial')
                                            <span class="badge bg-info">استلام جزئي</span>
                                        @elseif($order->status == 'completed')
                                            <span class="badge bg-success">مكتمل</span>
                                        @elseif($order->status == 'cancelled')
                                            <span class="badge bg-danger">ملغي</span>
                                        @endif
                                    </td>
                                    <td>{{ number_format($order->total_amount, 2) }}</td>
                                    <td>{{ $order->items->count() }}</td>
                                    <td>
                                        <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-info btn-sm">
                                            <i class="fas fa-eye"></i> عرض
                                        </a>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="mt-4">
                    {{ $purchaseOrders->links() }}
                </div>
            @else
                <div class="alert alert-info">
                    لا توجد طلبات شراء تلقائية حالياً.
                </div>
            @endif
        </div>
        <div class="card-footer">
            <div class="alert alert-info mb-0">
                <h5><i class="fas fa-info-circle"></i> معلومات عن طلبات الشراء التلقائية</h5>
                <p>
                    يقوم نظام الشراء التلقائي بإنشاء طلبات شراء تلقائية عندما ينخفض المخزون عن الحد الأدنى المحدد في قواعد الشراء التلقائي.
                    <br>
                    يمكن التعرف على طلبات الشراء التلقائية من خلال رقم الطلب الذي يبدأ بـ "AUTO-".
                </p>
            </div>
        </div>
    </div>
</div>
@endsection