@extends('layouts.modern')

@section('title', 'توقعات الشراء التلقائي')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.analytics') }}">تحليلات الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">توقعات الشراء</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">توقعات الشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.analytics') }}" class="btn btn-secondary btn-sm">
                            <i class="fa fa-arrow-right"></i> رجوع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-4">
                        <div class="col-md-12">
                            <div class="alert alert-info">
                                <i class="fa fa-info-circle"></i> يعرض هذا التقرير توقعات الشراء التلقائي بناءً على معدلات الاستهلاك الحالية ومستويات المخزون.
                            </div>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنصر</th>
                                    <th>المستودع</th>
                                    <th>المخزون الحالي</th>
                                    <th>الحد الأدنى</th>
                                    <th>معدل الاستهلاك اليومي</th>
                                    <th>الأيام المتبقية</th>
                                    <th>تاريخ الطلب المتوقع</th>
                                    <th>الحالة</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($forecastItems as $index => $item)
                                    <tr class="{{ $item['needs_attention'] ? 'table-danger' : '' }}">
                                        <td>{{ $index + 1 }}</td>
                                        <td>{{ $item['rule']->item->name }} ({{ $item['rule']->item->sku }})</td>
                                        <td>{{ $item['rule']->warehouse->name }}</td>
                                        <td>{{ number_format($item['current_stock'], 2) }}</td>
                                        <td>{{ number_format($item['rule']->min_quantity, 2) }}</td>
                                        <td>{{ number_format($item['consumption_rate'], 2) }} / يوم</td>
                                        <td>
                                            @if($item['days_remaining'] !== null)
                                                {{ $item['days_remaining'] > 0 ? $item['days_remaining'] . ' يوم' : 'تم الوصول للحد الأدنى' }}
                                            @else
                                                <span class="badge badge-secondary">لا يوجد استهلاك</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($item['expected_order_date'] !== null)
                                                {{ $item['expected_order_date']->format('Y-m-d') }}
                                            @else
                                                <span class="badge badge-secondary">غير محدد</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($item['needs_attention'])
                                                <span class="badge badge-danger">يحتاج اهتمام</span>
                                            @elseif($item['days_remaining'] !== null && $item['days_remaining'] <= 14)
                                                <span class="badge badge-warning">قريباً</span>
                                            @elseif($item['days_remaining'] !== null)
                                                <span class="badge badge-success">جيد</span>
                                            @else
                                                <span class="badge badge-secondary">غير نشط</span>
                                            @endif
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد بيانات متاحة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">ملاحظات</h3>
                                </div>
                                <div class="card-body">
                                    <ul>
                                        <li>يتم حساب معدل الاستهلاك اليومي بناءً على بيانات الاستهلاك خلال آخر 90 يوم.</li>
                                        <li>الأيام المتبقية هي عدد الأيام المتوقعة قبل الوصول إلى الحد الأدنى للمخزون.</li>
                                        <li>تاريخ الطلب المتوقع هو التاريخ الذي سيصل فيه المخزون إلى الحد الأدنى وسيتم إنشاء طلب شراء تلقائي.</li>
                                        <li>العناصر التي تحتاج إلى اهتمام هي التي من المتوقع أن تصل إلى الحد الأدنى خلال 7 أيام.</li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection