@extends('layouts.modern')

@section('title', 'لوحة معلومات الشراء التلقائي')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">لوحة معلومات الشراء التلقائي</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">المخزون</a></li>
        <li class="breadcrumb-item active">لوحة معلومات الشراء التلقائي</li>
    </ol>

    <!-- بطاقات الإحصائيات -->
    <div class="row">
        <div class="col-xl-3 col-md-6">
            <div class="card bg-primary text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $totalRules }}</h5>
                            <div class="small">إجمالي القواعد</div>
                        </div>
                        <div>
                            <i class="fas fa-cogs fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.auto-purchase.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-success text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $activeRules }}</h5>
                            <div class="small">القواعد النشطة</div>
                        </div>
                        <div>
                            <i class="fas fa-check-circle fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.auto-purchase.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-info text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $totalAutoOrders }}</h5>
                            <div class="small">طلبات الشراء التلقائية</div>
                        </div>
                        <div>
                            <i class="fas fa-shopping-cart fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.auto-purchase.history') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
        <div class="col-xl-3 col-md-6">
            <div class="card bg-warning text-white mb-4">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5 class="mb-0">{{ $lowStockItems->count() }}</h5>
                            <div class="small">عناصر منخفضة المخزون</div>
                        </div>
                        <div>
                            <i class="fas fa-exclamation-triangle fa-2x"></i>
                        </div>
                    </div>
                </div>
                <div class="card-footer d-flex align-items-center justify-content-between">
                    <a class="small text-white stretched-link" href="{{ route('inventory.stock.index') }}">عرض التفاصيل</a>
                    <div class="small text-white"><i class="fas fa-angle-left"></i></div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- العناصر منخفضة المخزون -->
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-exclamation-triangle me-1"></i>
                    العناصر منخفضة المخزون
                </div>
                <div class="card-body">
                    @if($lowStockItems->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>الفئة</th>
                                        <th>المخزون الحالي</th>
                                        <th>الحد الأدنى</th>
                                        <th>المستودع</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($lowStockItems as $item)
                                        @foreach($item->stocks as $stock)
                                            @if($stock->quantity <= $item->min_stock)
                                                <tr>
                                                    <td>{{ $item->name }}</td>
                                                    <td>{{ $item->category->name ?? 'غير مصنف' }}</td>
                                                    <td class="text-danger">{{ $stock->quantity }}</td>
                                                    <td>{{ $item->min_stock }}</td>
                                                    <td>{{ $stock->warehouse->name }}</td>
                                                    <td>
                                                        <a href="{{ route('inventory.auto-purchase.create') }}" class="btn btn-sm btn-primary">
                                                            <i class="fas fa-plus"></i> إنشاء قاعدة
                                                        </a>
                                                    </td>
                                                </tr>
                                            @endif
                                        @endforeach
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-success">
                            لا توجد عناصر منخفضة المخزون حالياً.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-sm btn-success">
                        <i class="fas fa-sync"></i> تشغيل فحص المخزون
                    </a>
                </div>
            </div>
        </div>

        <!-- القواعد التي سيتم فحصها قريبًا -->
        <div class="col-xl-6">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-calendar-alt me-1"></i>
                    القواعد التي سيتم فحصها قريبًا
                </div>
                <div class="card-body">
                    @if($upcomingChecks->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>العنصر</th>
                                        <th>المورد</th>
                                        <th>المستودع</th>
                                        <th>تاريخ الفحص التالي</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($upcomingChecks as $rule)
                                        <tr>
                                            <td>{{ $rule->item->name }}</td>
                                            <td>{{ $rule->supplier->name }}</td>
                                            <td>{{ $rule->warehouse->name }}</td>
                                            <td>{{ $rule->next_check_date->format('Y-m-d') }}</td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            لا توجد قواعد للفحص قريبًا.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-list"></i> عرض جميع القواعد
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- آخر طلبات الشراء التلقائية -->
        <div class="col-xl-12">
            <div class="card mb-4">
                <div class="card-header">
                    <i class="fas fa-shopping-cart me-1"></i>
                    آخر طلبات الشراء التلقائية
                </div>
                <div class="card-body">
                    @if($recentAutoOrders->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>رقم الطلب</th>
                                        <th>المورد</th>
                                        <th>المستودع</th>
                                        <th>تاريخ الطلب</th>
                                        <th>تاريخ التسليم المتوقع</th>
                                        <th>الحالة</th>
                                        <th>المبلغ الإجمالي</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($recentAutoOrders as $order)
                                        <tr>
                                            <td>{{ $order->po_number }}</td>
                                            <td>{{ $order->supplier->name }}</td>
                                            <td>{{ $order->warehouse->name }}</td>
                                            <td>{{ $order->order_date->format('Y-m-d') }}</td>
                                            <td>{{ $order->expected_delivery_date->format('Y-m-d') }}</td>
                                            <td>
                                                @if($order->status == 'draft')
                                                    <span class="badge bg-secondary">مسودة</span>
                                                @elseif($order->status == 'approved')
                                                    <span class="badge bg-primary">معتمد</span>
                                                @elseif($order->status == 'partial')
                                                    <span class="badge bg-info">استلام جزئي</span>
                                                @elseif($order->status == 'completed')
                                                    <span class="badge bg-success">مكتمل</span>
                                                @elseif($order->status == 'cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                @endif
                                            </td>
                                            <td>{{ number_format($order->total_amount, 2) }}</td>
                                            <td>
                                                <a href="{{ route('inventory.purchase-orders.show', $order->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                    @else
                        <div class="alert alert-info">
                            لا توجد طلبات شراء تلقائية حديثة.
                        </div>
                    @endif
                </div>
                <div class="card-footer">
                    <a href="{{ route('inventory.auto-purchase.history') }}" class="btn btn-sm btn-primary">
                        <i class="fas fa-list"></i> عرض سجل الطلبات التلقائية
                    </a>
                </div>
            </div>
        </div>
    </div>

    <div class="row mb-4">
        <div class="col-12">
            <div class="card">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div>
                            <h5>إدارة الشراء التلقائي</h5>
                            <p class="text-muted">يمكنك إدارة قواعد الشراء التلقائي وتشغيل فحص المخزون يدويًا</p>
                        </div>
                        <div>
                            <a href="{{ route('inventory.auto-purchase.create') }}" class="btn btn-primary me-2">
                                <i class="fas fa-plus"></i> إنشاء قاعدة جديدة
                            </a>
                            <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-success">
                                <i class="fas fa-sync"></i> تشغيل فحص المخزون
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection