@extends('layouts.modern')

@section('title', 'إنشاء قاعدة شراء تلقائي جديدة')

@section('content')
<div class="container-fluid px-4">
    <h1 class="mt-4">إنشاء قاعدة شراء تلقائي جديدة</h1>
    <ol class="breadcrumb mb-4">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">المخزون</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.auto-purchase.index') }}">قواعد الشراء التلقائي</a></li>
        <li class="breadcrumb-item active">إنشاء قاعدة جديدة</li>
    </ol>

    <div class="card mb-4">
        <div class="card-header">
            <i class="fas fa-plus me-1"></i>
            إنشاء قاعدة شراء تلقائي جديدة
        </div>
        <div class="card-body">
            @if ($errors->any())
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form action="{{ route('inventory.auto-purchase.store') }}" method="POST">
                @csrf
                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="item_id" class="form-label">العنصر <span class="text-danger">*</span></label>
                            <select name="item_id" id="item_id" class="form-select @error('item_id') is-invalid @enderror" required>
                                <option value="">-- اختر العنصر --</option>
                                @foreach($items as $item)
                                    <option value="{{ $item->id }}" {{ old('item_id') == $item->id ? 'selected' : '' }}>
                                        {{ $item->name }} ({{ $item->sku }})
                                    </option>
                                @endforeach
                            </select>
                            @error('item_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="supplier_id" class="form-label">المورد <span class="text-danger">*</span></label>
                            <select name="supplier_id" id="supplier_id" class="form-select @error('supplier_id') is-invalid @enderror" required>
                                <option value="">-- اختر المورد --</option>
                                @foreach($suppliers as $supplier)
                                    <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                        {{ $supplier->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('supplier_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="warehouse_id" class="form-label">المستودع <span class="text-danger">*</span></label>
                            <select name="warehouse_id" id="warehouse_id" class="form-select @error('warehouse_id') is-invalid @enderror" required>
                                <option value="">-- اختر المستودع --</option>
                                @foreach($warehouses as $warehouse)
                                    <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                        {{ $warehouse->name }}
                                    </option>
                                @endforeach
                            </select>
                            @error('warehouse_id')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="min_quantity" class="form-label">الحد الأدنى للمخزون <span class="text-danger">*</span></label>
                            <input type="number" name="min_quantity" id="min_quantity" class="form-control @error('min_quantity') is-invalid @enderror" 
                                value="{{ old('min_quantity') }}" min="0" step="0.01" required>
                            <div class="form-text">عندما ينخفض المخزون عن هذه القيمة، سيتم إنشاء طلب شراء تلقائي</div>
                            @error('min_quantity')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="order_quantity" class="form-label">كمية الطلب <span class="text-danger">*</span></label>
                            <input type="number" name="order_quantity" id="order_quantity" class="form-control @error('order_quantity') is-invalid @enderror" 
                                value="{{ old('order_quantity') }}" min="1" step="0.01" required>
                            <div class="form-text">الكمية التي سيتم طلبها تلقائياً</div>
                            @error('order_quantity')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <label for="frequency_days" class="form-label">تكرار الفحص (أيام)</label>
                            <input type="number" name="frequency_days" id="frequency_days" class="form-control @error('frequency_days') is-invalid @enderror" 
                                value="{{ old('frequency_days', 0) }}" min="0" step="1">
                            <div class="form-text">عدد الأيام بين عمليات الفحص المتتالية (0 = يومياً)</div>
                            @error('frequency_days')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="mb-3">
                    <div class="form-check">
                        <input type="checkbox" name="is_active" id="is_active" class="form-check-input" value="1" {{ old('is_active') ? 'checked' : '' }}>
                        <label for="is_active" class="form-check-label">نشط</label>
                        <div class="form-text">تفعيل أو تعطيل هذه القاعدة</div>
                    </div>
                </div>

                <div class="mb-3">
                    <button type="submit" class="btn btn-primary">حفظ</button>
                    <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-secondary">إلغاء</a>
                </div>
            </form>
        </div>
        <div class="card-footer">
            <div class="alert alert-info mb-0">
                <h5><i class="fas fa-info-circle"></i> معلومات مساعدة</h5>
                <p>
                    <strong>الحد الأدنى للمخزون:</strong> عندما ينخفض المخزون عن هذه القيمة، سيتم إنشاء طلب شراء تلقائي.
                    <br>
                    <strong>كمية الطلب:</strong> الكمية التي سيتم طلبها تلقائياً.
                    <br>
                    <strong>تكرار الفحص:</strong> عدد الأيام بين عمليات الفحص المتتالية (0 = يومياً).
                </p>
                <p>
                    سيقوم النظام بفحص مستويات المخزون بشكل دوري وإنشاء طلبات شراء تلقائية عندما ينخفض المخزون عن الحد الأدنى المحدد.
                </p>
            </div>
        </div>
    </div>
</div>
@endsection