@extends('layouts.modern')

@section('title', 'تحليلات الشراء التلقائي')

@section('breadcrumb')
    <ol class="breadcrumb float-sm-right">
        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
        <li class="breadcrumb-item"><a href="{{ route('inventory.dashboard') }}">إدارة المخزون</a></li>
        <li class="breadcrumb-item active">تحليلات الشراء التلقائي</li>
    </ol>
@endsection

@section('content')
    <div class="row">
        <div class="col-md-12">
            <div class="card card-primary card-outline">
                <div class="card-header">
                    <h3 class="card-title">تحليلات الشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.forecast') }}" class="btn btn-info btn-sm">
                            <i class="fa fa-chart-line"></i> توقعات الشراء
                        </a>
                        <a href="{{ route('inventory.auto-purchase.performance') }}" class="btn btn-success btn-sm">
                            <i class="fa fa-chart-bar"></i> أداء القواعد
                        </a>
                        <a href="{{ route('inventory.auto-purchase.recommendations') }}" class="btn btn-warning btn-sm">
                            <i class="fa fa-lightbulb"></i> التوصيات
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- إحصائيات عامة -->
                    <div class="row">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_rules'] }}</h3>
                                    <p>إجمالي قواعد الشراء</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-list"></i>
                                </div>
                                <a href="{{ route('inventory.auto-purchase.index') }}" class="small-box-footer">
                                    عرض القواعد <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['active_rules'] }}</h3>
                                    <p>القواعد النشطة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <a href="{{ route('inventory.auto-purchase.index') }}" class="small-box-footer">
                                    عرض القواعد <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['auto_orders'] }}</h3>
                                    <p>طلبات الشراء التلقائية</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                <a href="{{ route('inventory.purchase-orders.index') }}" class="small-box-footer">
                                    عرض الطلبات <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ number_format($stats['auto_orders_value'], 2) }}</h3>
                                    <p>قيمة الطلبات التلقائية</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-money-bill-wave"></i>
                                </div>
                                <a href="{{ route('inventory.purchase-orders.index') }}" class="small-box-footer">
                                    عرض الطلبات <i class="fas fa-arrow-circle-left"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- أكثر العناصر طلباً بشكل تلقائي -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-primary">
                                    <h3 class="card-title">أكثر العناصر طلباً بشكل تلقائي</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>العنصر</th>
                                                    <th>عدد الطلبات</th>
                                                    <th>إجمالي الكمية</th>
                                                    <th>إجمالي القيمة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($topItems as $item)
                                                    <tr>
                                                        <td>{{ $item->name }} ({{ $item->sku }})</td>
                                                        <td>{{ $item->order_count }}</td>
                                                        <td>{{ number_format($item->total_quantity, 2) }}</td>
                                                        <td>{{ number_format($item->total_amount, 2) }} {{ auth()->user()->company->currency }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="4" class="text-center">لا توجد بيانات متاحة</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- أكثر الموردين استخداماً في الشراء التلقائي -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-success">
                                    <h3 class="card-title">أكثر الموردين استخداماً في الشراء التلقائي</h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>المورد</th>
                                                    <th>عدد الطلبات</th>
                                                    <th>إجمالي القيمة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($topSuppliers as $supplier)
                                                    <tr>
                                                        <td>{{ $supplier->name }}</td>
                                                        <td>{{ $supplier->order_count }}</td>
                                                        <td>{{ number_format($supplier->total_amount, 2) }} {{ auth()->user()->company->currency }}</td>
                                                    </tr>
                                                @empty
                                                    <tr>
                                                        <td colspan="3" class="text-center">لا توجد بيانات متاحة</td>
                                                    </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- توزيع حالات طلبات الشراء التلقائية -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-info">
                                    <h3 class="card-title">توزيع حالات طلبات الشراء التلقائية</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="orderStatusChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- العناصر التي تحتاج إلى مراجعة قواعد الشراء التلقائي -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-warning">
                                    <h3 class="card-title">العناصر التي تحتاج إلى مراجعة</h3>
                                </div>
                                <div class="card-body">
                                    @if(count($itemsNeedingReview) > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>العنصر</th>
                                                        <th>المستودع</th>
                                                        <th>المشكلة</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($itemsNeedingReview as $item)
                                                        <tr>
                                                            <td>{{ $item['rule']->item->name }}</td>
                                                            <td>{{ $item['rule']->warehouse->name }}</td>
                                                            <td>
                                                                <ul class="mb-0 pr-3">
                                                                    @foreach($item['issues'] as $issue)
                                                                        <li>{{ $issue }}</li>
                                                                    @endforeach
                                                                </ul>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        <div class="mt-3">
                                            <a href="{{ route('inventory.auto-purchase.recommendations') }}" class="btn btn-warning btn-block">
                                                <i class="fa fa-lightbulb"></i> عرض التوصيات
                                            </a>
                                        </div>
                                    @else
                                        <div class="alert alert-success">
                                            <i class="fa fa-check-circle"></i> جميع قواعد الشراء التلقائي تعمل بشكل جيد.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
<script src="{{ asset('plugins/chart.js/Chart.min.js') }}"></script>
<script>
    $(function() {
        // رسم بياني لتوزيع حالات طلبات الشراء
        var orderStatusData = {
            labels: [
                @foreach($orderStatusDistribution as $status)
                    '{{ $status->status }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($orderStatusDistribution as $status)
                        {{ $status->count }},
                    @endforeach
                ],
                backgroundColor: ['#f56954', '#00a65a', '#f39c12', '#00c0ef', '#3c8dbc', '#d2d6de'],
            }]
        };

        var orderStatusOptions = {
            maintainAspectRatio: false,
            responsive: true,
        };

        var orderStatusCanvas = $('#orderStatusChart').get(0).getContext('2d');
        new Chart(orderStatusCanvas, {
            type: 'pie',
            data: orderStatusData,
            options: orderStatusOptions
        });
    });
</script>
@endsection