@extends('layouts.modern')

@section('title', 'الشراء التلقائي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">قواعد الشراء التلقائي</h3>
                    <div class="card-tools">
                        @if(auth()->user()->hasPermission('create_auto_purchase_rule'))
                        <a href="{{ route('inventory.auto-purchase.create') }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus"></i> إضافة قاعدة جديدة
                        </a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنصر</th>
                                    <th>الحد الأدنى</th>
                                    <th>الحد الأقصى</th>
                                    <th>كمية الطلب</th>
                                    <th>المورد المفضل</th>
                                    <th>الحالة</th>
                                    <th>آخر تشغيل</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($rules as $rule)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $rule->item->name }}</td>
                                    <td>{{ $rule->min_quantity }}</td>
                                    <td>{{ $rule->max_quantity }}</td>
                                    <td>{{ $rule->order_quantity }}</td>
                                    <td>{{ $rule->supplier ? $rule->supplier->name : 'غير محدد' }}</td>
                                    <td>
                                        @if($rule->is_active)
                                        <span class="badge badge-success">نشط</span>
                                        @else
                                        <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>{{ $rule->last_run_at ? $rule->last_run_at->format('Y-m-d H:i') : 'لم يتم التشغيل بعد' }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('inventory.auto-purchase.show', $rule->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if(auth()->user()->hasPermission('create_auto_purchase_rule'))
                                            <a href="{{ route('inventory.auto-purchase.edit', $rule->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-sm btn-danger delete-btn" data-id="{{ $rule->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="9" class="text-center">لا توجد قواعد شراء تلقائي</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="row">
                        <div class="col-md-6">
                            {{ $rules->links() }}
                        </div>
                        <div class="col-md-6 text-right">
                            <a href="{{ route('inventory.auto-purchase.run-check') }}" class="btn btn-primary">
                                <i class="fas fa-sync"></i> تشغيل فحص المخزون
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Delete Confirmation -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من حذف هذه القاعدة؟
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST" action="">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.delete-btn').on('click', function() {
            var id = $(this).data('id');
            $('#deleteForm').attr('action', "{{ route('inventory.auto-purchase.destroy', '') }}/" + id);
            $('#deleteModal').modal('show');
        });
    });
</script>
@endsection