@extends('layouts.modern')

@section('title', 'إنشاء قاعدة شراء تلقائي جديدة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إنشاء قاعدة شراء تلقائي جديدة</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <form action="{{ route('inventory.auto-purchase.store') }}" method="POST">
                    @csrf
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="item_id">العنصر <span class="text-danger">*</span></label>
                                    <select name="item_id" id="item_id" class="form-control select2 @error('item_id') is-invalid @enderror" required>
                                        <option value="">-- اختر العنصر --</option>
                                        @foreach($items as $item)
                                        <option value="{{ $item->id }}" {{ old('item_id') == $item->id ? 'selected' : '' }}>
                                            {{ $item->name }} ({{ $item->code }})
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('item_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="warehouse_id">المستودع <span class="text-danger">*</span></label>
                                    <select name="warehouse_id" id="warehouse_id" class="form-control select2 @error('warehouse_id') is-invalid @enderror" required>
                                        <option value="">-- اختر المستودع --</option>
                                        @foreach($warehouses as $warehouse)
                                        <option value="{{ $warehouse->id }}" {{ old('warehouse_id') == $warehouse->id ? 'selected' : '' }}>
                                            {{ $warehouse->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('warehouse_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="min_quantity">الحد الأدنى <span class="text-danger">*</span></label>
                                    <input type="number" name="min_quantity" id="min_quantity" class="form-control @error('min_quantity') is-invalid @enderror" value="{{ old('min_quantity') }}" min="0" step="0.01" required>
                                    @error('min_quantity')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                    <small class="form-text text-muted">عندما تنخفض الكمية عن هذا الحد، سيتم إنشاء أمر شراء تلقائي</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="max_quantity">الحد الأقصى <span class="text-danger">*</span></label>
                                    <input type="number" name="max_quantity" id="max_quantity" class="form-control @error('max_quantity') is-invalid @enderror" value="{{ old('max_quantity') }}" min="0" step="0.01" required>
                                    @error('max_quantity')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                    <small class="form-text text-muted">الكمية المستهدفة في المخزون</small>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="form-group">
                                    <label for="order_quantity">كمية الطلب <span class="text-danger">*</span></label>
                                    <input type="number" name="order_quantity" id="order_quantity" class="form-control @error('order_quantity') is-invalid @enderror" value="{{ old('order_quantity') }}" min="0" step="0.01" required>
                                    @error('order_quantity')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                    <small class="form-text text-muted">الكمية التي سيتم طلبها في كل مرة</small>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="supplier_id">المورد المفضل</label>
                                    <select name="supplier_id" id="supplier_id" class="form-control select2 @error('supplier_id') is-invalid @enderror">
                                        <option value="">-- اختر المورد --</option>
                                        @foreach($suppliers as $supplier)
                                        <option value="{{ $supplier->id }}" {{ old('supplier_id') == $supplier->id ? 'selected' : '' }}>
                                            {{ $supplier->name }}
                                        </option>
                                        @endforeach
                                    </select>
                                    @error('supplier_id')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="is_active">الحالة</label>
                                    <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" value="1" {{ old('is_active', '1') == '1' ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">نشط</label>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea name="notes" id="notes" class="form-control @error('notes') is-invalid @enderror" rows="3">{{ old('notes') }}</textarea>
                                    @error('notes')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> حفظ
                        </button>
                        <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> إلغاء
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.select2').select2({
            dir: "rtl",
            language: "ar"
        });

        // حساب كمية الطلب تلقائيًا
        $('#min_quantity, #max_quantity').on('change', function() {
            var min = parseFloat($('#min_quantity').val()) || 0;
            var max = parseFloat($('#max_quantity').val()) || 0;
            
            if (min >= 0 && max > min) {
                var orderQty = max - min;
                $('#order_quantity').val(orderQty.toFixed(2));
            }
        });
    });
</script>
@endsection