@extends('layouts.modern')

@section('title', 'تحليلات الشراء التلقائي')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تحليلات الشراء التلقائي</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.auto-purchase.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقواعد
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-info">
                                <div class="inner">
                                    <h3>{{ $stats['total_rules'] }}</h3>
                                    <p>إجمالي القواعد</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-cogs"></i>
                                </div>
                                <a href="{{ route('inventory.auto-purchase.index') }}" class="small-box-footer">
                                    عرض القواعد <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-success">
                                <div class="inner">
                                    <h3>{{ $stats['active_rules'] }}</h3>
                                    <p>القواعد النشطة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-check-circle"></i>
                                </div>
                                <a href="#" class="small-box-footer">
                                    المزيد <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-warning">
                                <div class="inner">
                                    <h3>{{ $stats['orders_created'] }}</h3>
                                    <p>أوامر الشراء المنشأة</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-shopping-cart"></i>
                                </div>
                                <a href="{{ route('inventory.purchase-orders.index') }}" class="small-box-footer">
                                    عرض الأوامر <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                        <div class="col-lg-3 col-6">
                            <div class="small-box bg-danger">
                                <div class="inner">
                                    <h3>{{ $stats['items_below_min'] }}</h3>
                                    <p>عناصر تحت الحد الأدنى</p>
                                </div>
                                <div class="icon">
                                    <i class="fas fa-exclamation-triangle"></i>
                                </div>
                                <a href="#" class="small-box-footer" data-toggle="modal" data-target="#belowMinimumModal">
                                    عرض العناصر <i class="fas fa-arrow-circle-right"></i>
                                </a>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-line mr-1"></i>
                                        توقعات الاستهلاك
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="consumptionChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-chart-pie mr-1"></i>
                                        توزيع المخزون حسب الحالة
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="stockStatusChart" height="250"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">
                                        <i class="fas fa-lightbulb mr-1"></i>
                                        توصيات الشراء
                                    </h3>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>العنصر</th>
                                                    <th>المستودع</th>
                                                    <th>الكمية الحالية</th>
                                                    <th>الحد الأدنى</th>
                                                    <th>الكمية المقترحة للشراء</th>
                                                    <th>المورد المقترح</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @forelse($recommendations as $rec)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $rec->item->name }}</td>
                                                    <td>{{ $rec->warehouse->name }}</td>
                                                    <td>{{ $rec->current_quantity }}</td>
                                                    <td>{{ $rec->min_quantity }}</td>
                                                    <td>{{ $rec->recommended_quantity }}</td>
                                                    <td>{{ $rec->supplier ? $rec->supplier->name : 'غير محدد' }}</td>
                                                    <td>
                                                        <div class="btn-group">
                                                            @if(auth()->user()->hasPermission('apply_auto_purchase_recommendations'))
                                                            <button type="button" class="btn btn-sm btn-success apply-recommendation" data-id="{{ $rec->id }}">
                                                                <i class="fas fa-check"></i> تطبيق
                                                            </button>
                                                            @endif
                                                            @if(auth()->user()->hasPermission('create_auto_purchase_rule') && !$rec->has_rule)
                                                            <button type="button" class="btn btn-sm btn-primary create-rule" data-id="{{ $rec->id }}">
                                                                <i class="fas fa-plus"></i> إنشاء قاعدة
                                                            </button>
                                                            @endif
                                                        </div>
                                                    </td>
                                                </tr>
                                                @empty
                                                <tr>
                                                    <td colspan="8" class="text-center">لا توجد توصيات حالية</td>
                                                </tr>
                                                @endforelse
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Items Below Minimum -->
<div class="modal fade" id="belowMinimumModal" tabindex="-1" role="dialog" aria-labelledby="belowMinimumModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="belowMinimumModalLabel">العناصر تحت الحد الأدنى</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="table-responsive">
                    <table class="table table-bordered table-striped">
                        <thead>
                            <tr>
                                <th>#</th>
                                <th>العنصر</th>
                                <th>المستودع</th>
                                <th>الكمية الحالية</th>
                                <th>الحد الأدنى</th>
                                <th>النقص</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($belowMinItems as $item)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $item->item->name }}</td>
                                <td>{{ $item->warehouse->name }}</td>
                                <td>{{ $item->current_quantity }}</td>
                                <td>{{ $item->min_quantity }}</td>
                                <td class="text-danger">{{ $item->min_quantity - $item->current_quantity }}</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">لا توجد عناصر تحت الحد الأدنى</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">إغلاق</button>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Apply Recommendation -->
<div class="modal fade" id="applyRecommendationModal" tabindex="-1" role="dialog" aria-labelledby="applyRecommendationModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="applyRecommendationModalLabel">تأكيد تطبيق التوصية</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من تطبيق هذه التوصية وإنشاء أمر شراء؟
            </div>
            <div class="modal-footer">
                <form id="applyRecommendationForm" method="POST" action="">
                    @csrf
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-success">تطبيق</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- Modal for Create Rule -->
<div class="modal fade" id="createRuleModal" tabindex="-1" role="dialog" aria-labelledby="createRuleModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="createRuleModalLabel">تأكيد إنشاء قاعدة</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل تريد إنشاء قاعدة شراء تلقائي لهذا العنصر؟
            </div>
            <div class="modal-footer">
                <form id="createRuleForm" method="POST" action="">
                    @csrf
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-primary">إنشاء</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // تطبيق التوصية
        $('.apply-recommendation').on('click', function() {
            var id = $(this).data('id');
            $('#applyRecommendationForm').attr('action', "{{ route('inventory.auto-purchase.apply-recommendation', '') }}/" + id);
            $('#applyRecommendationModal').modal('show');
        });

        // إنشاء قاعدة
        $('.create-rule').on('click', function() {
            var id = $(this).data('id');
            $('#createRuleForm').attr('action', "{{ route('inventory.auto-purchase.create-recommended-rule') }}");
            $('#createRuleForm').append('<input type="hidden" name="recommendation_id" value="' + id + '">');
            $('#createRuleModal').modal('show');
        });

        // رسم البيانات
        var consumptionCtx = document.getElementById('consumptionChart').getContext('2d');
        var consumptionChart = new Chart(consumptionCtx, {
            type: 'line',
            data: {
                labels: {!! json_encode($charts['consumption']['labels']) !!},
                datasets: [{
                    label: 'معدل الاستهلاك',
                    data: {!! json_encode($charts['consumption']['data']) !!},
                    borderColor: 'rgba(60, 141, 188, 1)',
                    backgroundColor: 'rgba(60, 141, 188, 0.2)',
                    borderWidth: 2,
                    fill: true
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false,
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        });

        var stockStatusCtx = document.getElementById('stockStatusChart').getContext('2d');
        var stockStatusChart = new Chart(stockStatusCtx, {
            type: 'pie',
            data: {
                labels: ['تحت الحد الأدنى', 'ضمن النطاق', 'فوق الحد الأقصى'],
                datasets: [{
                    data: [
                        {{ $charts['stock_status']['below_min'] }},
                        {{ $charts['stock_status']['within_range'] }},
                        {{ $charts['stock_status']['above_max'] }}
                    ],
                    backgroundColor: [
                        'rgba(255, 99, 132, 0.8)',
                        'rgba(54, 162, 235, 0.8)',
                        'rgba(75, 192, 192, 0.8)'
                    ],
                    borderColor: [
                        'rgba(255, 99, 132, 1)',
                        'rgba(54, 162, 235, 1)',
                        'rgba(75, 192, 192, 1)'
                    ],
                    borderWidth: 1
                }]
            },
            options: {
                responsive: true,
                maintainAspectRatio: false
            }
        });
    });
</script>
@endsection