@extends('layouts.modern')

@section('title', 'إعدادات تنبيهات المخزون')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">إعدادات تنبيهات المخزون</h3>
                    <div class="card-tools">
                        <a href="{{ route('inventory.dashboard') }}" class="btn btn-default">
                            <i class="fas fa-arrow-right"></i> العودة إلى لوحة التحكم
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">{{ session('success') }}</div>
                    @endif
                    @if(session('error'))
                        <div class="alert alert-danger">{{ session('error') }}</div>
                    @endif

                    <form action="{{ route('inventory.alerts.update-settings') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-warning">
                                        <h5 class="card-title">تنبيهات المخزون المنخفض</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="low_stock_enabled" name="low_stock_enabled" {{ $alert->low_stock_enabled ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="low_stock_enabled">تفعيل تنبيهات المخزون المنخفض</label>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="low_stock_threshold">حد المخزون المنخفض (%)</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">%</span>
                                                </div>
                                                <input type="number" name="low_stock_threshold" id="low_stock_threshold" class="form-control @error('low_stock_threshold') is-invalid @enderror" value="{{ old('low_stock_threshold', $alert->low_stock_threshold) }}" min="1" max="100" required>
                                            </div>
                                            <small class="form-text text-muted">
                                                التنبيه عندما ينخفض المخزون عن هذه النسبة من الحد الأدنى للمخزون.
                                            </small>
                                            @error('low_stock_threshold')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> مثال: إذا كان الحد الأدنى للمخزون لعنصر ما هو 100 وحدة وتم تعيين الحد عند 20%، سيتم إطلاق تنبيه عندما ينخفض المخزون عن 20 وحدة.
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="card">
                                    <div class="card-header bg-danger">
                                        <h5 class="card-title">تنبيهات انتهاء الصلاحية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="expiry_enabled" name="expiry_enabled" {{ $alert->expiry_enabled ? 'checked' : '' }}>
                                                <label class="custom-control-label" for="expiry_enabled">تفعيل تنبيهات انتهاء الصلاحية</label>
                                            </div>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="expiry_threshold_days">مدة التنبيه قبل انتهاء الصلاحية (بالأيام)</label>
                                            <div class="input-group">
                                                <div class="input-group-prepend">
                                                    <span class="input-group-text">يوم</span>
                                                </div>
                                                <input type="number" name="expiry_threshold_days" id="expiry_threshold_days" class="form-control @error('expiry_threshold_days') is-invalid @enderror" value="{{ old('expiry_threshold_days', $alert->expiry_threshold_days) }}" min="1" max="365" required>
                                            </div>
                                            <small class="form-text text-muted">
                                                التنبيه عندما تكون العناصر على وشك انتهاء الصلاحية خلال هذه المدة.
                                            </small>
                                            @error('expiry_threshold_days')
                                                <div class="invalid-feedback">{{ $message }}</div>
                                            @enderror
                                        </div>
                                        
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> مثال: إذا تم تعيين المدة على 30 يومًا، سيتم تنبيهك بشأن جميع الدفعات التي ستنتهي صلاحيتها خلال الـ 30 يومًا القادمة.
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="card mt-4">
                            <div class="card-header bg-primary">
                                <h5 class="card-title">إعدادات الإشعارات</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group">
                                    <label>إشعارات البريد الإلكتروني</label>
                                    <select name="notification_emails[]" class="form-control select2" multiple data-placeholder="اختر عناوين البريد الإلكتروني">
                                        @foreach($alert->notification_emails ?? [] as $email)
                                            <option value="{{ $email }}" selected>{{ $email }}</option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">
                                        أدخل عناوين البريد الإلكتروني لتلقي إشعارات التنبيه. يمكنك إضافة عناوين جديدة بالكتابة والضغط على Enter.
                                    </small>
                                </div>
                                
                                <div class="form-group">
                                    <label>إشعارات المستخدمين</label>
                                    <select name="notification_users[]" class="form-control select2" multiple data-placeholder="اختر المستخدمين">
                                        @foreach($users as $user)
                                            <option value="{{ $user->id }}" {{ in_array($user->id, $alert->notification_users ?? []) ? 'selected' : '' }}>
                                                {{ $user->name }} ({{ $user->email }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">
                                        اختر المستخدمين الذين سيتلقون إشعارات داخل التطبيق.
                                    </small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4 text-center">
                            <button type="submit" class="btn btn-primary btn-lg">
                                <i class="fas fa-save ml-1"></i> حفظ الإعدادات
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>

@push('styles')
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<link href="https://cdn.jsdelivr.net/npm/select2-bootstrap4-theme@1.0.0/dist/select2-bootstrap4.min.css" rel="stylesheet" />
<style>
    /* تنسيقات إضافية للواجهة العربية */
    body {
        direction: rtl;
        text-align: right;
    }
    
    .card-tools {
        float: left;
    }
    
    .select2-container--bootstrap4 .select2-selection--multiple .select2-selection__choice {
        float: right;
    }
    
    .input-group > .input-group-prepend {
        margin-left: -1px;
        margin-right: 0;
    }
    
    .input-group > .form-control:not(:last-child) {
        border-top-left-radius: 0.25rem;
        border-bottom-left-radius: 0.25rem;
        border-top-right-radius: 0;
        border-bottom-right-radius: 0;
    }
    
    .input-group > .input-group-prepend > .input-group-text {
        border-top-right-radius: 0.25rem;
        border-bottom-right-radius: 0.25rem;
        border-top-left-radius: 0;
        border-bottom-left-radius: 0;
    }
    
    .custom-control {
        padding-right: 1.5rem;
        padding-left: 0;
    }
    
    .custom-control-label::before,
    .custom-control-label::after {
        right: -1.5rem;
        left: auto;
    }
    
    .custom-switch .custom-control-label::before {
        right: -2.25rem;
        left: auto;
    }
    
    .custom-switch .custom-control-label::after {
        right: calc(-2.25rem + 2px);
        left: auto;
    }
    
    .custom-switch .custom-control-input:checked ~ .custom-control-label::after {
        transform: translateX(-0.75rem);
    }
    
    .fa-arrow-right {
        transform: scaleX(-1);
    }
    
    .ml-1 {
        margin-right: 0.25rem !important;
        margin-left: 0 !important;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
    $(document).ready(function() {
        $('.select2').select2({
            theme: 'bootstrap4',
            tags: true,
            dir: 'rtl',
            language: {
                inputTooShort: function () {
                    return "الرجاء إدخال حرفين أو أكثر";
                },
                searching: function () {
                    return "جاري البحث...";
                },
                noResults: function () {
                    return "لم يتم العثور على نتائج";
                },
                removeAllItems: function () {
                    return "إزالة كل العناصر";
                }
            }
        });
    });
</script>
@endpush
@endsection