@extends('layouts.app')

@section('title', 'تفاصيل المهمة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تفاصيل المهمة: {{ $task->name }}</h3>
                    <div class="card-tools">
                        @if(Auth::user()->hasPermission('edit_installation_project'))
                        <a href="{{ route('installation-projects.phases.tasks.edit', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-edit ml-1"></i> تعديل المهمة
                        </a>
                        @endif
                        <a href="{{ route('installation-projects.phases.tasks.index', [$installationProject->id, $phase->id]) }}" class="btn btn-sm btn-secondary mr-2">
                            <i class="fas fa-arrow-right ml-1"></i> العودة إلى قائمة المهام
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">معلومات المهمة</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">اسم المهمة</th>
                                            <td>{{ $task->name }}</td>
                                        </tr>
                                        <tr>
                                            <th>الرقم الترتيبي</th>
                                            <td>{{ $task->order_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @switch($task->status)
                                                    @case('not_started')
                                                        <span class="badge badge-secondary">لم تبدأ</span>
                                                        @break
                                                    @case('in_progress')
                                                        <span class="badge badge-info">قيد التنفيذ</span>
                                                        @break
                                                    @case('completed')
                                                        <span class="badge badge-success">مكتملة</span>
                                                        @break
                                                    @case('delayed')
                                                        <span class="badge badge-warning">متأخرة</span>
                                                        @break
                                                    @case('cancelled')
                                                        <span class="badge badge-danger">ملغاة</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $task->status }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الأولوية</th>
                                            <td>
                                                @switch($task->priority)
                                                    @case('low')
                                                        <span class="badge badge-info">منخفضة</span>
                                                        @break
                                                    @case('medium')
                                                        <span class="badge badge-primary">متوسطة</span>
                                                        @break
                                                    @case('high')
                                                        <span class="badge badge-warning">عالية</span>
                                                        @break
                                                    @case('urgent')
                                                        <span class="badge badge-danger">عاجلة</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-secondary">{{ $task->priority }}</span>
                                                @endswitch
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نسبة الإنجاز</th>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar 
                                                        @if($task->completion_percentage < 25) bg-danger
                                                        @elseif($task->completion_percentage < 50) bg-warning
                                                        @elseif($task->completion_percentage < 75) bg-info
                                                        @else bg-success
                                                        @endif" 
                                                        role="progressbar" 
                                                        style="width: {{ $task->completion_percentage }}%" 
                                                        aria-valuenow="{{ $task->completion_percentage }}" 
                                                        aria-valuemin="0" 
                                                        aria-valuemax="100">
                                                        {{ $task->completion_percentage }}%
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">التواريخ والمسؤول</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">تاريخ البدء</th>
                                            <td>{{ $task->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $task->due_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المدة المتبقية</th>
                                            <td>
                                                @if($task->status == 'completed')
                                                    <span class="text-success">مكتملة</span>
                                                @elseif($task->status == 'cancelled')
                                                    <span class="text-danger">ملغاة</span>
                                                @else
                                                    @php
                                                        $daysLeft = now()->diffInDays($task->due_date, false);
                                                    @endphp
                                                    
                                                    @if($daysLeft < 0)
                                                        <span class="text-danger">متأخرة بـ {{ abs($daysLeft) }} يوم</span>
                                                    @elseif($daysLeft == 0)
                                                        <span class="text-warning">اليوم</span>
                                                    @else
                                                        <span class="text-info">{{ $daysLeft }} يوم</span>
                                                    @endif
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المسؤول</th>
                                            <td>{{ $task->assignedUser ? $task->assignedUser->name : 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الإنشاء</th>
                                            <td>{{ $task->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $task->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">وصف المهمة</h5>
                                </div>
                                <div class="card-body">
                                    @if($task->description)
                                        <div class="p-3 bg-white border rounded">
                                            {!! nl2br(e($task->description)) !!}
                                        </div>
                                    @else
                                        <p class="text-muted">لا يوجد وصف للمهمة</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    @if($task->notes)
                                        <div class="p-3 bg-white border rounded">
                                            {!! nl2br(e($task->notes)) !!}
                                        </div>
                                    @else
                                        <p class="text-muted">لا توجد ملاحظات</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>

                    @if($task->issues && $task->issues->count() > 0)
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header bg-light">
                                    <h5 class="mb-0">المشاكل المرتبطة</h5>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>العنوان</th>
                                                    <th>الحالة</th>
                                                    <th>الأولوية</th>
                                                    <th>تاريخ الإبلاغ</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($task->issues as $issue)
                                                <tr>
                                                    <td>{{ $issue->id }}</td>
                                                    <td>{{ $issue->title }}</td>
                                                    <td>
                                                        @switch($issue->status)
                                                            @case('open')
                                                                <span class="badge badge-danger">مفتوحة</span>
                                                                @break
                                                            @case('in_progress')
                                                                <span class="badge badge-warning">قيد المعالجة</span>
                                                                @break
                                                            @case('resolved')
                                                                <span class="badge badge-success">تم الحل</span>
                                                                @break
                                                            @case('closed')
                                                                <span class="badge badge-secondary">مغلقة</span>
                                                                @break
                                                            @default
                                                                <span class="badge badge-info">{{ $issue->status }}</span>
                                                        @endswitch
                                                    </td>
                                                    <td>
                                                        @switch($issue->priority)
                                                            @case('low')
                                                                <span class="badge badge-info">منخفضة</span>
                                                                @break
                                                            @case('medium')
                                                                <span class="badge badge-primary">متوسطة</span>
                                                                @break
                                                            @case('high')
                                                                <span class="badge badge-warning">عالية</span>
                                                                @break
                                                            @case('critical')
                                                                <span class="badge badge-danger">حرجة</span>
                                                                @break
                                                            @default
                                                                <span class="badge badge-secondary">{{ $issue->priority }}</span>
                                                        @endswitch
                                                    </td>
                                                    <td>{{ $issue->created_at->format('Y-m-d') }}</td>
                                                    <td>
                                                        <a href="{{ route('installation-projects.phases.tasks.issues.show', [$installationProject->id, $phase->id, $task->id, $issue->id]) }}" class="btn btn-sm btn-info">
                                                            <i class="fas fa-eye"></i>
                                                        </a>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    @endif

                    <div class="row mt-4">
                        <div class="col-md-12 text-center">
                            @if(Auth::user()->hasPermission('edit_installation_project'))
                            <a href="{{ route('installation-projects.phases.tasks.edit', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-primary">
                                <i class="fas fa-edit ml-1"></i> تعديل المهمة
                            </a>
                            <form action="{{ route('installation-projects.phases.tasks.destroy', [$installationProject->id, $phase->id, $task->id]) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه المهمة؟');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger">
                                    <i class="fas fa-trash ml-1"></i> حذف المهمة
                                </button>
                            </form>
                            @endif
                            <a href="{{ route('installation-projects.phases.tasks.index', [$installationProject->id, $phase->id]) }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-right ml-1"></i> العودة إلى قائمة المهام
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection