@extends('layouts.app')

@section('title', 'مهام المرحلة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مهام المرحلة: {{ $phase->name }}</h3>
                    <div class="card-tools">
                        @if(Auth::user()->hasPermission('edit_installation_project'))
                        <a href="{{ route('installation-projects.phases.tasks.create', [$installationProject->id, $phase->id]) }}" class="btn btn-sm btn-primary">
                            <i class="fas fa-plus ml-1"></i> إضافة مهمة جديدة
                        </a>
                        @endif
                        <a href="{{ route('installation-projects.phases.show', [$installationProject->id, $phase->id]) }}" class="btn btn-sm btn-secondary mr-2">
                            <i class="fas fa-arrow-right ml-1"></i> العودة إلى تفاصيل المرحلة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if($tasks->count() > 0)
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>اسم المهمة</th>
                                    <th>الحالة</th>
                                    <th>الأولوية</th>
                                    <th>تاريخ البدء</th>
                                    <th>تاريخ الانتهاء</th>
                                    <th>المسؤول</th>
                                    <th>نسبة الإنجاز</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($tasks as $task)
                                <tr>
                                    <td>{{ $task->order_number }}</td>
                                    <td>{{ $task->name }}</td>
                                    <td>
                                        @switch($task->status)
                                            @case('not_started')
                                                <span class="badge badge-secondary">لم تبدأ</span>
                                                @break
                                            @case('in_progress')
                                                <span class="badge badge-info">قيد التنفيذ</span>
                                                @break
                                            @case('completed')
                                                <span class="badge badge-success">مكتملة</span>
                                                @break
                                            @case('delayed')
                                                <span class="badge badge-warning">متأخرة</span>
                                                @break
                                            @case('cancelled')
                                                <span class="badge badge-danger">ملغاة</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ $task->status }}</span>
                                        @endswitch
                                    </td>
                                    <td>
                                        @switch($task->priority)
                                            @case('low')
                                                <span class="badge badge-info">منخفضة</span>
                                                @break
                                            @case('medium')
                                                <span class="badge badge-primary">متوسطة</span>
                                                @break
                                            @case('high')
                                                <span class="badge badge-warning">عالية</span>
                                                @break
                                            @case('urgent')
                                                <span class="badge badge-danger">عاجلة</span>
                                                @break
                                            @default
                                                <span class="badge badge-secondary">{{ $task->priority }}</span>
                                        @endswitch
                                    </td>
                                    <td>{{ $task->start_date->format('Y-m-d') }}</td>
                                    <td>{{ $task->due_date->format('Y-m-d') }}</td>
                                    <td>{{ $task->assignedUser ? $task->assignedUser->name : 'غير محدد' }}</td>
                                    <td>
                                        <div class="progress">
                                            <div class="progress-bar 
                                                @if($task->completion_percentage < 25) bg-danger
                                                @elseif($task->completion_percentage < 50) bg-warning
                                                @elseif($task->completion_percentage < 75) bg-info
                                                @else bg-success
                                                @endif" 
                                                role="progressbar" 
                                                style="width: {{ $task->completion_percentage }}%" 
                                                aria-valuenow="{{ $task->completion_percentage }}" 
                                                aria-valuemin="0" 
                                                aria-valuemax="100">
                                                {{ $task->completion_percentage }}%
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('installation-projects.phases.tasks.show', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            @if(Auth::user()->hasPermission('edit_installation_project'))
                                            <a href="{{ route('installation-projects.phases.tasks.edit', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-sm btn-primary">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <form action="{{ route('installation-projects.phases.tasks.destroy', [$installationProject->id, $phase->id, $task->id]) }}" method="POST" class="d-inline" onsubmit="return confirm('هل أنت متأكد من حذف هذه المهمة؟');">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endif
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                    @else
                    <div class="alert alert-info">
                        لا توجد مهام مضافة لهذه المرحلة بعد.
                        @if(Auth::user()->hasPermission('edit_installation_project'))
                        <a href="{{ route('installation-projects.phases.tasks.create', [$installationProject->id, $phase->id]) }}" class="alert-link">إضافة مهمة جديدة</a>
                        @endif
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection