@extends('layouts.app')

@section('title', 'إضافة مهمة جديدة')

@push('styles')
<style>
    /* إعادة ضبط كاملة للنموذج */
    * {
        box-sizing: border-box !important;
    }
    
    /* تحسينات لعرض النموذج */
    .form-group {
        margin-bottom: 1.5rem;
        width: 100%;
        position: relative;
        display: block;
    }
    
    .alert-info {
        margin-bottom: 0.5rem;
        padding: 10px;
        border-radius: 5px;
        background-color: #d1ecf1;
        border-color: #bee5eb;
        color: #0c5460;
        width: 100%;
    }
    
    /* تأكيد أن قائمة المراحل تظهر بشكل صحيح عند تفعيلها */
    #project_phase_id {
        width: 100%;
        max-width: 100%;
        display: none;
    }
    
    /* تحسين مظهر الرسائل */
    .invalid-feedback {
        display: block !important;
        font-weight: bold;
        color: #dc3545;
        margin-top: 5px;
        width: 100%;
    }
    
    /* تحسين مظهر الأزرار */
    .btn-primary, .btn-secondary {
        margin-right: 5px;
        margin-top: 10px;
    }
    
    /* تحسين مظهر الحقول */
    .form-control {
        border-radius: 4px;
        border: 1px solid #ced4da;
        padding: 8px 12px;
        width: 100% !important;
        display: block !important;
        max-width: 100% !important;
    }
    
    .form-control:focus {
        border-color: #80bdff;
        box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
    }
    
    /* إصلاح مظهر مربع النص */
    textarea.form-control {
        min-height: 120px !important;
        width: 100% !important;
        display: block !important;
        max-width: 100% !important;
        overflow: auto !important;
        resize: vertical !important;
    }
    
    /* تحسين مظهر التصنيفات */
    label {
        font-weight: bold;
        margin-bottom: 5px;
        display: block;
        width: 100%;
    }
    
    /* تحسين مظهر البطاقة */
    .card {
        box-shadow: 0 0 15px rgba(0, 0, 0, 0.1);
        border-radius: 8px;
        overflow: hidden;
        width: 100%;
        max-width: 100%;
    }
    
    .card-header {
        background-color: #f8f9fa;
        border-bottom: 1px solid #e9ecef;
        padding: 15px 20px;
        width: 100%;
    }
    
    .card-body {
        padding: 20px;
        width: 100%;
        max-width: 100%;
    }
    
    /* تحسين المسافات بين الصفوف */
    .row {
        margin-bottom: 15px;
        width: 100%;
        display: flex;
        flex-wrap: wrap;
        margin-left: -10px !important;
        margin-right: -10px !important;
    }
    
    /* إصلاح مشكلة الإزاحة */
    .content-wrapper .container-fluid {
        padding-left: 15px !important;
        padding-right: 15px !important;
        width: 100% !important;
        max-width: 100% !important;
        margin-left: auto !important;
        margin-right: auto !important;
    }
    
    /* تحسين عرض النموذج */
    form {
        width: 100%;
        max-width: 100%;
        display: block;
    }
    
    /* إصلاح مشكلة الأعمدة */
    .col-md-6 {
        width: 50%;
        padding-left: 10px !important;
        padding-right: 10px !important;
        position: relative;
    }
    
    /* إصلاح مشكلة المحتوى */
    .content {
        width: 100% !important;
        max-width: 100% !important;
        padding: 0 !important;
    }
    
    /* إصلاح مشكلة الحاوية */
    .container-fluid {
        width: 100% !important;
        max-width: 100% !important;
        padding-left: 15px !important;
        padding-right: 15px !important;
        margin-left: auto !important;
        margin-right: auto !important;
    }
</style>
@endpush

@section('content')
<div class="content-header" style="width: 100%; max-width: 100%;">
    <div class="container-fluid" style="width: 100%; max-width: 100%;">
        <div class="row mb-2" style="width: 100%; max-width: 100%; display: flex; flex-wrap: wrap;">
            <div class="col-sm-6" style="width: 50%; padding: 0 15px;">
                <h1 class="m-0">إضافة مهمة جديدة</h1>
            </div>
            <div class="col-sm-6" style="width: 50%; padding: 0 15px;">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('all-project-tasks.index') }}">جميع مهام المشاريع</a></li>
                    <li class="breadcrumb-item active">إضافة مهمة جديدة</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content" style="width: 100%; max-width: 100%; padding: 0;">
    <div class="container-fluid" style="width: 100%; max-width: 100%; padding: 0 15px;">
        <div class="row justify-content-center" style="width: 100%; max-width: 100%; display: flex; flex-wrap: wrap; margin: 0 -10px;">
            <div class="col-md-10" style="width: 83.333%; padding: 0 10px;">
                <div class="card" style="width: 100%; max-width: 100%; margin-bottom: 20px;">
                    <div class="card-header" style="width: 100%; max-width: 100%;">
                        <h3 class="card-title">إضافة مهمة جديدة</h3>
                    </div>
                    <div class="card-body" style="width: 100%; max-width: 100%; padding: 20px;">
                        <form action="{{ route('all-project-tasks.store') }}" method="POST" style="width: 100%; max-width: 100%; display: block;">
                            @csrf
                            
                            <div class="row" style="width: 100%; max-width: 100%; display: flex; flex-wrap: wrap; margin: 0 -10px 15px -10px;">
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="project_id" style="display: block; width: 100%; margin-bottom: 8px;">المشروع</label>
                                        <select name="project_id" id="project_id" class="form-control @error('project_id') is-invalid @enderror" style="width: 100% !important; display: block !important;" required>
                                            <option value="">اختر المشروع</option>
                                            @php
                                                // محاولة الحصول على المشاريع من قاعدة البيانات
                                                $projects = \App\Models\InstallationProject::where('status', '!=', 'cancelled')->get();
                                                
                                                // إذا كانت القائمة فارغة، نضيف بعض المشاريع الافتراضية للاختبار
                                                if($projects->isEmpty()) {
                                                    $projects = collect([
                                                        (object)['id' => 1, 'title' => 'مشروع تجريبي 1'],
                                                        (object)['id' => 2, 'title' => 'مشروع تجريبي 2'],
                                                        (object)['id' => 3, 'title' => 'مشروع تجريبي 3']
                                                    ]);
                                                }
                                            @endphp
                                            @foreach($projects as $project)
                                                <option value="{{ $project->id }}" {{ old('project_id') == $project->id ? 'selected' : '' }}>
                                                    {{ $project->title }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('project_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="project_phase_id" style="display: block; width: 100%; margin-bottom: 8px;">المرحلة</label>
                                        <div id="phase_selection_placeholder" class="alert alert-info" style="width: 100%; display: block; margin-bottom: 10px;">
                                            الرجاء اختيار المشروع أولاً لعرض المراحل المتاحة
                                        </div>
                                        <select name="project_phase_id" id="project_phase_id" class="form-control @error('project_phase_id') is-invalid @enderror" required style="display: none; width: 100% !important;" data-old-value="{{ old('project_phase_id') }}">
                                            <option value="">اختر المرحلة</option>
                                            @foreach($phases as $phase)
                                                <option value="{{ $phase->id }}" data-project="{{ $phase->installation_project_id }}">
                                                    {{ $phase->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                        @error('project_phase_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group">
                                <label for="title">عنوان المهمة</label>
                                <input type="text" name="title" id="title" class="form-control @error('title') is-invalid @enderror" value="{{ old('title') }}" required>
                                @error('title')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                <label for="description" style="display: block; width: 100%; margin-bottom: 8px;">وصف المهمة</label>
                                <textarea name="description" id="description" rows="5" class="form-control @error('description') is-invalid @enderror" style="width: 100% !important; min-height: 120px !important; display: block !important; max-width: 100% !important;" required>{{ old('description') }}</textarea>
                                @error('description')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="row" style="width: 100%; max-width: 100%; display: flex; flex-wrap: wrap; margin: 0 -10px 15px -10px;">
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="status" style="display: block; width: 100%; margin-bottom: 8px;">الحالة</label>
                                        <select name="status" id="status" class="form-control @error('status') is-invalid @enderror" style="width: 100% !important; display: block !important;" required>
                                            <option value="not_started" {{ old('status') == 'not_started' ? 'selected' : '' }}>لم تبدأ</option>
                                            <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                            <option value="delayed" {{ old('status') == 'delayed' ? 'selected' : '' }}>متأخرة</option>
                                            <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                        </select>
                                        @error('status')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="priority" style="display: block; width: 100%; margin-bottom: 8px;">الأولوية</label>
                                        <select name="priority" id="priority" class="form-control @error('priority') is-invalid @enderror" style="width: 100% !important; display: block !important;" required>
                                            <option value="low" {{ old('priority') == 'low' ? 'selected' : '' }}>منخفضة</option>
                                            <option value="medium" {{ old('priority') == 'medium' ? 'selected' : '' }}>متوسطة</option>
                                            <option value="high" {{ old('priority') == 'high' ? 'selected' : '' }}>عالية</option>
                                            <option value="urgent" {{ old('priority') == 'urgent' ? 'selected' : '' }}>عاجلة</option>
                                        </select>
                                        @error('priority')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row" style="width: 100%; max-width: 100%; display: flex; flex-wrap: wrap; margin: 0 -10px 15px -10px;">
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="due_date" style="display: block; width: 100%; margin-bottom: 8px;">تاريخ الاستحقاق</label>
                                        <input type="date" name="due_date" id="due_date" class="form-control @error('due_date') is-invalid @enderror" style="width: 100% !important; display: block !important;" value="{{ old('due_date') }}" required>
                                        @error('due_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6" style="width: 50%; padding: 0 10px; float: right;">
                                    <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                        <label for="estimated_hours" style="display: block; width: 100%; margin-bottom: 8px;">الساعات المقدرة</label>
                                        <input type="number" name="estimated_hours" id="estimated_hours" class="form-control @error('estimated_hours') is-invalid @enderror" style="width: 100% !important; display: block !important;" value="{{ old('estimated_hours') }}" step="0.5" min="0">
                                        @error('estimated_hours')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            
                            <div class="form-group" style="width: 100%; display: block; margin-bottom: 20px;">
                                <label for="assigned_to" style="display: block; width: 100%; margin-bottom: 8px;">تعيين إلى</label>
                                <select name="assigned_to" id="assigned_to" class="form-control @error('assigned_to') is-invalid @enderror" style="width: 100% !important; display: block !important;">
                                    <option value="">اختر المستخدم</option>
                                    @foreach(\App\Models\User::all() as $user)
                                        <option value="{{ $user->id }}" {{ old('assigned_to') == $user->id ? 'selected' : '' }}>
                                            {{ $user->name }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('assigned_to')
                                    <span class="invalid-feedback" role="alert">
                                        <strong>{{ $message }}</strong>
                                    </span>
                                @enderror
                            </div>
                            
                            <div class="form-group" style="width: 100%; display: block; margin-top: 30px;">
                                <button type="submit" class="btn btn-primary" style="margin-left: 10px;">حفظ</button>
                                <a href="{{ route('all-project-tasks.index') }}" class="btn btn-secondary">إلغاء</a>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // تحديد العناصر الرئيسية مرة واحدة
        const projectSelect = document.getElementById('project_id');
        const phaseSelect = document.getElementById('project_phase_id');
        const phasePlaceholder = document.getElementById('phase_selection_placeholder');
        
        // التحقق من وجود العناصر المطلوبة
        if (!projectSelect || !phaseSelect || !phasePlaceholder) {
            console.error('لم يتم العثور على العناصر المطلوبة');
            return;
        }
        
        // تصفية المراحل بناءً على المشروع المحدد
        function filterPhases() {
            const selectedProject = projectSelect.value;
            
            // حذف أي خيارات "لا توجد مراحل" سابقة
            const noPhaseOptions = phaseSelect.querySelectorAll('option[data-no-phases="true"]');
            noPhaseOptions.forEach(option => option.remove());
            
            // إعادة تعيين قائمة المراحل
            phaseSelect.value = '';
            
            // إخفاء جميع الخيارات أولاً (باستثناء الخيار الأول)
            const phaseOptions = Array.from(phaseSelect.options).slice(1);
            phaseOptions.forEach(option => {
                option.style.display = 'none';
            });
            
            if (selectedProject) {
                // إظهار قائمة المراحل وإخفاء الرسالة
                phaseSelect.style.display = 'block';
                phasePlaceholder.style.display = 'none';
                
                // إظهار المراحل المرتبطة بالمشروع المحدد فقط
                let hasVisibleOptions = false;
                let firstOptionForProject = null;
                
                phaseOptions.forEach(option => {
                    if (option.getAttribute('data-project') === selectedProject) {
                        option.style.display = '';
                        hasVisibleOptions = true;
                        
                        if (!firstOptionForProject) {
                            firstOptionForProject = option;
                        }
                    }
                });
                
                // إذا لم تكن هناك مراحل متاحة لهذا المشروع، أضف رسالة
                if (!hasVisibleOptions) {
                    const noPhaseOption = document.createElement('option');
                    noPhaseOption.value = '';
                    noPhaseOption.text = 'لا توجد مراحل لهذا المشروع';
                    noPhaseOption.setAttribute('data-no-phases', 'true');
                    noPhaseOption.disabled = true;
                    noPhaseOption.selected = true;
                    phaseSelect.appendChild(noPhaseOption);
                } else if (firstOptionForProject) {
                    // تحديد الخيار الأول افتراضيًا
                    firstOptionForProject.selected = true;
                }
            } else {
                // إخفاء قائمة المراحل وإظهار الرسالة إذا لم يتم تحديد مشروع
                phaseSelect.style.display = 'none';
                phasePlaceholder.style.display = 'block';
            }
        }
        
        // التعامل مع القيم المحفوظة سابقًا (في حالة فشل التحقق من صحة النموذج)
        const oldPhaseValue = phaseSelect.getAttribute('data-old-value');
        if (oldPhaseValue) {
            // البحث عن المشروع لهذه المرحلة
            const phaseOptions = Array.from(phaseSelect.options).slice(1);
            for (const option of phaseOptions) {
                if (option.value === oldPhaseValue) {
                    const projectId = option.getAttribute('data-project');
                    if (projectId) {
                        // تعيين قائمة المشاريع إلى هذه القيمة
                        projectSelect.value = projectId;
                        
                        // تأكد من أن المرحلة ستكون محددة بعد تصفية المراحل
                        setTimeout(() => {
                            phaseSelect.value = oldPhaseValue;
                        }, 0);
                    }
                    break;
                }
            }
        }
        
        // تشغيل التصفية عند تحميل الصفحة
        filterPhases();
        
        // تشغيل التصفية عند تغيير اختيار المشروع
        projectSelect.addEventListener('change', filterPhases);
    });
</script>
@endpush