@extends('layouts.app')

@section('title', 'جميع مهام المشاريع')

@section('content')
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1 class="m-0">جميع مهام المشاريع</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item active">جميع مهام المشاريع</li>
                </ol>
            </div>
        </div>
    </div>
</div>

<div class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h3 class="card-title">قائمة مهام المشاريع</h3>
                            <div>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        إضافة مهمة جديدة
                                    </button>
                                    <div class="dropdown-menu dropdown-menu-right">
                                        @foreach($projects as $project)
                                            <h6 class="dropdown-header">{{ $project->name }}</h6>
                                            @foreach($project->phases as $phase)
                                                <a class="dropdown-item" href="{{ route('installation-projects.phases.tasks.create', ['installationProject' => $project->id, 'phase' => $phase->id]) }}">
                                                    {{ $phase->name }}
                                                </a>
                                            @endforeach
                                            <div class="dropdown-divider"></div>
                                        @endforeach
                                    </div>
                                </div>
                                <a href="{{ route('all-project-tasks.create') }}" class="btn btn-success">
                                    <i class="fas fa-plus"></i> إضافة مهمة جديدة (من جميع المراحل)
                                </a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <form action="{{ route('all-project-tasks.index') }}" method="GET" class="form-inline">
                                    <div class="form-group mx-1">
                                        <label for="status" class="mx-1">الحالة:</label>
                                        <select name="status" id="status" class="form-control">
                                            <option value="all" {{ request('status') == 'all' ? 'selected' : '' }}>الكل</option>
                                            <option value="pending" {{ request('status') == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                            <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغاة</option>
                                        </select>
                                    </div>
                                    <div class="form-group mx-1">
                                        <label for="project_id" class="mx-1">المشروع:</label>
                                        <select name="project_id" id="project_id" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($projects as $project)
                                                <option value="{{ $project->id }}" {{ request('project_id') == $project->id ? 'selected' : '' }}>
                                                    {{ $project->name }}
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="form-group mx-1">
                                        <label for="phase_id" class="mx-1">المرحلة:</label>
                                        <select name="phase_id" id="phase_id" class="form-control">
                                            <option value="">الكل</option>
                                            @foreach($phases as $phase)
                                                <option value="{{ $phase->id }}" {{ request('phase_id') == $phase->id ? 'selected' : '' }}>
                                                    {{ $phase->name }} ({{ $phase->installationProject->name }})
                                                </option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-primary mx-1">تصفية</button>
                                    <a href="{{ route('all-project-tasks.index') }}" class="btn btn-secondary">إعادة تعيين</a>
                                </form>
                            </div>
                        </div>
                        
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th>#</th>
                                        <th>العنوان</th>
                                        <th>المشروع</th>
                                        <th>المرحلة</th>
                                        <th>الحالة</th>
                                        <th>الأولوية</th>
                                        <th>تاريخ الاستحقاق</th>
                                        <th>المسؤول</th>
                                        <th>التقدم</th>
                                        <th>الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($tasks as $task)
                                        <tr>
                                            <td>{{ $task->id }}</td>
                                            <td>{{ $task->name }}</td>
                                            <td>{{ $task->phase->installationProject->name }}</td>
                                            <td>{{ $task->phase->name }}</td>
                                            <td>
                                                @if($task->status == 'not_started')
                                                    <span class="badge badge-secondary">لم تبدأ</span>
                                                @elseif($task->status == 'in_progress')
                                                    <span class="badge badge-info">قيد التنفيذ</span>
                                                @elseif($task->status == 'completed')
                                                    <span class="badge badge-success">مكتملة</span>
                                                @elseif($task->status == 'delayed')
                                                    <span class="badge badge-warning">متأخرة</span>
                                                @elseif($task->status == 'cancelled')
                                                    <span class="badge badge-danger">ملغاة</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($task->priority == 'low')
                                                    <span class="badge badge-secondary">منخفضة</span>
                                                @elseif($task->priority == 'medium')
                                                    <span class="badge badge-info">متوسطة</span>
                                                @elseif($task->priority == 'high')
                                                    <span class="badge badge-warning">عالية</span>
                                                @elseif($task->priority == 'urgent')
                                                    <span class="badge badge-danger">عاجلة</span>
                                                @endif
                                            </td>
                                            <td>{{ $task->due_date->format('Y-m-d') }}</td>
                                            <td>{{ $task->assignedTo ? $task->assignedTo->name : 'غير معين' }}</td>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-striped 
                                                        @if($task->progress < 25) bg-danger
                                                        @elseif($task->progress < 50) bg-warning
                                                        @elseif($task->progress < 75) bg-info
                                                        @else bg-success @endif"
                                                        role="progressbar" style="width: {{ $task->progress }}%"
                                                        aria-valuenow="{{ $task->progress }}" aria-valuemin="0" aria-valuemax="100">
                                                        {{ $task->progress }}%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('installation-projects.phases.tasks.show', ['installationProject' => $task->phase->installation_project_id, 'phase' => $task->project_phase_id, 'task' => $task->id]) }}" class="btn btn-sm btn-info">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    <a href="{{ route('installation-projects.phases.tasks.edit', ['installationProject' => $task->phase->installation_project_id, 'phase' => $task->project_phase_id, 'task' => $task->id]) }}" class="btn btn-sm btn-primary">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-sm btn-danger" data-toggle="modal" data-target="#deleteModal{{ $task->id }}">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                                
                                                <!-- Modal for Delete Confirmation -->
                                                <div class="modal fade" id="deleteModal{{ $task->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $task->id }}" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="deleteModalLabel{{ $task->id }}">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من رغبتك في حذف المهمة "{{ $task->title }}"؟
                                                            </div>
                                                            <div class="modal-footer">
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <form action="{{ route('installation-projects.phases.tasks.destroy', ['installationProject' => $task->phase->installation_project_id, 'phase' => $task->project_phase_id, 'task' => $task->id]) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @empty
                                        <tr>
                                            <td colspan="10" class="text-center">لا توجد مهام متاحة</td>
                                        </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                        
                        <div class="mt-3">
                            {{ $tasks->appends(request()->query())->links() }}
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // Dynamic filtering for phases based on selected project
        $('#project_id').change(function() {
            var projectId = $(this).val();
            if (projectId) {
                // Filter phases dropdown to show only phases from the selected project
                $('#phase_id option').each(function() {
                    var $option = $(this);
                    if ($option.val() === '' || $option.text().includes('(' + projectId + ')')) {
                        $option.show();
                    } else {
                        $option.hide();
                    }
                });
            } else {
                // Show all phases if no project is selected
                $('#phase_id option').show();
            }
        });
    });
</script>
@endsection