@extends('layouts.modern')

@section('title', 'تفاصيل المشروع - ' . $installationProject->title)

@section('content')
<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>تفاصيل المشروع</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item active">{{ $installationProject->title }}</li>
                </ol>
            </div>
        </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <!-- الأزرار العلوية -->
                    <div class="mb-3">
                        <a href="{{ route('installation-projects.dashboard', $installationProject->id) }}" class="btn btn-primary">
                            <i class="fas fa-tachometer-alt"></i> لوحة تحكم المشروع
                        </a>
                        <a href="{{ route('installation-projects.gantt.index', $installationProject->id) }}" class="btn btn-info">
                            <i class="fas fa-chart-bar"></i> مخطط جانت
                        </a>
                        <a href="{{ route('installation-projects.risks.index', $installationProject->id) }}" class="btn btn-danger">
                            <i class="fas fa-exclamation-triangle"></i> إدارة المخاطر
                        </a>
                        <a href="{{ route('installation-projects.resources.index', $installationProject->id) }}" class="btn btn-success">
                            <i class="fas fa-boxes"></i> إدارة الموارد
                        </a>
                        <a href="{{ route('installation-projects.reports.index', $installationProject->id) }}" class="btn btn-dark">
                            <i class="fas fa-file-alt"></i> التقارير
                        </a>
                        @if(auth()->user()->hasPermission('edit_installation_project'))
                        <a href="{{ route('installation-projects.edit', $installationProject->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل المشروع
                        </a>
                        @endif
                        <a href="{{ route('installation-projects.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                    
                    <!-- بطاقة معلومات المشروع -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-project-diagram"></i>
                                معلومات المشروع
                            </h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">رقم المشروع</th>
                                            <td>{{ $installationProject->project_number }}</td>
                                        </tr>
                                        <tr>
                                            <th>عنوان المشروع</th>
                                            <td>{{ $installationProject->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>العميل</th>
                                            <td>
                                                @if($installationProject->customer)
                                                <a href="{{ route('customers.show', $installationProject->customer->id) }}">
                                                    {{ $installationProject->customer->name }}
                                                </a>
                                                @else
                                                غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الموقع</th>
                                            <td>
                                                @if($installationProject->location)
                                                {{ $installationProject->location->name }}
                                                @else
                                                غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الفرع</th>
                                            <td>
                                                @if($installationProject->branch)
                                                {{ $installationProject->branch->name }}
                                                @else
                                                غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>مدير المشروع</th>
                                            <td>
                                                @if($installationProject->projectManager)
                                                {{ $installationProject->projectManager->name }}
                                                @else
                                                غير محدد
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">تاريخ البدء</th>
                                            <td>{{ $installationProject->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء المتوقع</th>
                                            <td>{{ $installationProject->expected_completion_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء الفعلي</th>
                                            <td>
                                                @if($installationProject->actual_completion_date)
                                                {{ $installationProject->actual_completion_date->format('Y-m-d') }}
                                                @else
                                                <span class="text-muted">لم يكتمل بعد</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>الميزانية الإجمالية</th>
                                            <td>{{ number_format($installationProject->total_budget, 2) }} ريال</td>
                                        </tr>
                                        <tr>
                                            <th>التكلفة الفعلية</th>
                                            <td>{{ number_format($installationProject->total_cost, 2) }} ريال</td>
                                        </tr>
                                        <tr>
                                            <th>حالة المشروع</th>
                                            <td>
                                                @if($installationProject->status == 'not_started')
                                                <span class="badge badge-secondary">لم يبدأ</span>
                                                @elseif($installationProject->status == 'in_progress')
                                                <span class="badge badge-primary">قيد التنفيذ</span>
                                                @elseif($installationProject->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                                @elseif($installationProject->status == 'delayed')
                                                <span class="badge badge-warning">متأخر</span>
                                                @elseif($installationProject->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                            
                            <!-- وصف المشروع -->
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">وصف المشروع</h3>
                                        </div>
                                        <div class="card-body">
                                            @if($installationProject->description)
                                            {!! nl2br(e($installationProject->description)) !!}
                                            @else
                                            <p class="text-muted">لا يوجد وصف للمشروع</p>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- ملاحظات المشروع -->
                            @if($installationProject->notes)
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">ملاحظات</h3>
                                        </div>
                                        <div class="card-body">
                                            {!! nl2br(e($installationProject->notes)) !!}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                            
                            <!-- نسبة الإنجاز -->
                            <div class="row mt-3">
                                <div class="col-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">نسبة الإنجاز</h3>
                                        </div>
                                        <div class="card-body">
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped progress-bar-animated 
                                                    @if($installationProject->calculateProgress() < 30) bg-danger
                                                    @elseif($installationProject->calculateProgress() < 70) bg-warning
                                                    @else bg-success @endif" 
                                                    role="progressbar" 
                                                    style="width: {{ $installationProject->calculateProgress() }}%" 
                                                    aria-valuenow="{{ $installationProject->calculateProgress() }}" 
                                                    aria-valuemin="0" 
                                                    aria-valuemax="100">
                                                    {{ $installationProject->calculateProgress() }}%
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <!-- مصاعد المشروع -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-elevator"></i>
                                مصاعد المشروع
                            </h3>
                            <div class="card-tools">
                                @if(auth()->user()->hasPermission('add_project_elevator'))
                                <a href="{{ route('installation-projects.elevators.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة مصعد
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            @if($installationProject->elevators->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم المصعد</th>
                                            <th>النوع</th>
                                            <th>الطراز</th>
                                            <th>السعة</th>
                                            <th>عدد المحطات</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($installationProject->elevators as $elevator)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $elevator->elevator_number }}</td>
                                            <td>{{ $elevator->type }}</td>
                                            <td>{{ $elevator->model }}</td>
                                            <td>{{ $elevator->capacity }} كجم</td>
                                            <td>{{ $elevator->number_of_stops }}</td>
                                            <td>
                                                @if($elevator->status == 'pending')
                                                <span class="badge badge-secondary">قيد الانتظار</span>
                                                @elseif($elevator->status == 'in_progress')
                                                <span class="badge badge-primary">قيد التركيب</span>
                                                @elseif($elevator->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                                @elseif($elevator->status == 'testing')
                                                <span class="badge badge-info">قيد الاختبار</span>
                                                @elseif($elevator->status == 'delivered')
                                                <span class="badge badge-success">تم التسليم</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('installation-projects.elevators.show', [$installationProject->id, $elevator->id]) }}" class="btn btn-info btn-sm">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    @if(auth()->user()->hasPermission('edit_project_elevator'))
                                                    <a href="{{ route('installation-projects.elevators.edit', [$installationProject->id, $elevator->id]) }}" class="btn btn-warning btn-sm">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @endif
                                                    @if(auth()->user()->hasPermission('delete_project_elevator'))
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-elevator-{{ $elevator->id }}">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endif
                                                </div>
                                                
                                                <!-- Modal Delete -->
                                                <div class="modal fade" id="delete-elevator-{{ $elevator->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-elevator-{{ $elevator->id }}-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-elevator-{{ $elevator->id }}-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف المصعد رقم <strong>{{ $elevator->elevator_number }}</strong>؟
                                                            </div>
                                                            <div class="modal-footer">
                                                                <form action="{{ route('installation-projects.elevators.destroy', [$installationProject->id, $elevator->id]) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="alert alert-info">
                                لا توجد مصاعد مضافة للمشروع حتى الآن.
                                @if(auth()->user()->hasPermission('add_project_elevator'))
                                <a href="{{ route('installation-projects.elevators.create', $installationProject->id) }}" class="alert-link">إضافة مصعد جديد</a>
                                @endif
                            </div>
                            @endif
                        </div>
                    </div>
                    
                    <!-- مراحل المشروع -->
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-tasks"></i>
                                مراحل المشروع
                            </h3>
                            <div class="card-tools">
                                @if(auth()->user()->hasPermission('add_project_phase'))
                                <a href="{{ route('installation-projects.phases.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة مرحلة
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            @if($installationProject->phases->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped project-phases-table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>اسم المرحلة</th>
                                            <th>تاريخ البدء</th>
                                            <th>تاريخ الانتهاء</th>
                                            <th>المسؤول</th>
                                            <th>الحالة</th>
                                            <th>نسبة الإنجاز</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($installationProject->phases->sortBy('order_number') as $phase)
                                        <tr>
                                            <td>{{ $phase->order_number }}</td>
                                            <td>{{ $phase->name }}</td>
                                            <td>{{ $phase->start_date->format('Y-m-d') }}</td>
                                            <td>{{ $phase->end_date->format('Y-m-d') }}</td>
                                            <td>
                                                @if($phase->responsibleUser)
                                                {{ $phase->responsibleUser->name }}
                                                @else
                                                <span class="text-muted">غير محدد</span>
                                                @endif
                                            </td>
                                            <td>
                                                @if($phase->status == 'not_started')
                                                <span class="badge badge-secondary">لم تبدأ</span>
                                                @elseif($phase->status == 'in_progress')
                                                <span class="badge badge-primary">قيد التنفيذ</span>
                                                @elseif($phase->status == 'completed')
                                                <span class="badge badge-success">مكتملة</span>
                                                @elseif($phase->status == 'delayed')
                                                <span class="badge badge-warning">متأخرة</span>
                                                @elseif($phase->status == 'cancelled')
                                                <span class="badge badge-danger">ملغية</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar 
                                                        @if($phase->completion_percentage < 30) bg-danger
                                                        @elseif($phase->completion_percentage < 70) bg-warning
                                                        @else bg-success @endif" 
                                                        role="progressbar" 
                                                        style="width: {{ $phase->completion_percentage }}%" 
                                                        aria-valuenow="{{ $phase->completion_percentage }}" 
                                                        aria-valuemin="0" 
                                                        aria-valuemax="100">
                                                        {{ $phase->completion_percentage }}%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group action-buttons">
                                                    <a href="{{ route('installation-projects.phases.show', [$installationProject->id, $phase->id]) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    @if(auth()->user()->hasPermission('edit_project_phase'))
                                                    <a href="{{ route('installation-projects.phases.edit', [$installationProject->id, $phase->id]) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @endif
                                                    @if(auth()->user()->hasPermission('delete_project_phase'))
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-phase-{{ $phase->id }}" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endif
                                                </div>
                                                
                                                <!-- Modal Delete -->
                                                <div class="modal fade" id="delete-phase-{{ $phase->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-phase-{{ $phase->id }}-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-phase-{{ $phase->id }}-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف المرحلة <strong>{{ $phase->name }}</strong>؟
                                                                <br>
                                                                <div class="alert alert-warning mt-2">
                                                                    <i class="fas fa-exclamation-triangle"></i>
                                                                    تحذير: سيتم حذف جميع المهام المرتبطة بهذه المرحلة.
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <form action="{{ route('installation-projects.phases.destroy', [$installationProject->id, $phase->id]) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            @else
                            <div class="alert alert-info">
                                لا توجد مراحل مضافة للمشروع حتى الآن.
                                @if(auth()->user()->hasPermission('add_project_phase'))
                                <a href="{{ route('installation-projects.phases.create', $installationProject->id) }}" class="alert-link">إضافة مرحلة جديدة</a>
                                @endif
                            </div>
                            @endif
                        </div>
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
</section>
@endsection

@push('styles')
<style>
    .table th, .table td {
        vertical-align: middle !important;
        white-space: normal !important; /* إلغاء خاصية nowrap */
        word-wrap: break-word !important; /* السماح بالتفاف النص */
        max-width: 200px !important; /* تحديد عرض أقصى للخلايا */
        font-size: 0.9rem !important; /* تقليل حجم الخط قليلاً */
        overflow: visible !important; /* السماح بظهور النص الزائد */
        text-overflow: clip !important; /* عدم قطع النص الزائد */
        hyphens: auto !important; /* السماح بتقسيم الكلمات الطويلة */
    }
    
    /* تحسين عرض الجداول بشكل عام */
    .table {
        table-layout: fixed !important; /* تثبيت تخطيط الجدول */
        width: 100% !important;
        max-width: 100% !important;
        margin-bottom: 1rem !important;
        border-collapse: collapse !important;
    }
    
    /* تنسيق جدول معلومات المشروع */
    .project-info-table {
        table-layout: fixed !important;
        width: 100% !important;
    }
    
    .project-info-table th {
        width: 30% !important;
        background-color: #f8f9fa !important;
        font-weight: 600 !important;
        vertical-align: middle !important;
        white-space: normal !important;
        word-wrap: break-word !important;
        font-size: 0.9rem !important;
    }
    
    .project-info-table td {
        width: 70% !important;
        vertical-align: middle !important;
        white-space: normal !important;
        word-wrap: break-word !important;
        font-size: 0.9rem !important;
        padding: 8px 10px !important;
    }
    
    /* تحديد عرض لكل عمود في جدول مراحل المشروع */
    .project-phases-table th:nth-child(1), .project-phases-table td:nth-child(1) { width: 5%; } /* # */
    .project-phases-table th:nth-child(2), .project-phases-table td:nth-child(2) { width: 20%; } /* اسم المرحلة */
    .project-phases-table th:nth-child(3), .project-phases-table td:nth-child(3) { width: 10%; } /* تاريخ البدء */
    .project-phases-table th:nth-child(4), .project-phases-table td:nth-child(4) { width: 10%; } /* تاريخ الانتهاء */
    .project-phases-table th:nth-child(5), .project-phases-table td:nth-child(5) { width: 15%; } /* المسؤول */
    .project-phases-table th:nth-child(6), .project-phases-table td:nth-child(6) { width: 10%; } /* الحالة */
    .project-phases-table th:nth-child(7), .project-phases-table td:nth-child(7) { width: 10%; } /* نسبة الإنجاز */
    .project-phases-table th:nth-child(8), .project-phases-table td:nth-child(8) { width: 20%; } /* الإجراءات */
    
    /* تحسين عرض الجدول */
    .table-responsive {
        overflow-x: auto;
        min-height: 0.01%; /* لإصلاح مشكلة في بعض المتصفحات */
        width: 100%;
    }
    
    /* تحسين عرض الأزرار في الجدول */
    .action-buttons {
        display: flex !important;
        flex-wrap: wrap !important;
        gap: 3px !important;
        justify-content: center !important;
    }
    
    .action-buttons .btn-sm {
        padding: 0.25rem 0.5rem !important;
        font-size: 0.75rem !important;
        margin: 2px !important;
        min-width: 30px !important;
    }
    
    /* تحسين عرض الأيقونات داخل الأزرار */
    .action-buttons .btn-sm i {
        margin: 0 !important;
    }
    
    /* تحسين عرض شريط التقدم */
    .progress {
        height: 20px !important;
        margin-bottom: 0 !important;
        background-color: #f5f5f5 !important;
        border-radius: 4px !important;
        overflow: hidden !important;
    }
    
    .progress-bar {
        line-height: 20px !important;
        font-size: 12px !important;
        font-weight: bold !important;
        text-align: center !important;
    }
    
    /* تحسين عرض بطاقة معلومات المشروع */
    .card-title {
        font-weight: bold !important;
    }
    
    /* تحسين عرض الصفوف في جدول معلومات المشروع */
    .project-info-table tr {
        border-bottom: 1px solid #f0f0f0 !important;
    }
    
    /* تحسين عرض الروابط في جدول معلومات المشروع */
    .project-info-table a {
        color: #3498db !important;
        text-decoration: none !important;
    }
    
    .project-info-table a:hover {
        text-decoration: underline !important;
    }
    
    /* إصلاح مشكلة الإزاحة والمساحة الفارغة */
    .content-wrapper {
        margin-right: 220px !important;
        margin-left: 0 !important;
        width: calc(100% - 220px) !important;
        overflow-x: hidden !important;
    }
    
    .container-fluid {
        width: 100% !important;
        max-width: 100% !important;
        padding-left: 15px !important;
        padding-right: 15px !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    .row {
        width: 100% !important;
        margin-left: 0 !important;
        margin-right: 0 !important;
    }
    
    .card {
        width: 100% !important;
    }
    
    @media (max-width: 992px) {
        .content-wrapper {
            margin-right: 0 !important;
            width: 100% !important;
        }
        
        /* تعديل عرض الجدول للشاشات الصغيرة */
        .table-responsive {
            border: 0;
            overflow-x: auto;
        }
        
        .table {
            min-width: 800px; /* تحديد عرض أدنى للجدول على الشاشات الصغيرة */
        }
    }
</style>
@endpush

@push('scripts')
<script>
    $(function () {
        // تفعيل التوست للرسائل
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        
        // عرض رسائل النجاح
        @if(session('success'))
        Toast.fire({
            icon: 'success',
            title: '{{ session("success") }}'
        });
        @endif
        
        // عرض رسائل الخطأ
        @if(session('error'))
        Toast.fire({
            icon: 'error',
            title: '{{ session("error") }}'
        });
        @endif
        
        // تحسين عرض الجداول
        $('.table').each(function() {
            // التأكد من أن عرض الجدول لا يتجاوز عرض الحاوية
            $(this).css('width', '100%');
            
            // تحسين عرض الخلايا
            $(this).find('td, th').css({
                'white-space': 'normal',
                'word-wrap': 'break-word'
            });
        });
        
        // إضافة فئة لجداول معلومات المشروع
        $('.card-title:contains("معلومات المشروع")').closest('.card').find('.table').addClass('project-info-table');
        
        // تطبيق تنسيقات إضافية على جدول معلومات المشروع
        $('.project-info-table').each(function() {
            // تعيين عرض ثابت للجدول
            $(this).css({
                'table-layout': 'fixed',
                'width': '100%'
            });
            
            // تعيين عرض ثابت للأعمدة
            $(this).find('th').css({
                'width': '30%',
                'white-space': 'normal',
                'word-wrap': 'break-word',
                'overflow': 'visible'
            });
            
            $(this).find('td').css({
                'width': '70%',
                'white-space': 'normal',
                'word-wrap': 'break-word',
                'overflow': 'visible'
            });
        });
        
        // تفعيل tooltips للأزرار
        $('[title]').tooltip();
        
        // إصلاح مشكلة تراكب النصوص في جدول معلومات المشروع
        setTimeout(function() {
            // تطبيق تنسيقات إضافية بعد تحميل الصفحة بالكامل
            $('.table th[style*="width: 30%"]').closest('table').addClass('project-info-table');
            
            // تطبيق تنسيقات على جميع الجداول
            $('.table').css('table-layout', 'fixed');
            
            // تطبيق تنسيقات على جميع الخلايا
            $('.table td, .table th').css({
                'white-space': 'normal',
                'word-wrap': 'break-word',
                'overflow': 'visible'
            });
        }, 100);
    });
</script>
@endpush