@extends('layouts.modern')

@section('title', 'إدارة مخاطر المشروع')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مخاطر المشروع: {{ $installationProject->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('installation-projects.risks.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة مخاطرة جديدة
                        </a>
                        <a href="{{ route('installation-projects.risks.dashboard', $installationProject->id) }}" class="btn btn-info btn-sm mr-2">
                            <i class="fas fa-chart-pie"></i> لوحة تحكم المخاطر
                        </a>
                        <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-arrow-right"></i> العودة للمشروع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- ملخص المخاطر -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-exclamation-triangle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مخاطر حرجة</span>
                                    <span class="info-box-number">{{ $risksByLevel['critical'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-exclamation-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مخاطر عالية</span>
                                    <span class="info-box-number">{{ $risksByLevel['high'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-info-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مخاطر متوسطة</span>
                                    <span class="info-box-number">{{ $risksByLevel['medium'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مخاطر منخفضة</span>
                                    <span class="info-box-number">{{ $risksByLevel['low'] ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول المخاطر -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped datatable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>المرحلة</th>
                                    <th>الاحتمالية</th>
                                    <th>التأثير</th>
                                    <th>درجة المخاطرة</th>
                                    <th>الحالة</th>
                                    <th>المسؤول</th>
                                    <th>تاريخ التعريف</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($risks as $risk)
                                <tr class="{{ $risk->getRiskLevel() == 'critical' ? 'table-danger' : ($risk->getRiskLevel() == 'high' ? 'table-warning' : '') }}">
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $risk->title }}</td>
                                    <td>{{ $risk->phase ? $risk->phase->name : 'غير محدد' }}</td>
                                    <td>
                                        @switch($risk->probability)
                                            @case('low')
                                                <span class="badge badge-success">منخفضة</span>
                                                @break
                                            @case('medium')
                                                <span class="badge badge-info">متوسطة</span>
                                                @break
                                            @case('high')
                                                <span class="badge badge-warning">عالية</span>
                                                @break
                                            @case('very_high')
                                                <span class="badge badge-danger">عالية جداً</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>
                                        @switch($risk->impact)
                                            @case('low')
                                                <span class="badge badge-success">منخفض</span>
                                                @break
                                            @case('medium')
                                                <span class="badge badge-info">متوسط</span>
                                                @break
                                            @case('high')
                                                <span class="badge badge-warning">عالي</span>
                                                @break
                                            @case('very_high')
                                                <span class="badge badge-danger">عالي جداً</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>
                                        <div class="progress">
                                            @php
                                                $riskLevel = $risk->getRiskLevel();
                                                $progressClass = 'bg-success';
                                                $percentage = 25;
                                                
                                                if ($riskLevel == 'medium') {
                                                    $progressClass = 'bg-info';
                                                    $percentage = 50;
                                                } elseif ($riskLevel == 'high') {
                                                    $progressClass = 'bg-warning';
                                                    $percentage = 75;
                                                } elseif ($riskLevel == 'critical') {
                                                    $progressClass = 'bg-danger';
                                                    $percentage = 100;
                                                }
                                            @endphp
                                            <div class="progress-bar {{ $progressClass }}" role="progressbar" style="width: {{ $percentage }}%" aria-valuenow="{{ $percentage }}" aria-valuemin="0" aria-valuemax="100">{{ $risk->risk_score }}</div>
                                        </div>
                                    </td>
                                    <td>
                                        @switch($risk->status)
                                            @case('identified')
                                                <span class="badge badge-secondary">تم التعريف</span>
                                                @break
                                            @case('analyzing')
                                                <span class="badge badge-info">قيد التحليل</span>
                                                @break
                                            @case('mitigating')
                                                <span class="badge badge-primary">قيد المعالجة</span>
                                                @break
                                            @case('monitoring')
                                                <span class="badge badge-warning">قيد المراقبة</span>
                                                @break
                                            @case('closed')
                                                <span class="badge badge-success">مغلقة</span>
                                                @break
                                            @case('occurred')
                                                <span class="badge badge-danger">حدثت</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $risk->responsibleUser ? $risk->responsibleUser->name : 'غير محدد' }}</td>
                                    <td>{{ $risk->identification_date->format('Y-m-d') }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('installation-projects.risks.show', [$installationProject->id, $risk->id]) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('installation-projects.risks.edit', [$installationProject->id, $risk->id]) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $risk->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                        
                                        <!-- Modal for Delete Confirmation -->
                                        <div class="modal fade" id="deleteModal{{ $risk->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $risk->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $risk->id }}">تأكيد الحذف</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من حذف المخاطرة: {{ $risk->title }}؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('installation-projects.risks.destroy', [$installationProject->id, $risk->id]) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.datatable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
            },
            "order": [[ 5, "desc" ]]
        });
    });
</script>
@endsection