@extends('layouts.modern')

@section('title', 'لوحة تحكم المخاطر')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">لوحة تحكم المخاطر: {{ $installationProject->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('installation-projects.risks.index', $installationProject->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-list"></i> قائمة المخاطر
                        </a>
                        <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-arrow-right"></i> العودة للمشروع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- ملخص المخاطر -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-exclamation-triangle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">إجمالي المخاطر</span>
                                    <span class="info-box-number">{{ $risks->count() }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">متوسط درجة المخاطرة</span>
                                    <span class="info-box-number">{{ number_format($averageRiskScore, 1) }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-check-circle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المخاطر المغلقة</span>
                                    <span class="info-box-number">{{ $closedRisks->count() }} ({{ number_format($closedRisksPercentage, 1) }}%)</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-fire"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">مخاطر عالية الأولوية</span>
                                    <span class="info-box-number">{{ $highPriorityRisks->count() }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- توزيع المخاطر حسب الفئة -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">توزيع المخاطر حسب الفئة</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="riskCategoryChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>

                        <!-- توزيع المخاطر حسب الحالة -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">توزيع المخاطر حسب الحالة</h3>
                                </div>
                                <div class="card-body">
                                    <canvas id="riskStatusChart" height="300"></canvas>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <!-- مصفوفة المخاطر -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">مصفوفة المخاطر (الاحتمالية × الشدة)</h3>
                                </div>
                                <div class="card-body">
                                    <div class="risk-matrix">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th class="text-center" style="width: 16%">الاحتمالية / الشدة</th>
                                                    <th class="text-center" style="width: 16%">1</th>
                                                    <th class="text-center" style="width: 16%">2</th>
                                                    <th class="text-center" style="width: 16%">3</th>
                                                    <th class="text-center" style="width: 16%">4</th>
                                                    <th class="text-center" style="width: 16%">5</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @for ($p = 5; $p >= 1; $p--)
                                                <tr>
                                                    <td class="text-center font-weight-bold">{{ $p }}</td>
                                                    @for ($s = 1; $s <= 5; $s++)
                                                        @php
                                                            $score = $p * $s;
                                                            $bgClass = 'bg-success';
                                                            if ($score >= 15) {
                                                                $bgClass = 'bg-danger';
                                                            } elseif ($score >= 8) {
                                                                $bgClass = 'bg-warning';
                                                            }
                                                            $cellRisks = $risks->where('probability', $p)->where('severity', $s);
                                                        @endphp
                                                        <td class="text-center {{ $bgClass }}">
                                                            {{ $score }}
                                                            @if($cellRisks->count() > 0)
                                                                <span class="badge badge-light">{{ $cellRisks->count() }}</span>
                                                            @endif
                                                        </td>
                                                    @endfor
                                                </tr>
                                                @endfor
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- المخاطر ذات الأولوية العالية -->
                        <div class="col-md-6">
                            <div class="card">
                                <div class="card-header">
                                    <h3 class="card-title">المخاطر ذات الأولوية العالية</h3>
                                </div>
                                <div class="card-body">
                                    @if($highPriorityRisks->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th>العنوان</th>
                                                        <th>الفئة</th>
                                                        <th>درجة المخاطرة</th>
                                                        <th>الحالة</th>
                                                        <th>المسؤول</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($highPriorityRisks as $risk)
                                                    <tr>
                                                        <td>
                                                            <a href="{{ route('installation-projects.risks.show', [$installationProject->id, $risk->id]) }}">
                                                                {{ $risk->title }}
                                                            </a>
                                                        </td>
                                                        <td>{{ $risk->category_name }}</td>
                                                        <td>
                                                            <span class="badge badge-danger">
                                                                {{ $risk->risk_score }}
                                                            </span>
                                                        </td>
                                                        <td>
                                                            <span class="badge badge-{{ $risk->status_color }}">
                                                                {{ $risk->status_name }}
                                                            </span>
                                                        </td>
                                                        <td>{{ $risk->responsibleUser ? $risk->responsibleUser->name : '-' }}</td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                    @else
                                        <div class="alert alert-info">
                                            لا توجد مخاطر ذات أولوية عالية حالياً.
                                        </div>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    $(document).ready(function() {
        // بيانات توزيع المخاطر حسب الفئة
        var categoryData = {
            labels: [
                @foreach($risksByCategory as $category => $risks)
                    '{{ $risks->first()->category_name }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($risksByCategory as $category => $risks)
                        {{ $risks->count() }},
                    @endforeach
                ],
                backgroundColor: [
                    '#3c8dbc',
                    '#f39c12',
                    '#00a65a',
                    '#f56954',
                    '#00c0ef',
                    '#d2d6de',
                    '#605ca8'
                ]
            }]
        };

        // بيانات توزيع المخاطر حسب الحالة
        var statusData = {
            labels: [
                @foreach($risksByStatus as $status => $risks)
                    '{{ $risks->first()->status_name }}',
                @endforeach
            ],
            datasets: [{
                data: [
                    @foreach($risksByStatus as $status => $risks)
                        {{ $risks->count() }},
                    @endforeach
                ],
                backgroundColor: [
                    '#3c8dbc',
                    '#f39c12',
                    '#00a65a',
                    '#f56954',
                    '#00c0ef',
                    '#d2d6de'
                ]
            }]
        };

        // إنشاء مخطط توزيع المخاطر حسب الفئة
        var categoryChart = new Chart(document.getElementById('riskCategoryChart'), {
            type: 'pie',
            data: categoryData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });

        // إنشاء مخطط توزيع المخاطر حسب الحالة
        var statusChart = new Chart(document.getElementById('riskStatusChart'), {
            type: 'pie',
            data: statusData,
            options: {
                responsive: true,
                maintainAspectRatio: false,
                plugins: {
                    legend: {
                        position: 'right',
                    }
                }
            }
        });
    });
</script>
@endsection

@section('styles')
<style>
    .risk-matrix td {
        height: 60px;
        vertical-align: middle;
    }
    .risk-matrix .bg-danger {
        background-color: rgba(220, 53, 69, 0.7) !important;
    }
    .risk-matrix .bg-warning {
        background-color: rgba(255, 193, 7, 0.7) !important;
    }
    .risk-matrix .bg-success {
        background-color: rgba(40, 167, 69, 0.7) !important;
    }
</style>
@endsection