@extends('layouts.modern')

@section('title', 'إدارة موارد المشروع')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">موارد المشروع: {{ $installationProject->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('installation-projects.resources.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إضافة مورد جديد
                        </a>
                        <a href="{{ route('installation-projects.resources.report', $installationProject->id) }}" class="btn btn-info btn-sm mr-2">
                            <i class="fas fa-chart-bar"></i> تقرير استخدام الموارد
                        </a>
                        <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-arrow-right"></i> العودة للمشروع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- ملخص الموارد -->
                    <div class="row mb-4">
                        <div class="col-md-3">
                            <div class="info-box bg-primary">
                                <span class="info-box-icon"><i class="fas fa-users"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">الموارد البشرية</span>
                                    <span class="info-box-number">{{ $resourcesByType['human']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المواد</span>
                                    <span class="info-box-number">{{ $resourcesByType['material']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-tools"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">المعدات</span>
                                    <span class="info-box-number">{{ $resourcesByType['equipment']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-3">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-cubes"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">أخرى</span>
                                    <span class="info-box-number">{{ $resourcesByType['other']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول الموارد -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped datatable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>النوع</th>
                                    <th>الوحدة</th>
                                    <th>التكلفة لكل وحدة</th>
                                    <th>الوحدات المتاحة</th>
                                    <th>الوحدات المخصصة</th>
                                    <th>نسبة الاستخدام</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($resources as $resource)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $resource->name }}</td>
                                    <td>
                                        @switch($resource->type)
                                            @case('human')
                                                <span class="badge badge-primary">موارد بشرية</span>
                                                @break
                                            @case('material')
                                                <span class="badge badge-success">مواد</span>
                                                @break
                                            @case('equipment')
                                                <span class="badge badge-warning">معدات</span>
                                                @break
                                            @case('other')
                                                <span class="badge badge-info">أخرى</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $resource->unit }}</td>
                                    <td>{{ number_format($resource->cost_per_unit, 2) }}</td>
                                    <td>{{ $resource->available_units }}</td>
                                    <td>{{ $resource->allocated_units }}</td>
                                    <td>
                                        @php
                                            $utilizationPercentage = $resource->available_units > 0 ? round(($resource->allocated_units / $resource->available_units) * 100, 2) : 0;
                                            $progressClass = 'bg-success';
                                            
                                            if ($utilizationPercentage > 70 && $utilizationPercentage <= 90) {
                                                $progressClass = 'bg-warning';
                                            } elseif ($utilizationPercentage > 90) {
                                                $progressClass = 'bg-danger';
                                            }
                                        @endphp
                                        <div class="progress">
                                            <div class="progress-bar {{ $progressClass }}" role="progressbar" style="width: {{ $utilizationPercentage }}%" aria-valuenow="{{ $utilizationPercentage }}" aria-valuemin="0" aria-valuemax="100">{{ $utilizationPercentage }}%</div>
                                        </div>
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('installation-projects.resources.show', [$installationProject->id, $resource->id]) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('installation-projects.resources.edit', [$installationProject->id, $resource->id]) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            <a href="{{ route('installation-projects.resources.allocate-form', [$installationProject->id, $resource->id]) }}" class="btn btn-success btn-sm">
                                                <i class="fas fa-tasks"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $resource->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                        
                                        <!-- Modal for Delete Confirmation -->
                                        <div class="modal fade" id="deleteModal{{ $resource->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $resource->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $resource->id }}">تأكيد الحذف</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من حذف المورد: {{ $resource->name }}؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('installation-projects.resources.destroy', [$installationProject->id, $resource->id]) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.datatable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
            }
        });
    });
</script>
@endsection