@extends('layouts.modern')

@section('title', 'تقارير المشروع')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تقارير المشروع: {{ $installationProject->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('installation-projects.reports.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> إنشاء تقرير جديد
                        </a>
                        <a href="{{ route('installation-projects.reports.dashboard', $installationProject->id) }}" class="btn btn-info btn-sm mr-2">
                            <i class="fas fa-chart-line"></i> لوحة تحكم التقارير
                        </a>
                        <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-arrow-right"></i> العودة للمشروع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- ملخص التقارير -->
                    <div class="row mb-4">
                        <div class="col-md-2">
                            <div class="info-box bg-primary">
                                <span class="info-box-icon"><i class="fas fa-tasks"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير التقدم</span>
                                    <span class="info-box-number">{{ $reportsByType['progress']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="info-box bg-success">
                                <span class="info-box-icon"><i class="fas fa-money-bill"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير مالية</span>
                                    <span class="info-box-number">{{ $reportsByType['financial']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="info-box bg-warning">
                                <span class="info-box-icon"><i class="fas fa-boxes"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير الموارد</span>
                                    <span class="info-box-number">{{ $reportsByType['resource']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="info-box bg-info">
                                <span class="info-box-icon"><i class="fas fa-chart-line"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">القيمة المكتسبة</span>
                                    <span class="info-box-number">{{ $reportsByType['earned_value']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="info-box bg-danger">
                                <span class="info-box-icon"><i class="fas fa-exclamation-triangle"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير المخاطر</span>
                                    <span class="info-box-number">{{ $reportsByType['risk']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="info-box bg-secondary">
                                <span class="info-box-icon"><i class="fas fa-random"></i></span>
                                <div class="info-box-content">
                                    <span class="info-box-text">تقارير المقارنة</span>
                                    <span class="info-box-number">{{ $reportsByType['comparison']->count() ?? 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- جدول التقارير -->
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped datatable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>نوع التقرير</th>
                                    <th>تاريخ التقرير</th>
                                    <th>الفترة</th>
                                    <th>تم الإنشاء بواسطة</th>
                                    <th>تاريخ الإنشاء</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($reports as $report)
                                <tr>
                                    <td>{{ $loop->iteration }}</td>
                                    <td>{{ $report->title }}</td>
                                    <td>
                                        @switch($report->report_type)
                                            @case('progress')
                                                <span class="badge badge-primary">تقرير تقدم</span>
                                                @break
                                            @case('financial')
                                                <span class="badge badge-success">تقرير مالي</span>
                                                @break
                                            @case('resource')
                                                <span class="badge badge-warning">تقرير موارد</span>
                                                @break
                                            @case('earned_value')
                                                <span class="badge badge-info">تقرير القيمة المكتسبة</span>
                                                @break
                                            @case('risk')
                                                <span class="badge badge-danger">تقرير مخاطر</span>
                                                @break
                                            @case('comparison')
                                                <span class="badge badge-secondary">تقرير مقارنة</span>
                                                @break
                                            @case('custom')
                                                <span class="badge badge-dark">تقرير مخصص</span>
                                                @break
                                        @endswitch
                                    </td>
                                    <td>{{ $report->report_date->format('Y-m-d') }}</td>
                                    <td>
                                        @if($report->period_start && $report->period_end)
                                            {{ $report->period_start->format('Y-m-d') }} إلى {{ $report->period_end->format('Y-m-d') }}
                                        @else
                                            -
                                        @endif
                                    </td>
                                    <td>{{ $report->creator->name }}</td>
                                    <td>{{ $report->created_at->format('Y-m-d H:i') }}</td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('installation-projects.reports.show', [$installationProject->id, $report->id]) }}" class="btn btn-info btn-sm">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            <a href="{{ route('installation-projects.reports.download', [$installationProject->id, $report->id]) }}" class="btn btn-success btn-sm">
                                                <i class="fas fa-download"></i>
                                            </a>
                                            <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $report->id }}">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </div>
                                        
                                        <!-- Modal for Delete Confirmation -->
                                        <div class="modal fade" id="deleteModal{{ $report->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $report->id }}" aria-hidden="true">
                                            <div class="modal-dialog" role="document">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <h5 class="modal-title" id="deleteModalLabel{{ $report->id }}">تأكيد الحذف</h5>
                                                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                            <span aria-hidden="true">&times;</span>
                                                        </button>
                                                    </div>
                                                    <div class="modal-body">
                                                        هل أنت متأكد من حذف التقرير: {{ $report->title }}؟
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                        <form action="{{ route('installation-projects.reports.destroy', [$installationProject->id, $report->id]) }}" method="POST">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="submit" class="btn btn-danger">حذف</button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </td>
                                </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        $('.datatable').DataTable({
            "language": {
                "url": "//cdn.datatables.net/plug-ins/1.10.24/i18n/Arabic.json"
            },
            "order": [[ 3, "desc" ]]
        });
    });
</script>
@endsection