@extends('layouts.modern')

@section('title', 'تفاصيل المرحلة - ' . $phase->name)

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>تفاصيل المرحلة</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.phases.index', $installationProject->id) }}">مراحل المشروع</a></li>
                    <li class="breadcrumb-item active">{{ $phase->name }}</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <!-- الأزرار العلوية -->
                <div class="mb-3">
                    @if(auth()->user()->hasPermission('edit_installation_project'))
                    <a href="{{ route('installation-projects.phases.edit', [$installationProject->id, $phase->id]) }}" class="btn btn-warning">
                        <i class="fas fa-edit"></i> تعديل المرحلة
                    </a>
                    @endif
                    <a href="{{ route('installation-projects.phases.index', $installationProject->id) }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة لقائمة المراحل
                    </a>
                </div>

                <!-- بطاقة تفاصيل المرحلة -->
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">
                            <i class="fas fa-tasks"></i>
                            تفاصيل المرحلة: {{ $phase->name }}
                        </h3>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-info"><i class="fas fa-info-circle"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">معلومات المرحلة</span>
                                        <span class="info-box-number">{{ $phase->name }}</span>
                                        <div class="progress">
                                            <div class="progress-bar bg-info" style="width: 100%"></div>
                                        </div>
                                        <span class="progress-description">
                                            الترتيب: {{ $phase->order_number }}
                                        </span>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="info-box">
                                    <span class="info-box-icon bg-success"><i class="fas fa-chart-line"></i></span>
                                    <div class="info-box-content">
                                        <span class="info-box-text">نسبة الإنجاز</span>
                                        <span class="info-box-number">{{ $phase->completion_percentage }}%</span>
                                        <div class="progress">
                                            <div class="progress-bar bg-success" style="width: {{ $phase->completion_percentage }}%"></div>
                                        </div>
                                        <span class="progress-description">
                                            @if($phase->status == 'not_started')
                                            <span class="badge badge-secondary">لم تبدأ</span>
                                            @elseif($phase->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                            @elseif($phase->status == 'completed')
                                            <span class="badge badge-success">مكتملة</span>
                                            @elseif($phase->status == 'delayed')
                                            <span class="badge badge-warning">متأخرة</span>
                                            @elseif($phase->status == 'cancelled')
                                            <span class="badge badge-danger">ملغية</span>
                                            @endif
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">تفاصيل المرحلة</h3>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-6">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th style="width: 30%">اسم المرحلة</th>
                                                        <td>{{ $phase->name }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الوصف</th>
                                                        <td>{{ $phase->description ?? 'لا يوجد وصف' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>تاريخ البدء</th>
                                                        <td>{{ $phase->start_date->format('Y-m-d') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>تاريخ الانتهاء</th>
                                                        <td>{{ $phase->end_date->format('Y-m-d') }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>المدة</th>
                                                        <td>{{ $phase->start_date->diffInDays($phase->end_date) + 1 }} يوم</td>
                                                    </tr>
                                                </table>
                                            </div>
                                            <div class="col-md-6">
                                                <table class="table table-bordered">
                                                    <tr>
                                                        <th style="width: 30%">الميزانية</th>
                                                        <td>{{ number_format($phase->budget, 2) }} ريال</td>
                                                    </tr>
                                                    <tr>
                                                        <th>المسؤول</th>
                                                        <td>{{ $phase->responsibleUser->name ?? 'غير محدد' }}</td>
                                                    </tr>
                                                    <tr>
                                                        <th>الحالة</th>
                                                        <td>
                                                            @if($phase->status == 'not_started')
                                                            <span class="badge badge-secondary">لم تبدأ</span>
                                                            @elseif($phase->status == 'in_progress')
                                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                                            @elseif($phase->status == 'completed')
                                                            <span class="badge badge-success">مكتملة</span>
                                                            @elseif($phase->status == 'delayed')
                                                            <span class="badge badge-warning">متأخرة</span>
                                                            @elseif($phase->status == 'cancelled')
                                                            <span class="badge badge-danger">ملغية</span>
                                                            @endif
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>نسبة الإنجاز</th>
                                                        <td>
                                                            <div class="progress">
                                                                <div class="progress-bar progress-bar-striped 
                                                                    @if($phase->completion_percentage < 30) bg-danger
                                                                    @elseif($phase->completion_percentage < 70) bg-warning
                                                                    @else bg-success @endif" 
                                                                    role="progressbar" 
                                                                    style="width: {{ $phase->completion_percentage }}%" 
                                                                    aria-valuenow="{{ $phase->completion_percentage }}" 
                                                                    aria-valuemin="0" 
                                                                    aria-valuemax="100">
                                                                    {{ $phase->completion_percentage }}%
                                                                </div>
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    <tr>
                                                        <th>ملاحظات</th>
                                                        <td>{{ $phase->notes ?? 'لا توجد ملاحظات' }}</td>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- مهام المرحلة -->
                        <div class="row mt-3">
                            <div class="col-md-12">
                                <div class="card">
                                    <div class="card-header d-flex justify-content-between align-items-center">
                                        <h3 class="card-title">مهام المرحلة</h3>
                                        <div class="card-tools">
                                            @if(auth()->user()->hasPermission('edit_installation_project'))
                                            <a href="{{ route('installation-projects.phases.tasks.create', [$installationProject->id, $phase->id]) }}" class="btn btn-primary btn-sm">
                                                <i class="fas fa-plus"></i> إضافة مهمة جديدة
                                            </a>
                                            @endif
                                        </div>
                                    </div>
                                    <div class="card-body">
                                        @if($phase->tasks->count() > 0)
                                        <div class="table-responsive">
                                            <table class="table table-bordered table-striped">
                                                <thead>
                                                    <tr>
                                                        <th width="5%">#</th>
                                                        <th width="25%">اسم المهمة</th>
                                                        <th width="10%">تاريخ البدء</th>
                                                        <th width="10%">تاريخ الانتهاء</th>
                                                        <th width="15%">المسؤول</th>
                                                        <th width="10%">الحالة</th>
                                                        <th width="15%">نسبة الإنجاز</th>
                                                        <th width="10%">الإجراءات</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    @foreach($phase->tasks as $task)
                                                    <tr>
                                                        <td>{{ $task->order_number }}</td>
                                                        <td>{{ $task->name }}</td>
                                                        <td>{{ $task->start_date->format('Y-m-d') }}</td>
                                                        <td>{{ $task->end_date->format('Y-m-d') }}</td>
                                                        <td>{{ $task->responsibleUser->name ?? 'غير محدد' }}</td>
                                                        <td>
                                                            @if($task->status == 'not_started')
                                                            <span class="badge badge-secondary">لم تبدأ</span>
                                                            @elseif($task->status == 'in_progress')
                                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                                            @elseif($task->status == 'completed')
                                                            <span class="badge badge-success">مكتملة</span>
                                                            @elseif($task->status == 'delayed')
                                                            <span class="badge badge-warning">متأخرة</span>
                                                            @elseif($task->status == 'cancelled')
                                                            <span class="badge badge-danger">ملغية</span>
                                                            @endif
                                                        </td>
                                                        <td>
                                                            <div class="progress">
                                                                <div class="progress-bar progress-bar-striped 
                                                                    @if($task->completion_percentage < 30) bg-danger
                                                                    @elseif($task->completion_percentage < 70) bg-warning
                                                                    @else bg-success @endif" 
                                                                    role="progressbar" 
                                                                    style="width: {{ $task->completion_percentage }}%" 
                                                                    aria-valuenow="{{ $task->completion_percentage }}" 
                                                                    aria-valuemin="0" 
                                                                    aria-valuemax="100">
                                                                    {{ $task->completion_percentage }}%
                                                                </div>
                                                            </div>
                                                        </td>
                                                        <td>
                                                            <div class="btn-group">
                                                                <a href="{{ route('installation-projects.phases.tasks.show', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-info btn-sm" title="عرض">
                                                                    <i class="fas fa-eye"></i>
                                                                </a>
                                                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                                                <a href="{{ route('installation-projects.phases.tasks.edit', [$installationProject->id, $phase->id, $task->id]) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                                    <i class="fas fa-edit"></i>
                                                                </a>
                                                                @endif
                                                            </div>
                                                        </td>
                                                    </tr>
                                                    @endforeach
                                                </tbody>
                                            </table>
                                        </div>
                                        @else
                                        <div class="alert alert-info">
                                            <i class="fas fa-info-circle"></i> لا توجد مهام لهذه المرحلة
                                        </div>
                                        @endif
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@endsection

@push('styles')
<style>
    .progress {
        height: 20px;
    }
    .progress-bar {
        line-height: 20px;
    }
</style>
@endpush