@extends('layouts.modern')

@section('title', 'مراحل المشروع - ' . $installationProject->title)

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>مراحل المشروع</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                    <li class="breadcrumb-item active">مراحل المشروع</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h3 class="card-title">مراحل المشروع: {{ $installationProject->title }}</h3>
                        <div class="card-tools">
                            @if(auth()->user()->hasPermission('edit_installation_project'))
                            <a href="{{ route('installation-projects.phases.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> إضافة مرحلة جديدة
                            </a>
                            @endif
                            <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-right"></i> العودة للمشروع
                            </a>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-- معلومات المشروع المختصرة -->
                        <div class="row mb-4">
                            <div class="col-md-12">
                                <div class="card bg-light">
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <strong>رقم المشروع:</strong> {{ $installationProject->project_number }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>العميل:</strong> {{ $installationProject->customer->name ?? 'غير محدد' }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>تاريخ البدء:</strong> {{ $installationProject->start_date->format('Y-m-d') }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>تاريخ الانتهاء المتوقع:</strong> {{ $installationProject->expected_completion_date->format('Y-m-d') }}
                                            </div>
                                        </div>
                                        <div class="row mt-2">
                                            <div class="col-md-3">
                                                <strong>الحالة:</strong>
                                                @if($installationProject->status == 'not_started')
                                                <span class="badge badge-secondary">لم يبدأ</span>
                                                @elseif($installationProject->status == 'in_progress')
                                                <span class="badge badge-primary">قيد التنفيذ</span>
                                                @elseif($installationProject->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                                @elseif($installationProject->status == 'delayed')
                                                <span class="badge badge-warning">متأخر</span>
                                                @elseif($installationProject->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </div>
                                            <div class="col-md-3">
                                                <strong>الميزانية:</strong> {{ number_format($installationProject->total_budget, 2) }} ريال
                                            </div>
                                            <div class="col-md-3">
                                                <strong>مدير المشروع:</strong> {{ $installationProject->projectManager->name ?? 'غير محدد' }}
                                            </div>
                                            <div class="col-md-3">
                                                <strong>نسبة الإنجاز:</strong>
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-striped 
                                                        @if($installationProject->calculateProgress() < 30) bg-danger
                                                        @elseif($installationProject->calculateProgress() < 70) bg-warning
                                                        @else bg-success @endif" 
                                                        role="progressbar" 
                                                        style="width: {{ $installationProject->calculateProgress() }}%" 
                                                        aria-valuenow="{{ $installationProject->calculateProgress() }}" 
                                                        aria-valuemin="0" 
                                                        aria-valuemax="100">
                                                        {{ $installationProject->calculateProgress() }}%
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- جدول مراحل المشروع -->
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th width="20%">اسم المرحلة</th>
                                        <th width="10%">تاريخ البدء</th>
                                        <th width="10%">تاريخ الانتهاء</th>
                                        <th width="10%">المسؤول</th>
                                        <th width="10%">الحالة</th>
                                        <th width="15%">نسبة الإنجاز</th>
                                        <th width="10%">الميزانية</th>
                                        <th width="10%">الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @forelse($phases as $phase)
                                    <tr>
                                        <td>{{ $phase->order_number }}</td>
                                        <td>{{ $phase->name }}</td>
                                        <td>{{ $phase->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $phase->end_date->format('Y-m-d') }}</td>
                                        <td>{{ $phase->responsibleUser->name ?? 'غير محدد' }}</td>
                                        <td>
                                            @if($phase->status == 'not_started')
                                            <span class="badge badge-secondary">لم تبدأ</span>
                                            @elseif($phase->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                            @elseif($phase->status == 'completed')
                                            <span class="badge badge-success">مكتملة</span>
                                            @elseif($phase->status == 'delayed')
                                            <span class="badge badge-warning">متأخرة</span>
                                            @elseif($phase->status == 'cancelled')
                                            <span class="badge badge-danger">ملغية</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped 
                                                    @if($phase->completion_percentage < 30) bg-danger
                                                    @elseif($phase->completion_percentage < 70) bg-warning
                                                    @else bg-success @endif" 
                                                    role="progressbar" 
                                                    style="width: {{ $phase->completion_percentage }}%" 
                                                    aria-valuenow="{{ $phase->completion_percentage }}" 
                                                    aria-valuemin="0" 
                                                    aria-valuemax="100">
                                                    {{ $phase->completion_percentage }}%
                                                </div>
                                            </div>
                                        </td>
                                        <td>{{ number_format($phase->budget, 2) }} ريال</td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('installation-projects.phases.show', [$installationProject->id, $phase->id]) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                                <a href="{{ route('installation-projects.phases.edit', [$installationProject->id, $phase->id]) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-phase-{{ $phase->id }}" title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                @endif
                                            </div>
                                            
                                            <!-- Modal Delete -->
                                            <div class="modal fade" id="delete-phase-{{ $phase->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-phase-{{ $phase->id }}-label" aria-hidden="true">
                                                <div class="modal-dialog" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="delete-phase-{{ $phase->id }}-label">تأكيد الحذف</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            هل أنت متأكد من حذف المرحلة <strong>{{ $phase->name }}</strong>؟
                                                            <br>
                                                            <div class="alert alert-warning mt-2">
                                                                <i class="fas fa-exclamation-triangle"></i>
                                                                تحذير: سيتم حذف جميع البيانات المرتبطة بهذه المرحلة (المهام، المستندات، إلخ).
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <form action="{{ route('installation-projects.phases.destroy', [$installationProject->id, $phase->id]) }}" method="POST">
                                                                @csrf
                                                                @method('DELETE')
                                                                <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                <button type="submit" class="btn btn-danger">حذف</button>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </td>
                                    </tr>
                                    @empty
                                    <tr>
                                        <td colspan="9" class="text-center">لا توجد مراحل للمشروع</td>
                                    </tr>
                                    @endforelse
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
@endsection

@push('styles')
<style>
    .progress {
        height: 20px;
    }
    .progress-bar {
        line-height: 20px;
    }
</style>
@endpush