@extends('layouts.modern')

@section('title', 'تعديل المرحلة - ' . $phase->name)

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>تعديل مرحلة المشروع</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.phases.index', $installationProject->id) }}">مراحل المشروع</a></li>
                    <li class="breadcrumb-item active">تعديل المرحلة</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card card-warning">
                    <div class="card-header">
                        <h3 class="card-title">تعديل بيانات المرحلة</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form action="{{ route('installation-projects.phases.update', [$installationProject->id, $phase->id]) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="row">
                                <!-- معلومات المرحلة الأساسية -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="name">اسم المرحلة <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $phase->name) }}" required>
                                        @error('name')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="description">وصف المرحلة</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $phase->description) }}</textarea>
                                        @error('description')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="order_number">الترتيب <span class="text-danger">*</span></label>
                                        <input type="number" class="form-control @error('order_number') is-invalid @enderror" id="order_number" name="order_number" value="{{ old('order_number', $phase->order_number) }}" min="1" required>
                                        @error('order_number')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="budget">الميزانية (ريال) <span class="text-danger">*</span></label>
                                        <input type="number" step="0.01" class="form-control @error('budget') is-invalid @enderror" id="budget" name="budget" value="{{ old('budget', $phase->budget) }}" min="0" required>
                                        @error('budget')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="start_date">تاريخ البدء <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date', $phase->start_date->format('Y-m-d')) }}" required>
                                        @error('start_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="end_date">تاريخ الانتهاء <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control @error('end_date') is-invalid @enderror" id="end_date" name="end_date" value="{{ old('end_date', $phase->end_date->format('Y-m-d')) }}" required>
                                        @error('end_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="status">الحالة <span class="text-danger">*</span></label>
                                        <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                            <option value="not_started" {{ old('status', $phase->status) == 'not_started' ? 'selected' : '' }}>لم تبدأ</option>
                                            <option value="in_progress" {{ old('status', $phase->status) == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ old('status', $phase->status) == 'completed' ? 'selected' : '' }}>مكتملة</option>
                                            <option value="delayed" {{ old('status', $phase->status) == 'delayed' ? 'selected' : '' }}>متأخرة</option>
                                            <option value="cancelled" {{ old('status', $phase->status) == 'cancelled' ? 'selected' : '' }}>ملغية</option>
                                        </select>
                                        @error('status')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="completion_percentage">نسبة الإنجاز <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" class="form-control @error('completion_percentage') is-invalid @enderror" id="completion_percentage" name="completion_percentage" value="{{ old('completion_percentage', $phase->completion_percentage) }}" min="0" max="100" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text">%</span>
                                            </div>
                                        </div>
                                        @error('completion_percentage')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    
                                    <div class="form-group">
                                        <label for="responsible_user_id">المسؤول عن المرحلة</label>
                                        <select class="form-control @error('responsible_user_id') is-invalid @enderror" id="responsible_user_id" name="responsible_user_id">
                                            <option value="">-- اختر المسؤول --</option>
                                            @foreach($responsibleUsers as $user)
                                            <option value="{{ $user->id }}" {{ old('responsible_user_id', $phase->responsible_user_id) == $user->id ? 'selected' : '' }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('responsible_user_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="notes">ملاحظات</label>
                                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $phase->notes) }}</textarea>
                                        @error('notes')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-body -->
                        
                        <div class="card-footer">
                            <button type="submit" class="btn btn-warning">تحديث</button>
                            <a href="{{ route('installation-projects.phases.index', $installationProject->id) }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
@endsection

@push('scripts')
<script>
    $(function() {
        // التحقق من تاريخ البدء والانتهاء
        $('#start_date, #end_date').change(function() {
            var startDate = new Date($('#start_date').val());
            var endDate = new Date($('#end_date').val());
            
            if (startDate > endDate) {
                alert('تاريخ البدء يجب أن يكون قبل تاريخ الانتهاء');
                $('#end_date').val('');
            }
        });
        
        // تحديث حالة المرحلة بناءً على نسبة الإنجاز
        $('#completion_percentage').change(function() {
            var percentage = $(this).val();
            
            if (percentage == 0) {
                $('#status').val('not_started');
            } else if (percentage == 100) {
                $('#status').val('completed');
            } else {
                $('#status').val('in_progress');
            }
        });
        
        // تحديث نسبة الإنجاز بناءً على حالة المرحلة
        $('#status').change(function() {
            var status = $(this).val();
            
            if (status == 'not_started') {
                $('#completion_percentage').val(0);
            } else if (status == 'completed') {
                $('#completion_percentage').val(100);
            }
        });
    });
</script>
@endpush