@extends('layouts.modern')

@section('title', 'جميع مراحل المشاريع')

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>جميع مراحل المشاريع</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item active">جميع مراحل المشاريع</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">قائمة جميع مراحل المشاريع</h3>
                        <div class="card-tools">
                            <div class="dropdown">
                                <button class="btn btn-success dropdown-toggle" type="button" id="addPhaseDropdown" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    <i class="fas fa-plus"></i> إضافة مرحلة جديدة
                                </button>
                                <div class="dropdown-menu dropdown-menu-right" aria-labelledby="addPhaseDropdown">
                                    @foreach(\App\Models\InstallationProject::where('company_id', auth()->user()->company_id)
                                        ->where('status', '!=', 'completed')
                                        ->where('status', '!=', 'cancelled')
                                        ->orderBy('title')
                                        ->get() as $project)
                                        <a class="dropdown-item" href="{{ route('installation-projects.phases.create', $project->id) }}">
                                            {{ $project->title }}
                                        </a>
                                    @endforeach
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        @if($phases->count() > 0)
                        <div class="table-responsive">
                            <table class="table table-bordered table-striped">
                                <thead>
                                    <tr>
                                        <th width="5%">#</th>
                                        <th width="15%">اسم المرحلة</th>
                                        <th width="20%">المشروع</th>
                                        <th width="10%">تاريخ البدء</th>
                                        <th width="10%">تاريخ الانتهاء</th>
                                        <th width="10%">الحالة</th>
                                        <th width="15%">نسبة الإنجاز</th>
                                        <th width="15%">الإجراءات</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach($phases as $phase)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td>{{ $phase->name }}</td>
                                        <td>
                                            <a href="{{ route('installation-projects.show', $phase->installation_project_id) }}">
                                                {{ $phase->installationProject->title ?? 'غير محدد' }}
                                            </a>
                                        </td>
                                        <td>{{ $phase->start_date->format('Y-m-d') }}</td>
                                        <td>{{ $phase->end_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($phase->status == 'not_started')
                                            <span class="badge badge-secondary">لم تبدأ</span>
                                            @elseif($phase->status == 'in_progress')
                                            <span class="badge badge-primary">قيد التنفيذ</span>
                                            @elseif($phase->status == 'completed')
                                            <span class="badge badge-success">مكتملة</span>
                                            @elseif($phase->status == 'delayed')
                                            <span class="badge badge-warning">متأخرة</span>
                                            @elseif($phase->status == 'cancelled')
                                            <span class="badge badge-danger">ملغية</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="progress">
                                                <div class="progress-bar progress-bar-striped 
                                                    @if($phase->completion_percentage < 30) bg-danger
                                                    @elseif($phase->completion_percentage < 70) bg-warning
                                                    @else bg-success @endif" 
                                                    role="progressbar" 
                                                    style="width: {{ $phase->completion_percentage }}%" 
                                                    aria-valuenow="{{ $phase->completion_percentage }}" 
                                                    aria-valuemin="0" 
                                                    aria-valuemax="100">
                                                    {{ $phase->completion_percentage }}%
                                                </div>
                                            </div>
                                        </td>
                                        <td>
                                            <div class="btn-group">
                                                <a href="{{ route('installation-projects.phases.show', [$phase->installation_project_id, $phase->id]) }}" class="btn btn-info btn-sm" title="عرض">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                                <a href="{{ route('installation-projects.phases.edit', [$phase->installation_project_id, $phase->id]) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-phase-{{ $phase->id }}" title="حذف">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                                
                                                <!-- Modal Delete -->
                                                <div class="modal fade" id="delete-phase-{{ $phase->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-phase-{{ $phase->id }}-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-phase-{{ $phase->id }}-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف المرحلة <strong>{{ $phase->name }}</strong>؟
                                                                <br>
                                                                <div class="alert alert-warning mt-2">
                                                                    <i class="fas fa-exclamation-triangle"></i>
                                                                    تحذير: سيتم حذف جميع البيانات المرتبطة بهذه المرحلة (المهام، المستندات، إلخ).
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <form action="{{ route('installation-projects.phases.destroy', [$phase->installation_project_id, $phase->id]) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                    @endforeach
                                </tbody>
                            </table>
                        </div>
                        <div class="mt-3">
                            {{ $phases->links() }}
                        </div>
                        @else
                        <div class="alert alert-info">
                            <i class="fas fa-info-circle"></i> لا توجد مراحل للمشاريع حالياً
                        </div>
                        @endif
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
</section>
@endsection

@push('styles')
<style>
    .progress {
        height: 20px;
    }
    .progress-bar {
        line-height: 20px;
    }
</style>
@endpush