@extends('layouts.modern')

@section('title', 'إدارة مشاريع التركيب')

@section('content')
<!-- Main content -->
<section class="content">
    <div class="container-fluid px-0">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header d-flex justify-content-between align-items-center">
                        <h3 class="card-title">قائمة مشاريع التركيب</h3>
                        <div class="card-tools">
                            @if(auth()->user()->hasPermission('create_installation_project'))
                            <a href="{{ route('installation-projects.create') }}" class="btn btn-primary btn-sm">
                                <i class="fas fa-plus"></i> إضافة مشروع جديد
                            </a>
                            @endif
                        </div>
                    </div>
                    <!-- /.card-header -->
                    <div class="card-body">
                        <!-- إشعار بالتحديث -->
                        <div class="alert alert-info alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">&times;</button>
                            <h5><i class="icon fas fa-info"></i> تحديث جديد!</h5>
                            تم تحسين طريقة عرض مخطط جانت للمشاريع. استخدم زر <i class="fas fa-chart-bar"></i> لعرض المخطط بطريقة آمنة.
                            إذا واجهتك أي مشكلة في الوصول إلى المخطط، يرجى التواصل مع الدعم الفني.
                        </div>
                        
                        <!-- فلاتر البحث -->
                        <div class="row mb-3">
                            <div class="col-md-12">
                                <form action="{{ route('installation-projects.index') }}" method="GET" class="form-inline">
                                    <div class="form-group mx-1">
                                        <input type="text" name="search" class="form-control form-control-sm" placeholder="بحث..." value="{{ request('search') }}">
                                    </div>
                                    <div class="form-group mx-1">
                                        <select name="status" class="form-control form-control-sm">
                                            <option value="">-- الحالة --</option>
                                            <option value="not_started" {{ request('status') == 'not_started' ? 'selected' : '' }}>لم يبدأ</option>
                                            <option value="in_progress" {{ request('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="completed" {{ request('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                            <option value="delayed" {{ request('status') == 'delayed' ? 'selected' : '' }}>متأخر</option>
                                            <option value="cancelled" {{ request('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                        </select>
                                    </div>
                                    <div class="form-group mx-1">
                                        <select name="customer_id" class="form-control form-control-sm">
                                            <option value="">-- العميل --</option>
                                            @foreach(\App\Models\Customer::where('company_id', auth()->user()->company_id)->get() as $customer)
                                            <option value="{{ $customer->id }}" {{ request('customer_id') == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <button type="submit" class="btn btn-sm btn-primary mx-1">
                                        <i class="fas fa-search"></i> بحث
                                    </button>
                                    <a href="{{ route('installation-projects.index') }}" class="btn btn-sm btn-secondary">
                                        <i class="fas fa-redo"></i> إعادة تعيين
                                    </a>
                                </form>
                            </div>
                        </div>

                        <!-- جدول المشاريع -->
                        <div class="table-responsive">
                                <table class="table table-bordered table-striped installation-projects-table">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>رقم المشروع</th>
                                            <th>العنوان</th>
                                            <th>العميل</th>
                                            <th>الموقع</th>
                                            <th>تاريخ البدء</th>
                                            <th>تاريخ الانتهاء المتوقع</th>
                                            <th>الحالة</th>
                                            <th>نسبة الإنجاز</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($projects as $project)
                                        <tr>
                                            <td>{{ $loop->iteration }}</td>
                                            <td>{{ $project->project_number }}</td>
                                            <td>{{ $project->title }}</td>
                                            <td>{{ $project->customer->name ?? 'غير محدد' }}</td>
                                            <td>{{ $project->location->name ?? 'غير محدد' }}</td>
                                            <td>{{ $project->start_date->format('Y-m-d') }}</td>
                                            <td>{{ $project->expected_completion_date->format('Y-m-d') }}</td>
                                            <td>
                                                @if($project->status == 'not_started')
                                                <span class="badge badge-secondary">لم يبدأ</span>
                                                @elseif($project->status == 'in_progress')
                                                <span class="badge badge-primary">قيد التنفيذ</span>
                                                @elseif($project->status == 'completed')
                                                <span class="badge badge-success">مكتمل</span>
                                                @elseif($project->status == 'delayed')
                                                <span class="badge badge-warning">متأخر</span>
                                                @elseif($project->status == 'cancelled')
                                                <span class="badge badge-danger">ملغي</span>
                                                @endif
                                            </td>
                                            <td>
                                                <div class="progress">
                                                    <div class="progress-bar progress-bar-striped 
                                                        @if($project->calculateProgress() < 30) bg-danger
                                                        @elseif($project->calculateProgress() < 70) bg-warning
                                                        @else bg-success @endif" 
                                                        role="progressbar" 
                                                        style="width: {{ $project->calculateProgress() }}%" 
                                                        aria-valuenow="{{ $project->calculateProgress() }}" 
                                                        aria-valuemin="0" 
                                                        aria-valuemax="100">
                                                        {{ $project->calculateProgress() }}%
                                                    </div>
                                                </div>
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    @if(auth()->user()->hasPermission('view_installation_projects'))
                                                    <a href="{{ route('installation-projects.show', $project->id) }}" class="btn btn-info btn-sm" title="عرض">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    @endif
                                                    
                                                    @if(auth()->user()->hasPermission('view_installation_projects'))
                                                    <a href="{{ route('installation-projects.dashboard', $project->id) }}" class="btn btn-primary btn-sm" title="لوحة التحكم">
                                                        <i class="fas fa-tachometer-alt"></i>
                                                    </a>
                                                    @endif
                                                    
                                                    @if(auth()->user()->hasPermission('view_installation_projects'))
                                                    <a href="{{ route('installation-projects.gantt.safe', $project->id) }}" class="btn btn-success btn-sm" title="مخطط جانت">
                                                        <i class="fas fa-chart-bar"></i>
                                                    </a>
                                                    @endif
                                                    
                                                    @if(auth()->user()->hasPermission('edit_installation_project'))
                                                    <a href="{{ route('installation-projects.edit', $project->id) }}" class="btn btn-warning btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    @endif
                                                    
                                                    @if(auth()->user()->hasPermission('delete_installation_project'))
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#delete-project-{{ $project->id }}" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endif
                                                </div>
                                                
                                                <!-- Modal Delete -->
                                                <div class="modal fade" id="delete-project-{{ $project->id }}" tabindex="-1" role="dialog" aria-labelledby="delete-project-{{ $project->id }}-label" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="delete-project-{{ $project->id }}-label">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من حذف المشروع <strong>{{ $project->title }}</strong>؟
                                                                <br>
                                                                <div class="alert alert-warning mt-2">
                                                                    <i class="fas fa-exclamation-triangle"></i>
                                                                    تحذير: سيتم حذف جميع البيانات المرتبطة بهذا المشروع (المراحل، المهام، المستندات، إلخ).
                                                                </div>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <form action="{{ route('installation-projects.destroy', $project->id) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @empty
                                        <tr>
                                            <td colspan="10" class="text-center">لا توجد مشاريع</td>
                                        </tr>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            
                            <!-- Pagination -->
                            <div class="d-flex justify-content-center mt-3">
                                {{ $projects->appends(request()->query())->links() }}
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
@endsection

@push('styles')
<link rel="stylesheet" href="{{ asset('css/installation-projects.css') }}">
@endpush

@push('scripts')
<script>
    $(function () {
        // تفعيل التوست للرسائل
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        
        // عرض رسائل النجاح
        @if(session('success'))
        Toast.fire({
            icon: 'success',
            title: '{{ session("success") }}'
        });
        @endif
        
        // عرض رسائل الخطأ
        @if(session('error'))
        Toast.fire({
            icon: 'error',
            title: '{{ session("error") }}'
        });
        @endif
    });
</script>
@endpush