@extends('layouts.modern')

@section('title', 'مخطط جانت للمشروع')

@section('styles')
<link rel="stylesheet" href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css">
<style>
    .gantt-container {
        height: 600px;
        width: 100%;
    }
    
    .critical_task {
        background-color: #ff8686;
    }
    
    .high_priority {
        border-left: 5px solid #ff5252;
    }
    
    .medium_priority {
        border-left: 5px solid #ffc107;
    }
    
    .low_priority {
        border-left: 5px solid #4caf50;
    }
    
    .weekend {
        background: #f4f7f4;
    }
    
    .gantt_task_line.gantt_dependent_task {
        background-color: #65c16f;
        border: 1px solid #3c9445;
    }
</style>
@endsection

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">مخطط جانت للمشروع: {{ $installationProject->title }}</h3>
                    <div class="card-tools">
                        <a href="{{ route('installation-projects.gantt.critical-path', $installationProject->id) }}" class="btn btn-danger btn-sm">
                            <i class="fas fa-route"></i> المسار الحرج
                        </a>
                        <a href="{{ route('installation-projects.show', $installationProject->id) }}" class="btn btn-secondary btn-sm mr-2">
                            <i class="fas fa-arrow-right"></i> العودة للمشروع
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row mb-3">
                        <div class="col-md-12">
                            <div class="btn-group">
                                <button id="zoomIn" class="btn btn-outline-primary">
                                    <i class="fas fa-search-plus"></i> تكبير
                                </button>
                                <button id="zoomOut" class="btn btn-outline-primary">
                                    <i class="fas fa-search-minus"></i> تصغير
                                </button>
                                <button id="zoomToFit" class="btn btn-outline-primary">
                                    <i class="fas fa-expand-arrows-alt"></i> احتواء الكل
                                </button>
                                <button id="today" class="btn btn-outline-primary">
                                    <i class="fas fa-calendar-day"></i> اليوم
                                </button>
                                <div class="btn-group">
                                    <button type="button" class="btn btn-outline-primary dropdown-toggle" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                        <i class="fas fa-eye"></i> العرض
                                    </button>
                                    <div class="dropdown-menu">
                                        <a class="dropdown-item" href="#" data-scale="day">يوم</a>
                                        <a class="dropdown-item" href="#" data-scale="week">أسبوع</a>
                                        <a class="dropdown-item" href="#" data-scale="month">شهر</a>
                                        <a class="dropdown-item" href="#" data-scale="quarter">ربع سنوي</a>
                                        <a class="dropdown-item" href="#" data-scale="year">سنة</a>
                                    </div>
                                </div>
                                <button id="exportPDF" class="btn btn-outline-danger">
                                    <i class="fas fa-file-pdf"></i> تصدير PDF
                                </button>
                                <button id="exportPNG" class="btn btn-outline-success">
                                    <i class="fas fa-file-image"></i> تصدير PNG
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row">
                        <div class="col-md-12">
                            <div class="gantt-container" id="gantt_here"></div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">إضافة اعتمادية بين المهام</h5>
                                </div>
                                <div class="card-body">
                                    <form id="dependencyForm" class="form-inline">
                                        <div class="form-group mx-sm-3 mb-2">
                                            <label for="task_id" class="sr-only">المهمة</label>
                                            <select class="form-control" id="task_id" name="task_id" required>
                                                <option value="">اختر المهمة</option>
                                                @foreach($ganttData['data'] as $item)
                                                    @if(strpos($item['id'], 'task_') === 0)
                                                        <option value="{{ str_replace('task_', '', $item['id']) }}">{{ $item['text'] }}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group mx-sm-3 mb-2">
                                            <label for="dependency_type" class="sr-only">نوع الاعتمادية</label>
                                            <select class="form-control" id="dependency_type" name="dependency_type" required>
                                                <option value="finish_to_start">نهاية إلى بداية (FS)</option>
                                                <option value="start_to_start">بداية إلى بداية (SS)</option>
                                                <option value="finish_to_finish">نهاية إلى نهاية (FF)</option>
                                                <option value="start_to_finish">بداية إلى نهاية (SF)</option>
                                            </select>
                                        </div>
                                        <div class="form-group mx-sm-3 mb-2">
                                            <label for="dependency_task_id" class="sr-only">المهمة المعتمد عليها</label>
                                            <select class="form-control" id="dependency_task_id" name="dependency_task_id" required>
                                                <option value="">اختر المهمة المعتمد عليها</option>
                                                @foreach($ganttData['data'] as $item)
                                                    @if(strpos($item['id'], 'task_') === 0)
                                                        <option value="{{ str_replace('task_', '', $item['id']) }}">{{ $item['text'] }}</option>
                                                    @endif
                                                @endforeach
                                            </select>
                                        </div>
                                        <div class="form-group mx-sm-3 mb-2">
                                            <label for="lag_days" class="sr-only">أيام التأخير</label>
                                            <input type="number" class="form-control" id="lag_days" name="lag_days" placeholder="أيام التأخير" value="0" min="0">
                                        </div>
                                        <button type="submit" class="btn btn-primary mb-2">إضافة اعتمادية</button>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/locale/locale_ar.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_critical_path.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_marker.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_smart_rendering.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_tooltip.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_undo.js"></script>
<script src="https://cdn.dhtmlx.com/gantt/edge/ext/dhtmlxgantt_auto_scheduling.js"></script>
<script>
    $(document).ready(function() {
        // تهيئة مخطط جانت
        gantt.config.date_format = "%Y-%m-%d %H:%i";
        gantt.config.work_time = true;
        gantt.config.skip_off_time = true;
        gantt.config.auto_scheduling = true;
        gantt.config.auto_scheduling_strict = true;
        gantt.config.row_height = 30;
        gantt.config.fit_tasks = true;
        gantt.config.show_progress = true;
        gantt.config.show_unscheduled = true;
        gantt.config.details_on_dblclick = false;
        gantt.config.drag_progress = true;
        gantt.config.drag_resize = true;
        gantt.config.drag_move = true;
        gantt.config.drag_links = true;
        gantt.config.smart_rendering = true;
        gantt.config.show_markers = true;
        
        // تكوين أعمدة المخطط
        gantt.config.columns = [
            {name: "text", label: "اسم المهمة", tree: true, width: 200},
            {name: "start_date", label: "تاريخ البدء", align: "center", width: 100},
            {name: "end_date", label: "تاريخ الانتهاء", align: "center", width: 100},
            {name: "duration", label: "المدة (أيام)", align: "center", width: 80},
            {name: "progress", label: "التقدم", align: "center", width: 80, template: function(obj) {
                return Math.round(obj.progress * 100) + "%";
            }},
            {name: "responsible", label: "المسؤول", align: "center", width: 100}
        ];
        
        // تكوين عرض المهام
        gantt.templates.task_class = function(start, end, task) {
            var classes = "";
            if (task.critical) {
                classes += " critical_task";
            }
            
            if (task.priority) {
                classes += " " + task.priority + "_priority";
            }
            
            return classes;
        };
        
        // تكوين عرض الخلايا
        gantt.templates.scale_cell_class = function(date) {
            if (date.getDay() == 5 || date.getDay() == 6) {
                return "weekend";
            }
            return "";
        };
        
        // تكوين التلميحات
        gantt.templates.tooltip_text = function(start, end, task) {
            var html = "<b>المهمة:</b> " + task.text + "<br/>";
            html += "<b>تاريخ البدء:</b> " + gantt.templates.tooltip_date_format(start) + "<br/>";
            html += "<b>تاريخ الانتهاء:</b> " + gantt.templates.tooltip_date_format(end) + "<br/>";
            html += "<b>المدة:</b> " + task.duration + " أيام<br/>";
            html += "<b>التقدم:</b> " + Math.round(task.progress * 100) + "%<br/>";
            
            if (task.responsible) {
                html += "<b>المسؤول:</b> " + task.responsible + "<br/>";
            }
            
            if (task.critical) {
                html += "<b style='color:red'>مهمة حرجة</b><br/>";
            }
            
            return html;
        };
        
        // إضافة علامة اليوم
        var today = new Date();
        gantt.addMarker({
            start_date: today,
            css: "today",
            text: "اليوم",
            title: "اليوم: " + gantt.templates.tooltip_date_format(today)
        });
        
        // تحميل البيانات
        gantt.init("gantt_here");
        gantt.parse({
            data: {!! json_encode($ganttData['data']) !!},
            links: {!! json_encode($ganttData['links']) !!}
        });
        
        // تفعيل المسار الحرج
        gantt.config.highlight_critical_path = true;
        
        // أزرار التكبير والتصغير
        $("#zoomIn").click(function() {
            gantt.ext.zoom.zoomIn();
        });
        
        $("#zoomOut").click(function() {
            gantt.ext.zoom.zoomOut();
        });
        
        $("#zoomToFit").click(function() {
            gantt.ext.zoom.zoomToFit();
        });
        
        $("#today").click(function() {
            gantt.showDate(new Date());
        });
        
        // تغيير مقياس العرض
        $(".dropdown-item").click(function(e) {
            e.preventDefault();
            var scale = $(this).data("scale");
            setScale(scale);
        });
        
        function setScale(scale) {
            switch (scale) {
                case "day":
                    gantt.config.scale_unit = "day";
                    gantt.config.step = 1;
                    gantt.config.date_scale = "%d %M";
                    gantt.config.subscales = [
                        {unit: "hour", step: 6, date: "%H"}
                    ];
                    gantt.config.min_column_width = 50;
                    break;
                case "week":
                    gantt.config.scale_unit = "week";
                    gantt.config.step = 1;
                    gantt.config.date_scale = "%d %M";
                    gantt.config.subscales = [
                        {unit: "day", step: 1, date: "%D"}
                    ];
                    gantt.config.min_column_width = 30;
                    break;
                case "month":
                    gantt.config.scale_unit = "month";
                    gantt.config.step = 1;
                    gantt.config.date_scale = "%M %Y";
                    gantt.config.subscales = [
                        {unit: "week", step: 1, date: "%d %M"}
                    ];
                    gantt.config.min_column_width = 80;
                    break;
                case "quarter":
                    gantt.config.scale_unit = "month";
                    gantt.config.step = 3;
                    gantt.config.date_scale = "%M %Y";
                    gantt.config.subscales = [
                        {unit: "month", step: 1, date: "%M"}
                    ];
                    gantt.config.min_column_width = 80;
                    break;
                case "year":
                    gantt.config.scale_unit = "year";
                    gantt.config.step = 1;
                    gantt.config.date_scale = "%Y";
                    gantt.config.subscales = [
                        {unit: "month", step: 1, date: "%M"}
                    ];
                    gantt.config.min_column_width = 30;
                    break;
            }
            gantt.render();
        }
        
        // تصدير المخطط
        $("#exportPDF").click(function() {
            gantt.exportToPDF({
                name: "مخطط_جانت_{{ $installationProject->project_number }}.pdf",
                header: "<h3>مخطط جانت للمشروع: {{ $installationProject->title }}</h3>",
                footer: "تم إنشاؤه في: " + new Date().toLocaleDateString(),
                locale: "ar",
                raw: true
            });
        });
        
        $("#exportPNG").click(function() {
            gantt.exportToPNG({
                name: "مخطط_جانت_{{ $installationProject->project_number }}.png",
                header: "<h3>مخطط جانت للمشروع: {{ $installationProject->title }}</h3>",
                footer: "تم إنشاؤه في: " + new Date().toLocaleDateString(),
                locale: "ar",
                raw: true
            });
        });
        
        // حفظ التغييرات في المهام
        gantt.attachEvent("onAfterTaskUpdate", function(id, task) {
            var taskId = id.replace("task_", "");
            
            $.ajax({
                url: "{{ route('installation-projects.gantt.update-task', $installationProject->id) }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    task_id: taskId,
                    start_date: gantt.templates.format_date(task.start_date),
                    due_date: gantt.templates.format_date(task.end_date),
                    progress: Math.round(task.progress * 100)
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success('تم تحديث المهمة بنجاح');
                    } else {
                        toastr.error('حدث خطأ أثناء تحديث المهمة');
                        gantt.refreshData();
                    }
                },
                error: function() {
                    toastr.error('حدث خطأ أثناء تحديث المهمة');
                    gantt.refreshData();
                }
            });
        });
        
        // إضافة اعتمادية بين المهام
        $("#dependencyForm").submit(function(e) {
            e.preventDefault();
            
            var taskId = $("#task_id").val();
            var dependencyTaskId = $("#dependency_task_id").val();
            var dependencyType = $("#dependency_type").val();
            var lagDays = $("#lag_days").val();
            
            if (taskId === dependencyTaskId) {
                toastr.error('لا يمكن إضافة اعتمادية للمهمة على نفسها');
                return;
            }
            
            $.ajax({
                url: "{{ route('installation-projects.gantt.add-dependency', $installationProject->id) }}",
                method: "POST",
                data: {
                    _token: "{{ csrf_token() }}",
                    task_id: taskId,
                    dependency_task_id: dependencyTaskId,
                    dependency_type: dependencyType,
                    lag_days: lagDays
                },
                success: function(response) {
                    if (response.success) {
                        toastr.success('تم إضافة الاعتمادية بنجاح');
                        
                        // تحديد نوع الاعتمادية
                        var linkType = 0; // finish_to_start (default)
                        switch (dependencyType) {
                            case 'start_to_start':
                                linkType = 1;
                                break;
                            case 'finish_to_finish':
                                linkType = 2;
                                break;
                            case 'start_to_finish':
                                linkType = 3;
                                break;
                        }
                        
                        // إضافة الاعتمادية للمخطط
                        gantt.addLink({
                            id: response.dependency_id,
                            source: "task_" + dependencyTaskId,
                            target: "task_" + taskId,
                            type: linkType
                        });
                        
                        // إعادة تعيين النموذج
                        $("#dependencyForm")[0].reset();
                    } else {
                        toastr.error(response.error || 'حدث خطأ أثناء إضافة الاعتمادية');
                    }
                },
                error: function(xhr) {
                    var errors = xhr.responseJSON.error;
                    if (errors) {
                        var errorMessage = '';
                        $.each(errors, function(key, value) {
                            errorMessage += value + '<br>';
                        });
                        toastr.error(errorMessage);
                    } else {
                        toastr.error('حدث خطأ أثناء إضافة الاعتمادية');
                    }
                }
            });
        });
        
        // حذف اعتمادية
        gantt.attachEvent("onLinkDblClick", function(id) {
            if (confirm("هل أنت متأكد من حذف هذه الاعتمادية؟")) {
                $.ajax({
                    url: "{{ route('installation-projects.gantt.remove-dependency', $installationProject->id) }}",
                    method: "DELETE",
                    data: {
                        _token: "{{ csrf_token() }}",
                        dependency_id: id
                    },
                    success: function(response) {
                        if (response.success) {
                            toastr.success('تم حذف الاعتمادية بنجاح');
                            gantt.deleteLink(id);
                        } else {
                            toastr.error(response.error || 'حدث خطأ أثناء حذف الاعتمادية');
                        }
                    },
                    error: function() {
                        toastr.error('حدث خطأ أثناء حذف الاعتمادية');
                    }
                });
            }
            return false;
        });
        
        // تعيين المقياس الافتراضي
        setScale("week");
    });
</script>
@endsection