@extends('layouts.modern')

@section('title', 'مخطط جانت للمشروع - ' . $project->title)

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>مخطط جانت للمشروع</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $project->id) }}">{{ $project->title }}</a></li>
                        <li class="breadcrumb-item active">مخطط جانت</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-chart-bar"></i>
                                مخطط جانت للمشروع: {{ $project->title }}
                            </h3>
                            <div class="card-tools">
                                <a href="{{ route('installation-projects.dashboard', $project->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-tachometer-alt"></i> لوحة التحكم
                                </a>
                                <a href="{{ route('installation-projects.show', $project->id) }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-eye"></i> عرض التفاصيل
                                </a>
                            </div>
                        </div>
                        <div class="card-body">
                            <div id="gantt-chart" style="height: 600px;"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="{{ asset('css/installation-projects.css') }}">
<link rel="stylesheet" href="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.css">
<style>
    .gantt-container {
        height: 600px;
        width: 100%;
    }
    .weekend {
        background: #f4f7f4;
    }
    .gantt_selected .weekend {
        background: #f7eb91;
    }
    .project-phase .gantt_task_progress {
        background-color: #65c16f;
    }
    .project-task .gantt_task_progress {
        background-color: #4b8e54;
    }
    .milestone .gantt_task_progress {
        background-color: #ff9800;
    }
    .critical .gantt_task_progress {
        background-color: #e91e63;
    }
</style>
@endpush

@push('scripts')
<script src="https://cdn.dhtmlx.com/gantt/edge/dhtmlxgantt.js"></script>
<script>
    $(function () {
        // تهيئة مخطط جانت
        gantt.config.date_format = "%Y-%m-%d %H:%i";
        gantt.config.scale_unit = "week";
        gantt.config.date_scale = "%d %M";
        gantt.config.subscales = [
            {unit: "day", step: 1, date: "%D"}
        ];
        gantt.config.scale_height = 60;
        gantt.config.row_height = 30;
        gantt.config.task_height = 16;
        gantt.config.readonly = true;
        
        // تحديد عطلة نهاية الأسبوع
        gantt.templates.scale_cell_class = function(date) {
            if(date.getDay() === 5 || date.getDay() === 6) {
                return "weekend";
            }
        };
        gantt.templates.task_cell_class = function(item, date) {
            if(date.getDay() === 5 || date.getDay() === 6) {
                return "weekend";
            }
        };
        
        // تخصيص مظهر المهام
        gantt.templates.task_class = function(start, end, task) {
            if(task.type === 'milestone') {
                return "milestone";
            } else if(task.type === 'phase') {
                return "project-phase";
            } else if(task.critical) {
                return "critical";
            } else {
                return "project-task";
            }
        };
        
        // تخصيص النص المعروض
        gantt.templates.task_text = function(start, end, task) {
            return task.text + (task.progress ? " (" + Math.round(task.progress * 100) + "%)" : "");
        };
        
        // تهيئة الأعمدة
        gantt.config.columns = [
            {name: "text", label: "المهمة", tree: true, width: 200},
            {name: "start_date", label: "تاريخ البدء", align: "center", width: 100},
            {name: "duration", label: "المدة", align: "center", width: 60},
            {name: "progress", label: "التقدم", align: "center", width: 80, template: function(obj) {
                return Math.round(obj.progress * 100) + "%";
            }}
        ];
        
        // تهيئة مخطط جانت
        gantt.init("gantt-chart");
        
        // تحميل البيانات
        gantt.parse({
            data: @json($ganttData)
        });
    });
</script>
@endpush