@extends('layouts.app')

@section('title', 'تفاصيل المصعد')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>تفاصيل المصعد</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.elevators.index', $installationProject->id) }}">مصاعد المشروع</a></li>
                        <li class="breadcrumb-item active">تفاصيل المصعد</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-elevator"></i>
                                معلومات المصعد
                            </h3>
                            <div class="card-tools">
                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                <a href="{{ route('installation-projects.elevators.edit', [$installationProject->id, $projectElevator->id]) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-edit"></i> تعديل
                                </a>
                                <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal">
                                    <i class="fas fa-trash"></i> حذف
                                </button>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-tag"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">نوع المصعد</span>
                                            <span class="info-box-number">
                                                @switch($projectElevator->elevator_type)
                                                    @case('passenger')
                                                        مصعد ركاب
                                                        @break
                                                    @case('freight')
                                                        مصعد بضائع
                                                        @break
                                                    @case('hospital')
                                                        مصعد مستشفى
                                                        @break
                                                    @case('panoramic')
                                                        مصعد بانورامي
                                                        @break
                                                    @default
                                                        أخرى
                                                @endswitch
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-success"><i class="fas fa-check-circle"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الحالة</span>
                                            <span class="info-box-number">
                                                @switch($projectElevator->status)
                                                    @case('pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                        @break
                                                    @case('ordered')
                                                        <span class="badge badge-info">تم الطلب</span>
                                                        @break
                                                    @case('delivered')
                                                        <span class="badge badge-primary">تم التسليم</span>
                                                        @break
                                                    @case('installed')
                                                        <span class="badge badge-secondary">تم التركيب</span>
                                                        @break
                                                    @case('tested')
                                                        <span class="badge badge-light">تم الاختبار</span>
                                                        @break
                                                    @case('completed')
                                                        <span class="badge badge-success">مكتمل</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-dark">غير معروف</span>
                                                @endswitch
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">المواصفات الفنية</h3>
                                        </div>
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-md-6">
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <th style="width: 40%">الطراز</th>
                                                            <td>{{ $projectElevator->model }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>الشركة المصنعة</th>
                                                            <td>{{ $projectElevator->manufacturer }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>السعة</th>
                                                            <td>{{ $projectElevator->capacity }} كجم</td>
                                                        </tr>
                                                        <tr>
                                                            <th>عدد الطوابق</th>
                                                            <td>{{ $projectElevator->floors_count }}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                                <div class="col-md-6">
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <th style="width: 40%">السرعة</th>
                                                            <td>{{ $projectElevator->speed }} م/ث</td>
                                                        </tr>
                                                        <tr>
                                                            <th>سعر الوحدة</th>
                                                            <td>{{ number_format($projectElevator->unit_price, 2) }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>تاريخ التسليم المتوقع</th>
                                                            <td>{{ $projectElevator->expected_delivery_date ? $projectElevator->expected_delivery_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>تاريخ التسليم الفعلي</th>
                                                            <td>{{ $projectElevator->actual_delivery_date ? $projectElevator->actual_delivery_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                            
                                            <div class="row mt-3">
                                                <div class="col-md-12">
                                                    <table class="table table-bordered">
                                                        <tr>
                                                            <th style="width: 20%">تاريخ التركيب المتوقع</th>
                                                            <td>{{ $projectElevator->expected_installation_date ? $projectElevator->expected_installation_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>تاريخ التركيب الفعلي</th>
                                                            <td>{{ $projectElevator->actual_installation_date ? $projectElevator->actual_installation_date->format('Y-m-d') : 'غير محدد' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>المواصفات</th>
                                                            <td>{{ $projectElevator->specifications ?: 'لا توجد مواصفات إضافية' }}</td>
                                                        </tr>
                                                        <tr>
                                                            <th>ملاحظات</th>
                                                            <td>{{ $projectElevator->notes ?: 'لا توجد ملاحظات' }}</td>
                                                        </tr>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            @if(isset($checklists) && $checklists->count() > 0)
                            <div class="row mt-4">
                                <div class="col-md-12">
                                    <div class="card">
                                        <div class="card-header">
                                            <h3 class="card-title">قوائم الفحص</h3>
                                        </div>
                                        <div class="card-body">
                                            <div class="accordion" id="checklistAccordion">
                                                @foreach($checklists as $index => $checklist)
                                                <div class="card">
                                                    <div class="card-header" id="heading{{ $index }}">
                                                        <h2 class="mb-0">
                                                            <button class="btn btn-link btn-block text-right" type="button" data-toggle="collapse" data-target="#collapse{{ $index }}" aria-expanded="{{ $index == 0 ? 'true' : 'false' }}" aria-controls="collapse{{ $index }}">
                                                                {{ $checklist->title }} - {{ $checklist->created_at->format('Y-m-d') }}
                                                            </button>
                                                        </h2>
                                                    </div>

                                                    <div id="collapse{{ $index }}" class="collapse {{ $index == 0 ? 'show' : '' }}" aria-labelledby="heading{{ $index }}" data-parent="#checklistAccordion">
                                                        <div class="card-body">
                                                            <table class="table table-bordered">
                                                                <thead>
                                                                    <tr>
                                                                        <th>#</th>
                                                                        <th>البند</th>
                                                                        <th>الحالة</th>
                                                                        <th>ملاحظات</th>
                                                                    </tr>
                                                                </thead>
                                                                <tbody>
                                                                    @foreach($checklist->items as $itemIndex => $item)
                                                                    <tr>
                                                                        <td>{{ $itemIndex + 1 }}</td>
                                                                        <td>{{ $item->description }}</td>
                                                                        <td>
                                                                            @if($item->status == 'passed')
                                                                                <span class="badge badge-success">اجتياز</span>
                                                                            @elseif($item->status == 'failed')
                                                                                <span class="badge badge-danger">فشل</span>
                                                                            @else
                                                                                <span class="badge badge-warning">قيد المراجعة</span>
                                                                            @endif
                                                                        </td>
                                                                        <td>{{ $item->notes ?: '-' }}</td>
                                                                    </tr>
                                                                    @endforeach
                                                                </tbody>
                                                            </table>
                                                        </div>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            @endif
                        </div>
                        <div class="card-footer">
                            <a href="{{ route('installation-projects.elevators.index', $installationProject->id) }}" class="btn btn-secondary">
                                <i class="fas fa-arrow-right"></i> العودة إلى قائمة المصاعد
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>

<!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel" aria-hidden="true">
    <div class="modal-dialog" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="deleteModalLabel">تأكيد الحذف</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                هل أنت متأكد من رغبتك في حذف هذا المصعد؟
            </div>
            <div class="modal-footer">
                <form action="{{ route('installation-projects.elevators.destroy', [$installationProject->id, $projectElevator->id]) }}" method="POST">
                    @csrf
                    @method('DELETE')
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                    <button type="submit" class="btn btn-danger">حذف</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection