@extends('layouts.app')

@section('title', 'مصاعد المشروع')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>مصاعد المشروع: {{ $installationProject->title }}</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                        <li class="breadcrumb-item active">مصاعد المشروع</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-elevator"></i>
                                قائمة المصاعد في المشروع
                            </h3>
                            <div class="card-tools">
                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                <a href="{{ route('installation-projects.elevators.create', $installationProject->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة مصعد جديد
                                </a>
                                @endif
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            @if($elevators->count() > 0)
                            <div class="table-responsive">
                                <table class="table table-bordered table-striped">
                                    <thead>
                                        <tr>
                                            <th>#</th>
                                            <th>النوع</th>
                                            <th>الطراز</th>
                                            <th>الشركة المصنعة</th>
                                            <th>السعة</th>
                                            <th>عدد الطوابق</th>
                                            <th>السرعة</th>
                                            <th>السعر</th>
                                            <th>الحالة</th>
                                            <th>الإجراءات</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($elevators as $index => $elevator)
                                        <tr>
                                            <td>{{ $index + 1 }}</td>
                                            <td>
                                                @switch($elevator->elevator_type)
                                                    @case('passenger')
                                                        مصعد ركاب
                                                        @break
                                                    @case('freight')
                                                        مصعد بضائع
                                                        @break
                                                    @case('hospital')
                                                        مصعد مستشفى
                                                        @break
                                                    @case('panoramic')
                                                        مصعد بانورامي
                                                        @break
                                                    @default
                                                        أخرى
                                                @endswitch
                                            </td>
                                            <td>{{ $elevator->model }}</td>
                                            <td>{{ $elevator->manufacturer }}</td>
                                            <td>{{ $elevator->capacity }} كجم</td>
                                            <td>{{ $elevator->floors_count }}</td>
                                            <td>{{ $elevator->speed }} م/ث</td>
                                            <td>{{ number_format($elevator->unit_price, 2) }}</td>
                                            <td>
                                                @switch($elevator->status)
                                                    @case('pending')
                                                        <span class="badge badge-warning">قيد الانتظار</span>
                                                        @break
                                                    @case('ordered')
                                                        <span class="badge badge-info">تم الطلب</span>
                                                        @break
                                                    @case('delivered')
                                                        <span class="badge badge-primary">تم التسليم</span>
                                                        @break
                                                    @case('installed')
                                                        <span class="badge badge-secondary">تم التركيب</span>
                                                        @break
                                                    @case('tested')
                                                        <span class="badge badge-light">تم الاختبار</span>
                                                        @break
                                                    @case('completed')
                                                        <span class="badge badge-success">مكتمل</span>
                                                        @break
                                                    @default
                                                        <span class="badge badge-dark">غير معروف</span>
                                                @endswitch
                                            </td>
                                            <td>
                                                <div class="btn-group">
                                                    <a href="{{ route('installation-projects.elevators.show', [$installationProject->id, $elevator->id]) }}" class="btn btn-info btn-sm" title="عرض التفاصيل">
                                                        <i class="fas fa-eye"></i>
                                                    </a>
                                                    @if(auth()->user()->hasPermission('edit_installation_project'))
                                                    <a href="{{ route('installation-projects.elevators.edit', [$installationProject->id, $elevator->id]) }}" class="btn btn-primary btn-sm" title="تعديل">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="btn btn-danger btn-sm" data-toggle="modal" data-target="#deleteModal{{ $elevator->id }}" title="حذف">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                    @endif
                                                </div>
                                                
                                                <!-- Modal -->
                                                <div class="modal fade" id="deleteModal{{ $elevator->id }}" tabindex="-1" role="dialog" aria-labelledby="deleteModalLabel{{ $elevator->id }}" aria-hidden="true">
                                                    <div class="modal-dialog" role="document">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title" id="deleteModalLabel{{ $elevator->id }}">تأكيد الحذف</h5>
                                                                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                    <span aria-hidden="true">&times;</span>
                                                                </button>
                                                            </div>
                                                            <div class="modal-body">
                                                                هل أنت متأكد من رغبتك في حذف هذا المصعد؟
                                                            </div>
                                                            <div class="modal-footer">
                                                                <form action="{{ route('installation-projects.elevators.destroy', [$installationProject->id, $elevator->id]) }}" method="POST">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button" class="btn btn-secondary" data-dismiss="modal">إلغاء</button>
                                                                    <button type="submit" class="btn btn-danger">حذف</button>
                                                                </form>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </td>
                                        </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                            <div class="mt-4">
                                {{ $elevators->links() }}
                            </div>
                            @else
                            <div class="alert alert-info">
                                لا توجد مصاعد مضافة لهذا المشروع بعد.
                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                <a href="{{ route('installation-projects.elevators.create', $installationProject->id) }}" class="btn btn-primary btn-sm ml-2">
                                    <i class="fas fa-plus"></i> إضافة مصعد جديد
                                </a>
                                @endif
                            </div>
                            @endif
                        </div>
                        <!-- /.card-body -->
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection