@extends('layouts.app')

@section('title', 'تعديل مصعد المشروع')

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>تعديل مصعد المشروع</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $installationProject->id) }}">{{ $installationProject->title }}</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.elevators.index', $installationProject->id) }}">مصاعد المشروع</a></li>
                        <li class="breadcrumb-item active">تعديل مصعد</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-12">
                    <div class="card card-primary">
                        <div class="card-header">
                            <h3 class="card-title">بيانات المصعد</h3>
                        </div>
                        <!-- /.card-header -->
                        <!-- form start -->
                        <form method="POST" action="{{ route('installation-projects.elevators.update', [$installationProject->id, $projectElevator->id]) }}">
                            @csrf
                            @method('PUT')
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="elevator_type">نوع المصعد <span class="text-danger">*</span></label>
                                            <select class="form-control @error('elevator_type') is-invalid @enderror" id="elevator_type" name="elevator_type" required>
                                                <option value="">-- اختر نوع المصعد --</option>
                                                <option value="passenger" {{ old('elevator_type', $projectElevator->elevator_type) == 'passenger' ? 'selected' : '' }}>مصعد ركاب</option>
                                                <option value="freight" {{ old('elevator_type', $projectElevator->elevator_type) == 'freight' ? 'selected' : '' }}>مصعد بضائع</option>
                                                <option value="hospital" {{ old('elevator_type', $projectElevator->elevator_type) == 'hospital' ? 'selected' : '' }}>مصعد مستشفى</option>
                                                <option value="panoramic" {{ old('elevator_type', $projectElevator->elevator_type) == 'panoramic' ? 'selected' : '' }}>مصعد بانورامي</option>
                                                <option value="other" {{ old('elevator_type', $projectElevator->elevator_type) == 'other' ? 'selected' : '' }}>أخرى</option>
                                            </select>
                                            @error('elevator_type')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="model">الطراز <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('model') is-invalid @enderror" id="model" name="model" value="{{ old('model', $projectElevator->model) }}" required>
                                            @error('model')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="manufacturer">الشركة المصنعة <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control @error('manufacturer') is-invalid @enderror" id="manufacturer" name="manufacturer" value="{{ old('manufacturer', $projectElevator->manufacturer) }}" required>
                                            @error('manufacturer')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="capacity">السعة (كجم) <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control @error('capacity') is-invalid @enderror" id="capacity" name="capacity" value="{{ old('capacity', $projectElevator->capacity) }}" min="1" required>
                                            @error('capacity')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="floors_count">عدد الطوابق <span class="text-danger">*</span></label>
                                            <input type="number" class="form-control @error('floors_count') is-invalid @enderror" id="floors_count" name="floors_count" value="{{ old('floors_count', $projectElevator->floors_count) }}" min="2" required>
                                            @error('floors_count')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="speed">السرعة (م/ث) <span class="text-danger">*</span></label>
                                            <input type="number" step="0.1" class="form-control @error('speed') is-invalid @enderror" id="speed" name="speed" value="{{ old('speed', $projectElevator->speed) }}" min="0.1" required>
                                            @error('speed')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="unit_price">سعر الوحدة <span class="text-danger">*</span></label>
                                            <input type="number" step="0.01" class="form-control @error('unit_price') is-invalid @enderror" id="unit_price" name="unit_price" value="{{ old('unit_price', $projectElevator->unit_price) }}" min="0" required>
                                            @error('unit_price')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="status">الحالة <span class="text-danger">*</span></label>
                                            <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                                <option value="">-- اختر الحالة --</option>
                                                <option value="pending" {{ old('status', $projectElevator->status) == 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                                                <option value="ordered" {{ old('status', $projectElevator->status) == 'ordered' ? 'selected' : '' }}>تم الطلب</option>
                                                <option value="delivered" {{ old('status', $projectElevator->status) == 'delivered' ? 'selected' : '' }}>تم التسليم</option>
                                                <option value="installed" {{ old('status', $projectElevator->status) == 'installed' ? 'selected' : '' }}>تم التركيب</option>
                                                <option value="tested" {{ old('status', $projectElevator->status) == 'tested' ? 'selected' : '' }}>تم الاختبار</option>
                                                <option value="completed" {{ old('status', $projectElevator->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                            </select>
                                            @error('status')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="expected_delivery_date">تاريخ التسليم المتوقع</label>
                                            <input type="date" class="form-control @error('expected_delivery_date') is-invalid @enderror" id="expected_delivery_date" name="expected_delivery_date" value="{{ old('expected_delivery_date', $projectElevator->expected_delivery_date ? $projectElevator->expected_delivery_date->format('Y-m-d') : '') }}">
                                            @error('expected_delivery_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="actual_delivery_date">تاريخ التسليم الفعلي</label>
                                            <input type="date" class="form-control @error('actual_delivery_date') is-invalid @enderror" id="actual_delivery_date" name="actual_delivery_date" value="{{ old('actual_delivery_date', $projectElevator->actual_delivery_date ? $projectElevator->actual_delivery_date->format('Y-m-d') : '') }}">
                                            @error('actual_delivery_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="expected_installation_date">تاريخ التركيب المتوقع</label>
                                            <input type="date" class="form-control @error('expected_installation_date') is-invalid @enderror" id="expected_installation_date" name="expected_installation_date" value="{{ old('expected_installation_date', $projectElevator->expected_installation_date ? $projectElevator->expected_installation_date->format('Y-m-d') : '') }}">
                                            @error('expected_installation_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="actual_installation_date">تاريخ التركيب الفعلي</label>
                                            <input type="date" class="form-control @error('actual_installation_date') is-invalid @enderror" id="actual_installation_date" name="actual_installation_date" value="{{ old('actual_installation_date', $projectElevator->actual_installation_date ? $projectElevator->actual_installation_date->format('Y-m-d') : '') }}">
                                            @error('actual_installation_date')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="specifications">المواصفات</label>
                                    <textarea class="form-control @error('specifications') is-invalid @enderror" id="specifications" name="specifications" rows="3">{{ old('specifications', $projectElevator->specifications) }}</textarea>
                                    @error('specifications')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>

                                <div class="form-group">
                                    <label for="notes">ملاحظات</label>
                                    <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $projectElevator->notes) }}</textarea>
                                    @error('notes')
                                        <span class="invalid-feedback" role="alert">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                            </div>
                            <!-- /.card-body -->

                            <div class="card-footer">
                                <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                <a href="{{ route('installation-projects.elevators.show', [$installationProject->id, $projectElevator->id]) }}" class="btn btn-secondary">إلغاء</a>
                            </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
            </div>
        </div>
    </section>
</div>
@endsection