@extends('layouts.modern')

@section('title', 'لوحة تحكم المشروع - ' . $project->title)

@section('content')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>لوحة تحكم المشروع</h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-left">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('installation-projects.show', $project->id) }}">{{ $project->title }}</a></li>
                        <li class="breadcrumb-item active">لوحة التحكم</li>
                    </ol>
                </div>
            </div>
        </div>
    </section>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- معلومات المشروع الأساسية -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-project-diagram"></i>
                                {{ $project->title }}
                            </h3>
                            <div class="card-tools">
                                <a href="{{ route('installation-projects.show', $project->id) }}" class="btn btn-info btn-sm">
                                    <i class="fas fa-eye"></i> عرض التفاصيل
                                </a>
                                @if(auth()->user()->hasPermission('edit_installation_project'))
                                <a href="{{ route('installation-projects.edit', $project->id) }}" class="btn btn-warning btn-sm">
                                    <i class="fas fa-edit"></i> تعديل
                                </a>
                                @endif
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-3 col-sm-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-primary"><i class="fas fa-calendar-alt"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">تاريخ البدء</span>
                                            <span class="info-box-number">{{ $project->start_date->format('Y-m-d') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-info"><i class="fas fa-calendar-check"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">تاريخ الانتهاء المتوقع</span>
                                            <span class="info-box-number">{{ $project->expected_completion_date->format('Y-m-d') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6">
                                    <div class="info-box">
                                        <span class="info-box-icon {{ $stats['is_overdue'] ? 'bg-danger' : 'bg-success' }}">
                                            <i class="fas fa-hourglass-half"></i>
                                        </span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الأيام المتبقية</span>
                                            <span class="info-box-number">
                                                @if($stats['is_overdue'])
                                                <span class="text-danger">متأخر {{ abs($stats['days_remaining']) }} يوم</span>
                                                @else
                                                {{ $stats['days_remaining'] }} يوم
                                                @endif
                                            </span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-3 col-sm-6">
                                    <div class="info-box">
                                        <span class="info-box-icon bg-warning"><i class="fas fa-money-bill-wave"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الميزانية</span>
                                            <span class="info-box-number">{{ number_format($project->total_budget, 2) }} ريال</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- إحصائيات المشروع -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ $stats['total_elevators'] }}</h3>
                            <p>عدد المصاعد</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-elevator"></i>
                        </div>
                        <a href="{{ route('installation-projects.elevators.index', $project->id) }}" class="small-box-footer">
                            المزيد <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{ $stats['completed_tasks'] }}<sup style="font-size: 20px">/{{ $stats['total_tasks'] }}</sup></h3>
                            <p>المهام المكتملة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-tasks"></i>
                        </div>
                        <a href="#project-tasks" class="small-box-footer">
                            المزيد <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{ $stats['completed_phases'] }}<sup style="font-size: 20px">/{{ $stats['total_phases'] }}</sup></h3>
                            <p>المراحل المكتملة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-project-diagram"></i>
                        </div>
                        <a href="#project-phases" class="small-box-footer">
                            المزيد <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{ $stats['open_issues'] }}</h3>
                            <p>المشكلات المفتوحة</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                        <a href="#project-issues" class="small-box-footer">
                            المزيد <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- إحصائيات الميزات الجديدة -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{ \App\Models\ProjectRisk::where('installation_project_id', $project->id)->count() }}</h3>
                            <p>المخاطر</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-exclamation-triangle"></i>
                        </div>
                        <a href="{{ route('installation-projects.risks.index', $project->id) }}" class="small-box-footer">
                            إدارة المخاطر <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{ \App\Models\ProjectResource::where('installation_project_id', $project->id)->count() }}</h3>
                            <p>الموارد</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-boxes"></i>
                        </div>
                        <a href="{{ route('installation-projects.resources.index', $project->id) }}" class="small-box-footer">
                            إدارة الموارد <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-primary">
                        <div class="inner">
                            <h3>{{ \App\Models\ProjectReport::where('installation_project_id', $project->id)->count() }}</h3>
                            <p>التقارير</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-file-alt"></i>
                        </div>
                        <a href="{{ route('installation-projects.reports.index', $project->id) }}" class="small-box-footer">
                            عرض التقارير <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
                <div class="col-lg-3 col-6">
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{ \App\Models\ProjectTaskDependency::whereIn('task_id', \App\Models\ProjectTask::whereIn('project_phase_id', $project->phases->pluck('id'))->pluck('id'))->count() }}</h3>
                            <p>الاعتماديات</p>
                        </div>
                        <div class="icon">
                            <i class="fas fa-project-diagram"></i>
                        </div>
                        <a href="{{ route('installation-projects.gantt.index', $project->id) }}" class="small-box-footer">
                            مخطط جانت <i class="fas fa-arrow-circle-left"></i>
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- نسبة الإنجاز والميزانية -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">نسبة إنجاز المشروع</h3>
                        </div>
                        <div class="card-body">
                            <div class="progress-group">
                                <span class="progress-text">نسبة الإنجاز الكلية</span>
                                <span class="float-left"><b>{{ $project->calculateProgress() }}%</b></span>
                                <div class="progress progress-lg">
                                    <div class="progress-bar progress-bar-striped progress-bar-animated 
                                        @if($project->calculateProgress() < 30) bg-danger
                                        @elseif($project->calculateProgress() < 70) bg-warning
                                        @else bg-success @endif" 
                                        role="progressbar" 
                                        style="width: {{ $project->calculateProgress() }}%" 
                                        aria-valuenow="{{ $project->calculateProgress() }}" 
                                        aria-valuemin="0" 
                                        aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            
                            @foreach($project->phases->sortBy('order_number') as $phase)
                            <div class="progress-group">
                                <span class="progress-text">{{ $phase->name }}</span>
                                <span class="float-left"><b>{{ $phase->completion_percentage }}%</b></span>
                                <div class="progress">
                                    <div class="progress-bar 
                                        @if($phase->completion_percentage < 30) bg-danger
                                        @elseif($phase->completion_percentage < 70) bg-warning
                                        @else bg-success @endif" 
                                        role="progressbar" 
                                        style="width: {{ $phase->completion_percentage }}%" 
                                        aria-valuenow="{{ $phase->completion_percentage }}" 
                                        aria-valuemin="0" 
                                        aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            @endforeach
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">ملخص الميزانية</h3>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="info-box bg-gradient-success">
                                        <span class="info-box-icon"><i class="fas fa-money-bill-alt"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">الميزانية الإجمالية</span>
                                            <span class="info-box-number">{{ number_format($project->total_budget, 2) }} ريال</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box bg-gradient-warning">
                                        <span class="info-box-icon"><i class="fas fa-shopping-cart"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">المصروفات</span>
                                            <span class="info-box-number">{{ number_format($stats['total_cost'], 2) }} ريال</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="progress-group mt-3">
                                @php
                                    // Calculate budget usage percentage
                                    $budgetUsage = $project->total_budget > 0 
                                        ? round(($stats['total_cost'] / $project->total_budget) * 100) 
                                        : 0;
                                @endphp
                                <span class="progress-text">استهلاك الميزانية</span>
                                <span class="float-left"><b>{{ $budgetUsage }}%</b></span>
                                <div class="progress progress-lg">
                                    <div class="progress-bar progress-bar-striped 
                                        @if($budgetUsage > 90) bg-danger
                                        @elseif($budgetUsage > 70) bg-warning
                                        @else bg-success @endif" 
                                        role="progressbar" 
                                        style="width: {{ $budgetUsage }}%" 
                                        aria-valuenow="{{ $budgetUsage }}" 
                                        aria-valuemin="0" 
                                        aria-valuemax="100">
                                    </div>
                                </div>
                            </div>
                            
                            <div class="row mt-3">
                                <div class="col-md-6">
                                    <div class="info-box bg-gradient-info">
                                        <span class="info-box-icon"><i class="fas fa-credit-card"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">المدفوعات</span>
                                            <span class="info-box-number">{{ number_format($stats['total_payments'], 2) }} ريال</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="info-box bg-gradient-danger">
                                        <span class="info-box-icon"><i class="fas fa-balance-scale"></i></span>
                                        <div class="info-box-content">
                                            <span class="info-box-text">المتبقي من الميزانية</span>
                                            <span class="info-box-number">{{ number_format($stats['remaining_budget'], 2) }} ريال</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- المهام العاجلة والمشكلات -->
            <div class="row">
                <div class="col-md-6">
                    <div class="card" id="project-tasks">
                        <div class="card-header">
                            <h3 class="card-title">المهام القادمة</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <ul class="todo-list" data-widget="todo-list">
                                @php
                                    $upcomingTasks = $project->phases->flatMap->tasks
                                        ->where('status', '!=', 'completed')
                                        ->where('status', '!=', 'cancelled')
                                        ->sortBy('due_date')
                                        ->take(5);
                                @endphp
                                
                                @forelse($upcomingTasks as $task)
                                <li>
                                    <span class="handle">
                                        <i class="fas fa-ellipsis-v"></i>
                                        <i class="fas fa-ellipsis-v"></i>
                                    </span>
                                    <div class="icheck-primary d-inline ml-2">
                                        <input type="checkbox" value="" name="todo{{ $task->id }}" id="todoCheck{{ $task->id }}" {{ $task->completion_percentage == 100 ? 'checked' : '' }} disabled>
                                        <label for="todoCheck{{ $task->id }}"></label>
                                    </div>
                                    <span class="text">{{ $task->name }}</span>
                                    <small class="badge badge-{{ $task->isOverdue() ? 'danger' : 'info' }}">
                                        <i class="far fa-clock"></i> 
                                        {{ $task->due_date->format('Y-m-d') }}
                                        @if($task->isOverdue())
                                        (متأخر)
                                        @endif
                                    </small>
                                    <div class="tools">
                                        <a href="#" title="عرض"><i class="fas fa-eye"></i></a>
                                    </div>
                                </li>
                                @empty
                                <li class="text-center py-3">
                                    <span class="text-muted">لا توجد مهام قادمة</span>
                                </li>
                                @endforelse
                            </ul>
                        </div>
                        <div class="card-footer clearfix">
                            <a href="{{ route('installation-projects.phases.index', $project->id) }}" class="btn btn-primary float-left">
                                <i class="fas fa-tasks"></i> عرض جميع المهام
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-6">
                    <div class="card" id="project-issues">
                        <div class="card-header">
                            <h3 class="card-title">المشكلات المفتوحة</h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body p-0">
                            <ul class="list-group list-group-flush">
                                @forelse($project->issues->where('status', '!=', 'resolved')->take(5) as $issue)
                                <li class="list-group-item">
                                    <div class="d-flex justify-content-between align-items-center">
                                        <div>
                                            <span class="badge badge-{{ $issue->priority == 'high' ? 'danger' : ($issue->priority == 'medium' ? 'warning' : 'info') }} mr-2">
                                                {{ $issue->priority == 'high' ? 'عالي' : ($issue->priority == 'medium' ? 'متوسط' : 'منخفض') }}
                                            </span>
                                            <span>{{ $issue->title }}</span>
                                        </div>
                                        <div>
                                            <small class="text-muted">{{ $issue->created_at->format('Y-m-d') }}</small>
                                            <a href="#" class="btn btn-xs btn-info ml-2">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                        </div>
                                    </div>
                                </li>
                                @empty
                                <li class="list-group-item text-center">
                                    <span class="text-muted">لا توجد مشكلات مفتوحة</span>
                                </li>
                                @endforelse
                            </ul>
                        </div>
                        <div class="card-footer clearfix">
                            <a href="{{ route('installation-projects.show', $project->id) }}#issues" class="btn btn-danger float-left">
                                <i class="fas fa-exclamation-triangle"></i> عرض جميع المشكلات
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- مراحل المشروع -->
            <div class="row">
                <div class="col-md-12">
                    <div class="card" id="project-phases">
                        <div class="card-header">
                            <h3 class="card-title">مراحل المشروع</h3>
                            <div class="card-tools">
                                @if(auth()->user()->hasPermission('add_project_phase'))
                                <a href="{{ route('installation-projects.phases.create', $project->id) }}" class="btn btn-primary btn-sm">
                                    <i class="fas fa-plus"></i> إضافة مرحلة
                                </a>
                                @endif
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="timeline">
                                @foreach($project->phases->sortBy('order_number') as $phase)
                                <div class="time-label">
                                    <span class="bg-{{ $phase->status == 'completed' ? 'success' : ($phase->status == 'in_progress' ? 'primary' : ($phase->status == 'delayed' ? 'warning' : 'secondary')) }}">
                                        {{ $phase->start_date->format('Y-m-d') }}
                                    </span>
                                </div>
                                <div>
                                    <i class="fas fa-project-diagram bg-{{ $phase->status == 'completed' ? 'success' : ($phase->status == 'in_progress' ? 'primary' : ($phase->status == 'delayed' ? 'warning' : 'secondary')) }}"></i>
                                    <div class="timeline-item">
                                        <span class="time"><i class="fas fa-clock"></i> {{ $phase->end_date->format('Y-m-d') }}</span>
                                        <h3 class="timeline-header">
                                            <a href="{{ route('installation-projects.phases.show', [$project->id, $phase->id]) }}">{{ $phase->name }}</a>
                                        </h3>
                                        <div class="timeline-body">
                                            <div class="row">
                                                <div class="col-md-8">
                                                    <p>{{ Str::limit($phase->description, 150) }}</p>
                                                    <div class="progress">
                                                        <div class="progress-bar 
                                                            @if($phase->completion_percentage < 30) bg-danger
                                                            @elseif($phase->completion_percentage < 70) bg-warning
                                                            @else bg-success @endif" 
                                                            role="progressbar" 
                                                            style="width: {{ $phase->completion_percentage }}%" 
                                                            aria-valuenow="{{ $phase->completion_percentage }}" 
                                                            aria-valuemin="0" 
                                                            aria-valuemax="100">
                                                            {{ $phase->completion_percentage }}%
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="col-md-4">
                                                    <div class="info-box bg-light">
                                                        <div class="info-box-content">
                                                            <span class="info-box-text text-center text-muted">المهام</span>
                                                            <span class="info-box-number text-center text-muted mb-0">
                                                                {{ $phase->tasks->where('status', 'completed')->count() }}/{{ $phase->tasks->count() }}
                                                            </span>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="timeline-footer">
                                            <a href="{{ route('installation-projects.phases.show', [$project->id, $phase->id]) }}" class="btn btn-primary btn-sm">عرض التفاصيل</a>
                                            @if(auth()->user()->hasPermission('edit_project_phase'))
                                            <a href="{{ route('installation-projects.phases.edit', [$project->id, $phase->id]) }}" class="btn btn-warning btn-sm">تعديل</a>
                                            @endif
                                            @if(auth()->user()->hasPermission('add_project_task'))
                                            <a href="{{ route('installation-projects.phases.tasks.create', [$project->id, $phase->id]) }}" class="btn btn-info btn-sm">إضافة مهمة</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                                @endforeach
                                <div>
                                    <i class="fas fa-clock bg-gray"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@endsection

@push('styles')
<link rel="stylesheet" href="{{ asset('css/installation-projects.css') }}">
<style>
    .timeline > div > i {
        font-size: 16px;
        line-height: 30px;
    }
</style>
@endpush

@push('scripts')
<script>
    $(function () {
        // تفعيل التوست للرسائل
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        
        // عرض رسائل النجاح
        @if(session('success'))
        Toast.fire({
            icon: 'success',
            title: '{{ session("success") }}'
        });
        @endif
        
        // عرض رسائل الخطأ
        @if(session('error'))
        Toast.fire({
            icon: 'error',
            title: '{{ session("error") }}'
        });
        @endif
    });
</script>
@endpush