@extends('layouts.modern')

@section('title', 'إضافة مشروع تركيب جديد')

@section('content')
<!-- Content Header (Page header) -->
<section class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>إضافة مشروع تركيب جديد</h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">الرئيسية</a></li>
                    <li class="breadcrumb-item"><a href="{{ route('installation-projects.index') }}">مشاريع التركيب</a></li>
                    <li class="breadcrumb-item active">إضافة مشروع جديد</li>
                </ol>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card card-primary">
                    <div class="card-header">
                        <h3 class="card-title">بيانات المشروع</h3>
                    </div>
                    <!-- /.card-header -->
                    <!-- form start -->
                    <form action="{{ route('installation-projects.store') }}" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="row">
                                <!-- معلومات المشروع الأساسية -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="project_number">رقم المشروع <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="project_number" value="{{ $projectNumber ?? '' }}" readonly>
                                        <small class="text-muted">سيتم إنشاء رقم المشروع تلقائيًا</small>
                                    </div>
                                    <div class="form-group">
                                        <label for="title">عنوان المشروع <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control @error('title') is-invalid @enderror" id="title" name="title" value="{{ old('title') }}" required>
                                        @error('title')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="description">وصف المشروع</label>
                                        <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description') }}</textarea>
                                        @error('description')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <!-- معلومات العميل والموقع -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="customer_id">العميل <span class="text-danger">*</span></label>
                                        <select class="form-control select2 @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id" required>
                                            <option value="">-- اختر العميل --</option>
                                            @foreach($customers as $customer)
                                                <option value="{{ $customer->id }}" {{ old('customer_id') == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('customer_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="location_id">الموقع <span class="text-danger">*</span></label>
                                        <select class="form-control select2 @error('location_id') is-invalid @enderror" id="location_id" name="location_id" required>
                                            <option value="">-- اختر الموقع --</option>
                                            @foreach($locations as $location)
                                                <option value="{{ $location->id }}" {{ old('location_id') == $location->id ? 'selected' : '' }}>{{ $location->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('location_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="branch_id">الفرع <span class="text-danger">*</span></label>
                                        <select class="form-control select2 @error('branch_id') is-invalid @enderror" id="branch_id" name="branch_id" required>
                                            <option value="">-- اختر الفرع --</option>
                                            @foreach($branches as $branch)
                                                <option value="{{ $branch->id }}" {{ old('branch_id') == $branch->id ? 'selected' : '' }}>{{ $branch->name }}</option>
                                            @endforeach
                                        </select>
                                        @error('branch_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <!-- معلومات التواريخ والميزانية -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="start_date">تاريخ البدء <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control @error('start_date') is-invalid @enderror" id="start_date" name="start_date" value="{{ old('start_date', date('Y-m-d')) }}" required>
                                        @error('start_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="expected_completion_date">تاريخ الانتهاء المتوقع <span class="text-danger">*</span></label>
                                        <input type="date" class="form-control @error('expected_completion_date') is-invalid @enderror" id="expected_completion_date" name="expected_completion_date" value="{{ old('expected_completion_date') }}" required>
                                        @error('expected_completion_date')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="total_budget">الميزانية الإجمالية <span class="text-danger">*</span></label>
                                        <div class="input-group">
                                            <input type="number" step="0.01" min="0" class="form-control @error('total_budget') is-invalid @enderror" id="total_budget" name="total_budget" value="{{ old('total_budget', 0) }}" required>
                                            <div class="input-group-append">
                                                <span class="input-group-text">ريال</span>
                                            </div>
                                            @error('total_budget')
                                                <span class="invalid-feedback" role="alert">
                                                    <strong>{{ $message }}</strong>
                                                </span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- معلومات الحالة والمدير -->
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label for="status">حالة المشروع <span class="text-danger">*</span></label>
                                        <select class="form-control @error('status') is-invalid @enderror" id="status" name="status" required>
                                            <option value="draft" {{ old('status') == 'draft' ? 'selected' : '' }}>مسودة</option>
                                            <option value="planning" {{ old('status') == 'planning' ? 'selected' : '' }}>تخطيط</option>
                                            <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                            <option value="on_hold" {{ old('status') == 'on_hold' ? 'selected' : '' }}>متوقف مؤقتاً</option>
                                            <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                            <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                        </select>
                                        @error('status')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="payment_status">حالة الدفع <span class="text-danger">*</span></label>
                                        <select class="form-control @error('payment_status') is-invalid @enderror" id="payment_status" name="payment_status" required>
                                            <option value="not_started" {{ old('payment_status') == 'not_started' ? 'selected' : '' }}>لم يبدأ</option>
                                            <option value="partially_paid" {{ old('payment_status') == 'partially_paid' ? 'selected' : '' }}>مدفوع جزئياً</option>
                                            <option value="fully_paid" {{ old('payment_status') == 'fully_paid' ? 'selected' : '' }}>مدفوع بالكامل</option>
                                        </select>
                                        @error('payment_status')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                    <div class="form-group">
                                        <label for="project_manager_id">مدير المشروع <span class="text-danger">*</span></label>
                                        <select class="form-control select2 @error('project_manager_id') is-invalid @enderror" id="project_manager_id" name="project_manager_id" required>
                                            <option value="">-- اختر مدير المشروع --</option>
                                            @foreach($projectManagers as $manager)
                                                <option value="{{ $manager->id }}" {{ old('project_manager_id') == $manager->id ? 'selected' : '' }}>{{ $manager->name }}</option>
                                            @endforeach
                                        </select>
                                        <small class="text-muted">يجب تحديد مدير المشروع</small>
                                        @error('project_manager_id')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                
                                <!-- ملاحظات إضافية -->
                                <div class="col-md-12">
                                    <div class="form-group">
                                        <label for="notes">ملاحظات</label>
                                        <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                                        @error('notes')
                                            <span class="invalid-feedback" role="alert">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-body -->

                        <div class="card-footer">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('installation-projects.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                        </form>
                    </div>
                    <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection

@push('styles')
<link rel="stylesheet" href="{{ asset('plugins/select2/css/select2.min.css') }}">
<link rel="stylesheet" href="{{ asset('plugins/select2-bootstrap4-theme/select2-bootstrap4.min.css') }}">
@endpush

@push('scripts')
<script src="{{ asset('plugins/select2/js/select2.full.min.js') }}"></script>
<script>
    $(function () {
        //Initialize Select2 Elements
        $('.select2').select2({
            theme: 'bootstrap4',
            language: 'ar',
            dir: 'rtl'
        });
        
        // تفعيل التوست للرسائل
        const Toast = Swal.mixin({
            toast: true,
            position: 'top-end',
            showConfirmButton: false,
            timer: 3000
        });
        
        // عرض رسائل الخطأ
        @if(session('error'))
        Toast.fire({
            icon: 'error',
            title: '{{ session("error") }}'
        });
        @endif
        
        // التحقق من تاريخ الانتهاء المتوقع
        $('#start_date, #expected_completion_date').on('change', function() {
            var startDate = new Date($('#start_date').val());
            var endDate = new Date($('#expected_completion_date').val());
            
            if (endDate < startDate) {
                Toast.fire({
                    icon: 'error',
                    title: 'تاريخ الانتهاء المتوقع يجب أن يكون بعد تاريخ البدء'
                });
                $('#expected_completion_date').val('');
            }
        });
    });
</script>
@endpush