@extends('layouts.modern')

@section('title', 'تفاصيل التدريب')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تفاصيل التدريب: {{ $training->title }}</h3>
                    <div>
                        <a href="{{ route('hrm.trainings.edit', $training->id) }}" class="btn btn-primary me-2">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        <a href="{{ route('hrm.trainings.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="row">
                        <!-- معلومات التدريب -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-primary text-white">
                                    <h5 class="mb-0">معلومات التدريب</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">العنوان</th>
                                            <td>{{ $training->title }}</td>
                                        </tr>
                                        <tr>
                                            <th>الحالة</th>
                                            <td>
                                                @if($training->status == 'planned')
                                                    <span class="badge bg-info">مخطط</span>
                                                @elseif($training->status == 'in_progress')
                                                    <span class="badge bg-primary">قيد التنفيذ</span>
                                                @elseif($training->status == 'completed')
                                                    <span class="badge bg-success">مكتمل</span>
                                                @elseif($training->status == 'cancelled')
                                                    <span class="badge bg-danger">ملغي</span>
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>نوع التدريب</th>
                                            <td>
                                                @if($training->training_type == 'technical')
                                                    تقني
                                                @elseif($training->training_type == 'soft_skills')
                                                    مهارات شخصية
                                                @elseif($training->training_type == 'safety')
                                                    سلامة وأمان
                                                @elseif($training->training_type == 'management')
                                                    إدارة
                                                @elseif($training->training_type == 'certification')
                                                    شهادة احترافية
                                                @elseif($training->training_type == 'other')
                                                    أخرى
                                                @else
                                                    {{ $training->training_type }}
                                                @endif
                                            </td>
                                        </tr>
                                        <tr>
                                            <th>المدرب</th>
                                            <td>{{ $training->trainer_name ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>المؤسسة التدريبية</th>
                                            <td>{{ $training->trainer_organization ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>مكان التدريب</th>
                                            <td>{{ $training->location ?: 'غير محدد' }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ البدء</th>
                                            <td>{{ $training->start_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تاريخ الانتهاء</th>
                                            <td>{{ $training->end_date->format('Y-m-d') }}</td>
                                        </tr>
                                        <tr>
                                            <th>المدة</th>
                                            <td>{{ $training->start_date->diffInDays($training->end_date) + 1 }} يوم</td>
                                        </tr>
                                        @if($training->cost)
                                        <tr>
                                            <th>تكلفة التدريب</th>
                                            <td>{{ number_format($training->cost, 2) }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>

                            @if($training->description)
                            <div class="card mb-4">
                                <div class="card-header bg-info text-white">
                                    <h5 class="mb-0">وصف التدريب</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($training->description)) !!}</p>
                                </div>
                            </div>
                            @endif

                            @if($training->notes)
                            <div class="card mb-4">
                                <div class="card-header bg-secondary text-white">
                                    <h5 class="mb-0">ملاحظات</h5>
                                </div>
                                <div class="card-body">
                                    <p>{!! nl2br(e($training->notes)) !!}</p>
                                </div>
                            </div>
                            @endif
                        </div>

                        <!-- المشاركين في التدريب -->
                        <div class="col-md-6">
                            <div class="card mb-4">
                                <div class="card-header bg-success text-white">
                                    <h5 class="mb-0">المشاركين في التدريب</h5>
                                </div>
                                <div class="card-body">
                                    @if($training->participants->count() > 0)
                                    <div class="table-responsive">
                                        <table class="table table-bordered table-striped">
                                            <thead>
                                                <tr>
                                                    <th>#</th>
                                                    <th>الموظف</th>
                                                    <th>الحالة</th>
                                                    <th>النتيجة</th>
                                                    <th>الإجراءات</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @foreach($training->participants as $participant)
                                                <tr>
                                                    <td>{{ $loop->iteration }}</td>
                                                    <td>{{ $participant->employee->full_name }}</td>
                                                    <td>
                                                        @if($participant->status == 'registered')
                                                            <span class="badge bg-info">مسجل</span>
                                                        @elseif($participant->status == 'attending')
                                                            <span class="badge bg-primary">يحضر</span>
                                                        @elseif($participant->status == 'completed')
                                                            <span class="badge bg-success">أكمل</span>
                                                        @elseif($participant->status == 'failed')
                                                            <span class="badge bg-danger">لم يكمل</span>
                                                        @elseif($participant->status == 'absent')
                                                            <span class="badge bg-warning">غائب</span>
                                                        @endif
                                                    </td>
                                                    <td>{{ $participant->result ?: 'غير محدد' }}</td>
                                                    <td>
                                                        <div class="btn-group" role="group">
                                                            <button type="button" class="btn btn-sm btn-primary" data-bs-toggle="modal" data-bs-target="#updateParticipantModal{{ $participant->id }}">
                                                                <i class="fas fa-edit"></i> تحديث
                                                            </button>
                                                            @if($training->status == 'completed' && $participant->status == 'completed')
                                                                <button type="button" class="btn btn-sm btn-success" data-bs-toggle="modal" data-bs-target="#issueCertificateModal{{ $participant->id }}">
                                                                    <i class="fas fa-certificate"></i> إصدار شهادة
                                                                </button>
                                                            @endif
                                                        </div>

                                                        <!-- Modal for Update Participant Status -->
                                                        <div class="modal fade" id="updateParticipantModal{{ $participant->id }}" tabindex="-1" aria-labelledby="updateParticipantModalLabel{{ $participant->id }}" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="updateParticipantModalLabel{{ $participant->id }}">تحديث حالة المشارك: {{ $participant->employee->full_name }}</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <form action="{{ route('hrm.trainings.participants.update', ['id' => $training->id, 'participantId' => $participant->id]) }}" method="POST">
                                                                        @csrf
                                                                        @method('PUT')
                                                                        <div class="modal-body">
                                                                            <div class="form-group mb-3">
                                                                                <label for="status{{ $participant->id }}" class="form-label">الحالة</label>
                                                                                <select class="form-select" id="status{{ $participant->id }}" name="status">
                                                                                    <option value="registered" {{ $participant->status == 'registered' ? 'selected' : '' }}>مسجل</option>
                                                                                    <option value="attending" {{ $participant->status == 'attending' ? 'selected' : '' }}>يحضر</option>
                                                                                    <option value="completed" {{ $participant->status == 'completed' ? 'selected' : '' }}>أكمل</option>
                                                                                    <option value="failed" {{ $participant->status == 'failed' ? 'selected' : '' }}>لم يكمل</option>
                                                                                    <option value="absent" {{ $participant->status == 'absent' ? 'selected' : '' }}>غائب</option>
                                                                                </select>
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="result{{ $participant->id }}" class="form-label">النتيجة</label>
                                                                                <input type="text" class="form-control" id="result{{ $participant->id }}" name="result" value="{{ $participant->result }}">
                                                                                <small class="form-text text-muted">مثال: ممتاز، جيد جداً، 85%، إلخ.</small>
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="notes{{ $participant->id }}" class="form-label">ملاحظات</label>
                                                                                <textarea class="form-control" id="notes{{ $participant->id }}" name="notes" rows="3">{{ $participant->notes }}</textarea>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                            <button type="submit" class="btn btn-primary">حفظ التغييرات</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- Modal for Issue Certificate -->
                                                        <div class="modal fade" id="issueCertificateModal{{ $participant->id }}" tabindex="-1" aria-labelledby="issueCertificateModalLabel{{ $participant->id }}" aria-hidden="true">
                                                            <div class="modal-dialog">
                                                                <div class="modal-content">
                                                                    <div class="modal-header">
                                                                        <h5 class="modal-title" id="issueCertificateModalLabel{{ $participant->id }}">إصدار شهادة للمشارك: {{ $participant->employee->full_name }}</h5>
                                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                    </div>
                                                                    <form action="{{ route('hrm.trainings.participants.certificate', ['id' => $training->id, 'participantId' => $participant->id]) }}" method="POST" enctype="multipart/form-data">
                                                                        @csrf
                                                                        <div class="modal-body">
                                                                            <div class="form-group mb-3">
                                                                                <label for="certificate_number{{ $participant->id }}" class="form-label">رقم الشهادة</label>
                                                                                <input type="text" class="form-control" id="certificate_number{{ $participant->id }}" name="certificate_number">
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="issue_date{{ $participant->id }}" class="form-label">تاريخ الإصدار</label>
                                                                                <input type="date" class="form-control" id="issue_date{{ $participant->id }}" name="issue_date" value="{{ date('Y-m-d') }}">
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="expiry_date{{ $participant->id }}" class="form-label">تاريخ الانتهاء</label>
                                                                                <input type="date" class="form-control" id="expiry_date{{ $participant->id }}" name="expiry_date">
                                                                                <small class="form-text text-muted">اتركه فارغاً إذا كانت الشهادة لا تنتهي</small>
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="certificate_file{{ $participant->id }}" class="form-label">ملف الشهادة</label>
                                                                                <input type="file" class="form-control" id="certificate_file{{ $participant->id }}" name="certificate_file">
                                                                                <small class="form-text text-muted">الملفات المسموحة: PDF, JPG, JPEG, PNG (الحد الأقصى: 5 ميجابايت)</small>
                                                                            </div>
                                                                            <div class="form-group mb-3">
                                                                                <label for="notes{{ $participant->id }}" class="form-label">ملاحظات</label>
                                                                                <textarea class="form-control" id="notes{{ $participant->id }}" name="notes" rows="2"></textarea>
                                                                            </div>
                                                                        </div>
                                                                        <div class="modal-footer">
                                                                            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">إلغاء</button>
                                                                            <button type="submit" class="btn btn-success">إصدار الشهادة</button>
                                                                        </div>
                                                                    </form>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </td>
                                                </tr>
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                    @else
                                    <p class="text-center">لا يوجد مشاركين في هذا التدريب</p>
                                    @endif
                                </div>
                            </div>

                            <div class="card mb-4">
                                <div class="card-header bg-warning text-dark">
                                    <h5 class="mb-0">معلومات إضافية</h5>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 30%">تاريخ الإنشاء</th>
                                            <td>{{ $training->created_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم الإنشاء بواسطة</th>
                                            <td>{{ $training->creator->name ?? 'غير معروف' }}</td>
                                        </tr>
                                        @if($training->updated_at && $training->updated_at->ne($training->created_at))
                                        <tr>
                                            <th>تاريخ آخر تحديث</th>
                                            <td>{{ $training->updated_at->format('Y-m-d H:i') }}</td>
                                        </tr>
                                        <tr>
                                            <th>تم التحديث بواسطة</th>
                                            <td>{{ $training->updater->name ?? 'غير معروف' }}</td>
                                        </tr>
                                        @endif
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection