@extends('layouts.modern')

@section('title', 'تعديل التدريب')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">تعديل التدريب: {{ $training->title }}</h3>
                    <div>
                        <a href="{{ route('hrm.trainings.show', $training->id) }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للتفاصيل
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('hrm.trainings.update', $training->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <!-- معلومات التدريب الأساسية -->
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="card-header bg-primary text-white">
                                        <h5 class="mb-0">معلومات التدريب الأساسية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="title" class="form-label">عنوان التدريب <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="title" name="title" value="{{ old('title', $training->title) }}" required>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="status" class="form-label">حالة التدريب <span class="text-danger">*</span></label>
                                            <select class="form-select" id="status" name="status" required>
                                                <option value="planned" {{ old('status', $training->status) == 'planned' ? 'selected' : '' }}>مخطط</option>
                                                <option value="in_progress" {{ old('status', $training->status) == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                                <option value="completed" {{ old('status', $training->status) == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                                <option value="cancelled" {{ old('status', $training->status) == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                            </select>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="training_type" class="form-label">نوع التدريب <span class="text-danger">*</span></label>
                                            <select class="form-select" id="training_type" name="training_type" required>
                                                <option value="technical" {{ old('training_type', $training->training_type) == 'technical' ? 'selected' : '' }}>تقني</option>
                                                <option value="soft_skills" {{ old('training_type', $training->training_type) == 'soft_skills' ? 'selected' : '' }}>مهارات شخصية</option>
                                                <option value="safety" {{ old('training_type', $training->training_type) == 'safety' ? 'selected' : '' }}>سلامة وأمان</option>
                                                <option value="management" {{ old('training_type', $training->training_type) == 'management' ? 'selected' : '' }}>إدارة</option>
                                                <option value="certification" {{ old('training_type', $training->training_type) == 'certification' ? 'selected' : '' }}>شهادة احترافية</option>
                                                <option value="other" {{ old('training_type', $training->training_type) == 'other' ? 'selected' : '' }}>أخرى</option>
                                            </select>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="description" class="form-label">وصف التدريب</label>
                                            <textarea class="form-control" id="description" name="description" rows="4">{{ old('description', $training->description) }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- معلومات المدرب والمكان -->
                            <div class="col-md-6">
                                <div class="card mb-4">
                                    <div class="card-header bg-info text-white">
                                        <h5 class="mb-0">معلومات المدرب والمكان</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="trainer_name" class="form-label">اسم المدرب</label>
                                            <input type="text" class="form-control" id="trainer_name" name="trainer_name" value="{{ old('trainer_name', $training->trainer_name) }}">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="trainer_organization" class="form-label">المؤسسة التدريبية</label>
                                            <input type="text" class="form-control" id="trainer_organization" name="trainer_organization" value="{{ old('trainer_organization', $training->trainer_organization) }}">
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="location" class="form-label">مكان التدريب</label>
                                            <input type="text" class="form-control" id="location" name="location" value="{{ old('location', $training->location) }}">
                                        </div>
                                        
                                        <div class="row">
                                            <div class="col-md-6 mb-3">
                                                <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                                <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date', $training->start_date->format('Y-m-d')) }}" required>
                                            </div>
                                            
                                            <div class="col-md-6 mb-3">
                                                <label for="end_date" class="form-label">تاريخ الانتهاء <span class="text-danger">*</span></label>
                                                <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date', $training->end_date->format('Y-m-d')) }}" required>
                                            </div>
                                        </div>
                                        
                                        <div class="mb-3">
                                            <label for="cost" class="form-label">تكلفة التدريب</label>
                                            <div class="input-group">
                                                <input type="number" step="0.01" class="form-control" id="cost" name="cost" value="{{ old('cost', $training->cost) }}">
                                                <span class="input-group-text">{{ config('app.currency', 'ريال') }}</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- ملاحظات إضافية -->
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-secondary text-white">
                                        <h5 class="mb-0">ملاحظات إضافية</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label for="notes" class="form-label">ملاحظات</label>
                                            <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes', $training->notes) }}</textarea>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- المشاركين في التدريب -->
                            <div class="col-md-12">
                                <div class="card mb-4">
                                    <div class="card-header bg-success text-white">
                                        <h5 class="mb-0">المشاركين في التدريب</h5>
                                    </div>
                                    <div class="card-body">
                                        <div class="mb-3">
                                            <label class="form-label">اختر الموظفين المشاركين</label>
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-striped">
                                                    <thead>
                                                        <tr>
                                                            <th style="width: 50px;">اختيار</th>
                                                            <th>الموظف</th>
                                                            <th>القسم</th>
                                                            <th>الحالة</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach($employees as $employee)
                                                        <tr>
                                                            <td class="text-center">
                                                                <div class="form-check">
                                                                    <input class="form-check-input" type="checkbox" 
                                                                        name="participants[]" 
                                                                        value="{{ $employee->id }}" 
                                                                        id="employee{{ $employee->id }}"
                                                                        {{ in_array($employee->id, $currentParticipants) ? 'checked' : '' }}>
                                                                </div>
                                                            </td>
                                                            <td>{{ $employee->full_name }}</td>
                                                            <td>{{ $employee->department->name ?? 'غير محدد' }}</td>
                                                            <td>
                                                                @if(in_array($employee->id, $currentParticipants))
                                                                    @php
                                                                        $participant = $training->participants->where('employee_id', $employee->id)->first();
                                                                    @endphp
                                                                    @if($participant)
                                                                        @if($participant->status == 'registered')
                                                                            <span class="badge bg-info">مسجل</span>
                                                                        @elseif($participant->status == 'attending')
                                                                            <span class="badge bg-primary">يحضر</span>
                                                                        @elseif($participant->status == 'completed')
                                                                            <span class="badge bg-success">أكمل</span>
                                                                        @elseif($participant->status == 'failed')
                                                                            <span class="badge bg-danger">لم يكمل</span>
                                                                        @elseif($participant->status == 'absent')
                                                                            <span class="badge bg-warning">غائب</span>
                                                                        @endif
                                                                    @endif
                                                                @else
                                                                    <span class="text-muted">غير مشارك</span>
                                                                @endif
                                                            </td>
                                                        </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- أزرار الإجراءات -->
                            <div class="col-12 text-center">
                                <button type="submit" class="btn btn-primary btn-lg px-5 mx-2">
                                    <i class="fas fa-save"></i> حفظ التغييرات
                                </button>
                                <a href="{{ route('hrm.trainings.show', $training->id) }}" class="btn btn-secondary btn-lg px-5 mx-2">
                                    <i class="fas fa-times"></i> إلغاء
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // التحقق من تواريخ البدء والانتهاء
        $('#end_date').change(function() {
            var startDate = new Date($('#start_date').val());
            var endDate = new Date($(this).val());
            
            if (endDate < startDate) {
                alert('تاريخ الانتهاء يجب أن يكون بعد تاريخ البدء');
                $(this).val('');
            }
        });
        
        $('#start_date').change(function() {
            var startDate = new Date($(this).val());
            var endDate = new Date($('#end_date').val());
            
            if ($('#end_date').val() && endDate < startDate) {
                alert('تاريخ البدء يجب أن يكون قبل تاريخ الانتهاء');
                $(this).val('');
            }
        });
    });
</script>
@endsection