@extends('layouts.modern')

@section('title', 'إضافة تدريب جديد')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">إضافة تدريب جديد</h3>
                    <a href="{{ route('hrm.trainings.index') }}" class="btn btn-secondary">
                        <i class="fas fa-arrow-right"></i> العودة للقائمة
                    </a>
                </div>

                <div class="card-body">
                    @if ($errors->any())
                        <div class="alert alert-danger">
                            <ul class="mb-0">
                                @foreach ($errors->all() as $error)
                                    <li>{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form action="{{ route('hrm.trainings.store') }}" method="POST">
                        @csrf
                        <div class="row mb-3">
                            <div class="col-md-6">
                                <div class="form-group mb-3">
                                    <label for="title" class="form-label">عنوان التدريب <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="title" name="title" value="{{ old('title') }}" required>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="trainer_name" class="form-label">اسم المدرب</label>
                                    <input type="text" class="form-control" id="trainer_name" name="trainer_name" value="{{ old('trainer_name') }}">
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="trainer_organization" class="form-label">المؤسسة التدريبية</label>
                                    <input type="text" class="form-control" id="trainer_organization" name="trainer_organization" value="{{ old('trainer_organization') }}">
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="location" class="form-label">مكان التدريب</label>
                                    <input type="text" class="form-control" id="location" name="location" value="{{ old('location') }}">
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="training_type" class="form-label">نوع التدريب</label>
                                    <select class="form-select" id="training_type" name="training_type">
                                        <option value="">-- اختر نوع التدريب --</option>
                                        <option value="technical" {{ old('training_type') == 'technical' ? 'selected' : '' }}>تقني</option>
                                        <option value="soft_skills" {{ old('training_type') == 'soft_skills' ? 'selected' : '' }}>مهارات شخصية</option>
                                        <option value="safety" {{ old('training_type') == 'safety' ? 'selected' : '' }}>سلامة وأمان</option>
                                        <option value="management" {{ old('training_type') == 'management' ? 'selected' : '' }}>إدارة</option>
                                        <option value="certification" {{ old('training_type') == 'certification' ? 'selected' : '' }}>شهادة احترافية</option>
                                        <option value="other" {{ old('training_type') == 'other' ? 'selected' : '' }}>أخرى</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="start_date" class="form-label">تاريخ البدء <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="start_date" name="start_date" value="{{ old('start_date') }}" required>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-3">
                                            <label for="end_date" class="form-label">تاريخ الانتهاء <span class="text-danger">*</span></label>
                                            <input type="date" class="form-control" id="end_date" name="end_date" value="{{ old('end_date') }}" required>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="cost" class="form-label">تكلفة التدريب</label>
                                    <input type="number" step="0.01" class="form-control" id="cost" name="cost" value="{{ old('cost') }}">
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="status" class="form-label">الحالة <span class="text-danger">*</span></label>
                                    <select class="form-select" id="status" name="status" required>
                                        <option value="planned" {{ old('status') == 'planned' ? 'selected' : '' }}>مخطط</option>
                                        <option value="in_progress" {{ old('status') == 'in_progress' ? 'selected' : '' }}>قيد التنفيذ</option>
                                        <option value="completed" {{ old('status') == 'completed' ? 'selected' : '' }}>مكتمل</option>
                                        <option value="cancelled" {{ old('status') == 'cancelled' ? 'selected' : '' }}>ملغي</option>
                                    </select>
                                </div>
                                
                                <div class="form-group mb-3">
                                    <label for="employees" class="form-label">الموظفين المشاركين</label>
                                    <select class="form-select" id="employees" name="employees[]" multiple>
                                        @foreach($employees as $employee)
                                            <option value="{{ $employee->id }}" {{ in_array($employee->id, old('employees', [])) ? 'selected' : '' }}>
                                                {{ $employee->full_name }} ({{ $employee->employee_number }})
                                            </option>
                                        @endforeach
                                    </select>
                                    <small class="form-text text-muted">اضغط Ctrl للاختيار المتعدد</small>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="description" class="form-label">وصف التدريب</label>
                            <textarea class="form-control" id="description" name="description" rows="4">{{ old('description') }}</textarea>
                        </div>
                        
                        <div class="form-group mb-3">
                            <label for="notes" class="form-label">ملاحظات</label>
                            <textarea class="form-control" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                        </div>
                        
                        <div class="form-group text-center">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> حفظ
                            </button>
                            <a href="{{ route('hrm.trainings.index') }}" class="btn btn-secondary">
                                <i class="fas fa-times"></i> إلغاء
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script>
    $(document).ready(function() {
        // تحقق من تاريخ البدء والانتهاء
        $('#end_date').change(function() {
            var startDate = new Date($('#start_date').val());
            var endDate = new Date($(this).val());
            
            if (endDate < startDate) {
                alert('تاريخ الانتهاء يجب أن يكون بعد تاريخ البدء');
                $(this).val('');
            }
        });
        
        $('#start_date').change(function() {
            var endDateField = $('#end_date');
            if (endDateField.val()) {
                var startDate = new Date($(this).val());
                var endDate = new Date(endDateField.val());
                
                if (endDate < startDate) {
                    alert('تاريخ الانتهاء يجب أن يكون بعد تاريخ البدء');
                    endDateField.val('');
                }
            }
        });
    });
</script>
@endsection