@extends('layouts.modern')

@section('title', 'تفاصيل شريحة الضريبة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">تفاصيل شريحة الضريبة: {{ $taxBracket->name }}</h3>
                    <div>
                        @can('edit_tax_brackets')
                        <a href="{{ route('hrm.tax-brackets.edit', $taxBracket->id) }}" class="btn btn-warning">
                            <i class="fas fa-edit"></i> تعديل
                        </a>
                        @endcan
                        <a href="{{ route('hrm.tax-brackets.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%">الشركة</th>
                                    <td>{{ $taxBracket->company->name }}</td>
                                </tr>
                                <tr>
                                    <th>اسم الشريحة</th>
                                    <td>{{ $taxBracket->name }}</td>
                                </tr>
                                <tr>
                                    <th>الحد الأدنى للدخل</th>
                                    <td>{{ number_format($taxBracket->min_amount, 2) }}</td>
                                </tr>
                            </table>
                        </div>
                        
                        <div class="col-md-6">
                            <table class="table table-bordered">
                                <tr>
                                    <th style="width: 40%">الحد الأقصى للدخل</th>
                                    <td>{{ $taxBracket->max_amount > 0 ? number_format($taxBracket->max_amount, 2) : 'غير محدود' }}</td>
                                </tr>
                                <tr>
                                    <th>نسبة الضريبة</th>
                                    <td>{{ $taxBracket->tax_rate }}%</td>
                                </tr>
                                <tr>
                                    <th>الحالة</th>
                                    <td>
                                        @if($taxBracket->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                </tr>
                            </table>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">أمثلة على حساب الضريبة</h4>
                                </div>
                                <div class="card-body">
                                    <div class="table-responsive">
                                        <table class="table table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>الدخل</th>
                                                    <th>الدخل الخاضع للضريبة</th>
                                                    <th>مبلغ الضريبة</th>
                                                </tr>
                                            </thead>
                                            <tbody>
                                                @php
                                                    $examples = [
                                                        $taxBracket->min_amount - 1,
                                                        $taxBracket->min_amount,
                                                        $taxBracket->min_amount + 1000,
                                                        $taxBracket->max_amount > 0 ? $taxBracket->max_amount : $taxBracket->min_amount + 5000,
                                                        $taxBracket->max_amount > 0 ? $taxBracket->max_amount + 1000 : $taxBracket->min_amount + 10000
                                                    ];
                                                @endphp
                                                
                                                @foreach($examples as $income)
                                                    @if($income > 0)
                                                        @php
                                                            if ($income <= $taxBracket->min_amount) {
                                                                $taxableAmount = 0;
                                                                $taxAmount = 0;
                                                            } else {
                                                                if ($taxBracket->max_amount > 0 && $income > $taxBracket->max_amount) {
                                                                    $taxableAmount = $taxBracket->max_amount - $taxBracket->min_amount;
                                                                } else {
                                                                    $taxableAmount = $income - $taxBracket->min_amount;
                                                                }
                                                                $taxAmount = $taxableAmount * ($taxBracket->tax_rate / 100);
                                                            }
                                                        @endphp
                                                        <tr>
                                                            <td>{{ number_format($income, 2) }}</td>
                                                            <td>{{ number_format($taxableAmount, 2) }}</td>
                                                            <td>{{ number_format($taxAmount, 2) }}</td>
                                                        </tr>
                                                    @endif
                                                @endforeach
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="row mt-4">
                        <div class="col-md-12">
                            <div class="card">
                                <div class="card-header">
                                    <h4 class="card-title">معلومات إضافية</h4>
                                </div>
                                <div class="card-body">
                                    <table class="table table-bordered">
                                        <tr>
                                            <th style="width: 25%">تاريخ الإنشاء</th>
                                            <td>{{ $taxBracket->created_at->format('Y-m-d H:i') }}</td>
                                            <th style="width: 25%">بواسطة</th>
                                            <td>{{ $taxBracket->createdBy ? $taxBracket->createdBy->name : 'غير معروف' }}</td>
                                        </tr>
                                        <tr>
                                            <th>آخر تحديث</th>
                                            <td>{{ $taxBracket->updated_at->format('Y-m-d H:i') }}</td>
                                            <th>بواسطة</th>
                                            <td>{{ $taxBracket->updatedBy ? $taxBracket->updatedBy->name : 'غير معروف' }}</td>
                                        </tr>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection