@extends('layouts.modern')

@section('title', 'شرائح الضرائب')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">شرائح الضرائب</h3>
                    @can('create_tax_brackets')
                    <a href="{{ route('hrm.tax-brackets.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus"></i> إضافة شريحة جديدة
                    </a>
                    @endcan
                </div>
                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif
                    
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>الاسم</th>
                                    <th>الحد الأدنى</th>
                                    <th>الحد الأقصى</th>
                                    <th>نسبة الضريبة</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($taxBrackets as $bracket)
                                <tr>
                                    <td>{{ $bracket->id }}</td>
                                    <td>{{ $bracket->name }}</td>
                                    <td>{{ number_format($bracket->min_amount, 2) }}</td>
                                    <td>{{ $bracket->max_amount > 0 ? number_format($bracket->max_amount, 2) : 'غير محدود' }}</td>
                                    <td>{{ $bracket->tax_rate }}%</td>
                                    <td>
                                        @if($bracket->is_active)
                                            <span class="badge badge-success">نشط</span>
                                        @else
                                            <span class="badge badge-danger">غير نشط</span>
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group">
                                            <a href="{{ route('hrm.tax-brackets.show', $bracket->id) }}" class="btn btn-sm btn-info">
                                                <i class="fas fa-eye"></i>
                                            </a>
                                            
                                            @can('edit_tax_brackets')
                                            <a href="{{ route('hrm.tax-brackets.edit', $bracket->id) }}" class="btn btn-sm btn-warning">
                                                <i class="fas fa-edit"></i>
                                            </a>
                                            @endcan
                                            
                                            @can('delete_tax_brackets')
                                            <form action="{{ route('hrm.tax-brackets.destroy', $bracket->id) }}" method="POST" class="d-inline">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من حذف هذه الشريحة؟')">
                                                    <i class="fas fa-trash"></i>
                                                </button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                                @empty
                                <tr>
                                    <td colspan="7" class="text-center">لا توجد شرائح ضرائب</td>
                                </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>
                    
                    <div class="mt-4">
                        {{ $taxBrackets->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection