@extends('layouts.modern')

@section('title', 'تعديل شريحة الضريبة')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">تعديل شريحة الضريبة: {{ $taxBracket->name }}</h3>
                </div>
                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif
                    
                    <form action="{{ route('hrm.tax-brackets.update', $taxBracket->id) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="name">اسم الشريحة</label>
                                    <input type="text" name="name" id="name" class="form-control @error('name') is-invalid @enderror" value="{{ old('name', $taxBracket->name) }}" required>
                                    @error('name')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="min_amount">الحد الأدنى للدخل</label>
                                    <input type="number" name="min_amount" id="min_amount" class="form-control @error('min_amount') is-invalid @enderror" value="{{ old('min_amount', $taxBracket->min_amount) }}" min="0" step="0.01" required>
                                    @error('min_amount')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="max_amount">الحد الأقصى للدخل (0 = غير محدود)</label>
                                    <input type="number" name="max_amount" id="max_amount" class="form-control @error('max_amount') is-invalid @enderror" value="{{ old('max_amount', $taxBracket->max_amount) }}" min="0" step="0.01" required>
                                    @error('max_amount')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tax_rate">نسبة الضريبة (%)</label>
                                    <input type="number" name="tax_rate" id="tax_rate" class="form-control @error('tax_rate') is-invalid @enderror" value="{{ old('tax_rate', $taxBracket->tax_rate) }}" min="0" max="100" step="0.01" required>
                                    @error('tax_rate')
                                        <span class="invalid-feedback">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <div class="custom-control custom-switch mt-4">
                                        <input type="checkbox" class="custom-control-input" id="is_active" name="is_active" {{ old('is_active', $taxBracket->is_active) ? 'checked' : '' }}>
                                        <label class="custom-control-label" for="is_active">نشط</label>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="form-group mt-4">
                            <button type="submit" class="btn btn-primary">تحديث</button>
                            <a href="{{ route('hrm.tax-brackets.index') }}" class="btn btn-secondary">إلغاء</a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection