@extends('layouts.modern')

@section('title', 'المهام القادمة')

@section('content')
<div class="container-fluid">
    <div class="row justify-content-center">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="mb-0">المهام القادمة</h3>
                    <div>
                        <a href="{{ route('hrm.tasks.overdue') }}" class="btn btn-danger me-2">
                            <i class="fas fa-exclamation-circle"></i> المهام المتأخرة
                        </a>
                        <a href="{{ route('hrm.tasks.index') }}" class="btn btn-secondary">
                            <i class="fas fa-arrow-right"></i> العودة للقائمة
                        </a>
                    </div>
                </div>

                <div class="card-body">
                    @if(session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @endif

                    <div class="alert alert-warning">
                        <i class="fas fa-clock"></i> هذه المهام مستحقة خلال الأيام السبعة القادمة.
                    </div>

                    <div class="table-responsive">
                        <table class="table table-bordered table-striped">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>العنوان</th>
                                    <th>الموظفين المكلفين</th>
                                    <th>الأولوية</th>
                                    <th>تاريخ الاستحقاق</th>
                                    <th>الوقت المتبقي</th>
                                    <th>الحالة</th>
                                    <th>الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($upcomingTasks as $task)
                                    <tr>
                                        <td>{{ $loop->iteration + ($upcomingTasks->currentPage() - 1) * $upcomingTasks->perPage() }}</td>
                                        <td>{{ $task->title }}</td>
                                        <td>
                                            @foreach($task->assignees as $assignee)
                                                <span class="badge bg-info">{{ $assignee->employee->full_name }}</span>
                                            @endforeach
                                        </td>
                                        <td>
                                            @if($task->priority == 'low')
                                                <span class="badge bg-success">منخفضة</span>
                                            @elseif($task->priority == 'medium')
                                                <span class="badge bg-info">متوسطة</span>
                                            @elseif($task->priority == 'high')
                                                <span class="badge bg-warning">عالية</span>
                                            @elseif($task->priority == 'urgent')
                                                <span class="badge bg-danger">عاجلة</span>
                                            @endif
                                        </td>
                                        <td>{{ $task->due_date->format('Y-m-d') }}</td>
                                        <td>
                                            @if($task->due_date->isToday())
                                                <span class="text-danger fw-bold">اليوم!</span>
                                            @elseif($task->due_date->isTomorrow())
                                                <span class="text-warning fw-bold">غداً</span>
                                            @else
                                                <span class="text-info">{{ $task->due_date->diffForHumans(['parts' => 1]) }}</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($task->status == 'pending')
                                                <span class="badge bg-secondary">قيد الانتظار</span>
                                            @elseif($task->status == 'in_progress')
                                                <span class="badge bg-primary">قيد التنفيذ</span>
                                            @elseif($task->status == 'on_hold')
                                                <span class="badge bg-warning">معلقة</span>
                                            @endif
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('hrm.tasks.show', $task->id) }}" class="btn btn-sm btn-info">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('hrm.tasks.edit', $task->id) }}" class="btn btn-sm btn-primary">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="text-center">لا توجد مهام قادمة</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    <div class="d-flex justify-content-center mt-4">
                        {{ $upcomingTasks->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection